/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.websockets.niagara.rfc6455;

import com.tridium.websockets.ByteUtil;
import com.tridium.websockets.SocketClosedException;
import com.tridium.websockets.WebSocketCloseReason;
import com.tridium.websockets.niagara.NWebSocket;
import com.tridium.websockets.niagara.WebSocketCloser;
import com.tridium.websockets.niagara.rfc6455.RFC6455Frame;
import com.tridium.websockets.niagara.rfc6455.RFC6455Message;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.baja.nre.util.Base64;
import javax.baja.nre.util.ByteBuffer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class RFC6455WebSocket
extends NWebSocket {
    public static final String RFC4122_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private ByteBuffer buffer;
    private int maxPayloadSize;

    public byte[] parse() throws IOException, SocketClosedException {
        try {
            return this.parseCompleteMessage(this.getContext().getInputStream());
        }
        catch (SocketClosedException socketClosedException) {
            this.cleanup();
            throw socketClosedException;
        }
    }

    public byte[] parseCompleteMessage(InputStream inputStream) throws SocketClosedException {
        RFC6455Frame rFC6455Frame;
        this.buffer.reset();
        do {
            try {
                rFC6455Frame = RFC6455Frame.parse(inputStream);
            }
            catch (IOException iOException) {
                throw new SocketClosedException(WebSocketCloseReason.UNEXPECTED_CONDITION, "Socket closed unexpectedly");
            }
            if (rFC6455Frame.getOpcode() == 8) {
                throw new SocketClosedException(WebSocketCloseReason.NORMAL);
            }
            this.buffer.write(rFC6455Frame.getPayload());
        } while (!rFC6455Frame.isFin());
        return this.buffer.toByteArray();
    }

    public void doClose(WebSocketCloseReason webSocketCloseReason, byte[] byArray) throws IOException {
        int n = RFC6455WebSocket.getCloseCode(webSocketCloseReason);
        byte[] byArray2 = RFC6455WebSocket.createCloseFrameBytes(n, byArray);
        this.sendMessage((byte)8, byArray2);
        this.cleanup();
    }

    public void doWrite(byte[] byArray) throws IOException {
        this.sendMessage((byte)1, byArray);
    }

    private final void sendMessage(byte by, byte[] byArray) throws IOException {
        RFC6455Message rFC6455Message = new RFC6455Message(8, by, null, byArray, 0, byArray.length);
        rFC6455Message.setMaxPayloadSize(this.maxPayloadSize);
        rFC6455Message.write(this.getContext().getOutputStream());
    }

    public void cleanup() {
        WebSocketCloser.cleanupSocket(this);
    }

    public void setMaxPayloadSize(int n) {
        this.maxPayloadSize = n;
    }

    public static String getAccept(String string) throws NoSuchAlgorithmException {
        String string2 = string + RFC4122_GUID;
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        messageDigest.update(ByteUtil.getUTF8Bytes(string2));
        byte[] byArray = messageDigest.digest();
        String string3 = Base64.encode((byte[])byArray);
        return string3;
    }

    public static int getCloseCode(WebSocketCloseReason webSocketCloseReason) {
        if (webSocketCloseReason == WebSocketCloseReason.NORMAL) {
            return 1000;
        }
        if (webSocketCloseReason == WebSocketCloseReason.GOING_AWAY) {
            return 1001;
        }
        if (webSocketCloseReason == WebSocketCloseReason.PROTOCOL_ERROR) {
            return 1002;
        }
        if (webSocketCloseReason == WebSocketCloseReason.CANNOT_ACCEPT_DATA) {
            return 1003;
        }
        if (webSocketCloseReason == WebSocketCloseReason.INCONSISTENT_DATA) {
            return 1007;
        }
        if (webSocketCloseReason == WebSocketCloseReason.POLICY_VIOLATION) {
            return 1008;
        }
        if (webSocketCloseReason == WebSocketCloseReason.MESSAGE_TOO_BIG) {
            return 1009;
        }
        if (webSocketCloseReason == WebSocketCloseReason.EXTENSION_NEGOTIATION_FAILURE) {
            return 1010;
        }
        if (webSocketCloseReason == WebSocketCloseReason.UNEXPECTED_CONDITION) {
            return 1011;
        }
        return 0;
    }

    public static byte[] createCloseFrameBytes(int n, byte[] byArray) {
        byte[] byArray2;
        if (byArray != null && byArray.length > 123) {
            throw new IllegalArgumentException("A control frame cannot contain more than 125 bytes");
        }
        if (byArray == null) {
            byArray2 = new byte[2];
        } else {
            byArray2 = new byte[byArray.length + 2];
            System.arraycopy(byArray, 0, byArray2, 2, byArray.length);
        }
        byArray2[0] = (byte)(n >> 8);
        byArray2[1] = (byte)n;
        return byArray2;
    }

    private final /* synthetic */ void this() {
        this.buffer = new ByteBuffer(1024);
        this.maxPayloadSize = 1024;
    }

    public RFC6455WebSocket() {
        this.this();
    }
}

