/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.websockets.niagara.rfc6455;

import com.tridium.websockets.HandshakeException;
import com.tridium.websockets.WebSocketContext;
import com.tridium.websockets.niagara.ServerWebSocketContext;
import com.tridium.websockets.niagara.rfc6455.RFC6455WebSocket;
import javax.baja.web.WebOp;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RFC6455ServerWebSocket
extends RFC6455WebSocket {
    private String key;
    private WebOp op;
    private WebSocketContext ctx;

    public String getKey() {
        return this.key;
    }

    public WebSocketContext getContext() {
        return this.ctx;
    }

    public void doHandshake() throws HandshakeException {
        this.acceptHandshake(this.op);
    }

    public void acceptHandshake(WebOp webOp) throws HandshakeException {
        HttpServletRequest httpServletRequest = webOp.getRequest();
        HttpServletResponse httpServletResponse = webOp.getResponse();
        String string = httpServletRequest.getHeader("Sec-WebSocket-Key");
        if (string != null) {
            try {
                String string2 = RFC6455ServerWebSocket.getAccept(string);
                httpServletResponse.setHeader("Upgrade", "websocket");
                httpServletResponse.setHeader("Connection", "Upgrade");
                httpServletResponse.setHeader("Sec-WebSocket-Accept", string2);
                httpServletResponse.setStatus(101);
                httpServletResponse.flushBuffer();
                httpServletResponse.getOutputStream();
            }
            catch (Exception exception) {
                throw new HandshakeException(exception);
            }
        } else {
            throw new HandshakeException("Missing Sec-WebSocket-Key header");
        }
    }

    public RFC6455ServerWebSocket(WebOp webOp) {
        this.op = webOp;
        this.ctx = new ServerWebSocketContext(webOp);
        this.key = webOp.getRequest().getHeader("Sec-WebSocket-Key");
    }
}

