/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.websockets.niagara.hybi00;

import com.tridium.websockets.ByteUtil;
import com.tridium.websockets.HandshakeException;
import com.tridium.websockets.SocketClosedException;
import com.tridium.websockets.WebSocketCloseReason;
import com.tridium.websockets.niagara.NWebSocket;
import com.tridium.websockets.niagara.WebSocketCloser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.baja.nre.util.ByteBuffer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class Hybi00WebSocket
extends NWebSocket {
    private ByteBuffer buffer;

    public byte[] parse() throws IOException, SocketClosedException {
        try {
            return this.parseCompleteMessage(this.getContext().getInputStream());
        }
        catch (SocketClosedException socketClosedException) {
            this.cleanup();
            throw socketClosedException;
        }
    }

    public byte[] parseCompleteMessage(InputStream inputStream) throws IOException, SocketClosedException {
        int n = inputStream.read();
        if (n == -1) {
            throw new SocketClosedException(WebSocketCloseReason.NORMAL);
        }
        if (n == 0) {
            this.buffer.reset();
            while ((n = inputStream.read()) != 255) {
                this.buffer.write(n);
            }
            return this.buffer.toByteArray();
        }
        throw new SocketClosedException(WebSocketCloseReason.PROTOCOL_ERROR, "Invalid frame start byte (expected 0): " + n);
    }

    public void doWrite(byte[] byArray) throws IOException {
        OutputStream outputStream = this.getContext().getOutputStream();
        outputStream.write(0);
        outputStream.write(byArray);
        outputStream.write(255);
        outputStream.flush();
    }

    public void doClose(WebSocketCloseReason webSocketCloseReason, byte[] byArray) throws IOException {
        OutputStream outputStream = this.getContext().getOutputStream();
        outputStream.write(255);
        outputStream.write(0);
        outputStream.flush();
        this.cleanup();
    }

    public void cleanup() {
        WebSocketCloser.cleanupSocket(this);
    }

    public static long keyToNumber(String string) throws HandshakeException {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer(32);
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (c == ' ') {
                ++n;
            } else if (c >= '0' && c <= '9') {
                stringBuffer.append(c);
            }
            ++n2;
        }
        if (n == 0) {
            throw new HandshakeException("No spaces in handshake key");
        }
        String string2 = stringBuffer.toString();
        long l = Long.parseLong(string2);
        return l / (long)n;
    }

    public static byte[] handshakeProof(long l, long l2, byte[] byArray) throws HandshakeException {
        byte[] byArray2 = new byte[16];
        byte[] byArray3 = ByteUtil.longToBytes(l, 4);
        byte[] byArray4 = ByteUtil.longToBytes(l2, 4);
        System.arraycopy(byArray3, 0, byArray2, 0, 4);
        System.arraycopy(byArray4, 0, byArray2, 4, 4);
        System.arraycopy(byArray, 0, byArray2, 8, 8);
        try {
            return Hybi00WebSocket.md5(byArray2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new HandshakeException("Could not load MD5 algorithm");
        }
    }

    public static byte[] md5(byte[] byArray) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        messageDigest.reset();
        messageDigest.update(byArray);
        return messageDigest.digest();
    }

    private final /* synthetic */ void this() {
        this.buffer = new ByteBuffer(1024);
    }

    public Hybi00WebSocket() {
        this.this();
    }
}

