/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.websockets.niagara.hybi00;

import com.tridium.websockets.ByteUtil;
import com.tridium.websockets.HandshakeException;
import com.tridium.websockets.WebSocketContext;
import com.tridium.websockets.niagara.ServerWebSocketContext;
import com.tridium.websockets.niagara.hybi00.Hybi00WebSocket;
import java.io.IOException;
import java.io.InputStream;
import javax.baja.nre.util.Base64;
import javax.baja.web.WebOp;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Hybi00ServerWebSocket
extends Hybi00WebSocket {
    private String key;
    private WebOp op;
    private WebSocketContext ctx;

    public WebSocketContext getContext() {
        return this.ctx;
    }

    public String getKey() {
        return this.key;
    }

    public void doHandshake() throws HandshakeException {
        this.acceptHandshake(this.op);
    }

    public void acceptHandshake(WebOp webOp) throws HandshakeException {
        HttpServletRequest httpServletRequest = webOp.getRequest();
        HttpServletResponse httpServletResponse = webOp.getResponse();
        String string = Hybi00ServerWebSocket.getLocationPrefix(httpServletRequest.getScheme());
        byte[] byArray = Hybi00ServerWebSocket.getHandshakeProof(httpServletRequest);
        try {
            httpServletResponse.setStatus(101);
            httpServletResponse.setHeader("Connection", "Upgrade");
            httpServletResponse.setHeader("Upgrade", "WebSocket");
            httpServletResponse.setHeader("Sec-WebSocket-Origin", httpServletRequest.getHeader("origin"));
            httpServletResponse.setHeader("Sec-WebSocket-Location", string + httpServletRequest.getHeader("host") + httpServletRequest.getRequestURI());
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            servletOutputStream.write(byArray);
            this.key = Base64.encode((byte[])byArray);
            servletOutputStream.flush();
        }
        catch (IOException iOException) {
            throw new HandshakeException("Could not write to output stream");
        }
    }

    private static final byte[] readToken(HttpServletRequest httpServletRequest) throws HandshakeException {
        try {
            ServletInputStream servletInputStream = httpServletRequest.getInputStream();
            return ByteUtil.readBytes((InputStream)servletInputStream, 8);
        }
        catch (IOException iOException) {
            throw new HandshakeException("Could not read token from input stream");
        }
    }

    public static byte[] getHandshakeProof(HttpServletRequest httpServletRequest) throws HandshakeException {
        byte[] byArray = Hybi00ServerWebSocket.readToken(httpServletRequest);
        String string = httpServletRequest.getHeader("sec-websocket-key1");
        String string2 = httpServletRequest.getHeader("sec-websocket-key2");
        long l = Hybi00ServerWebSocket.keyToNumber(string);
        long l2 = Hybi00ServerWebSocket.keyToNumber(string2);
        return Hybi00ServerWebSocket.handshakeProof(l, l2, byArray);
    }

    public static String getLocationPrefix(String string) throws HandshakeException {
        if ("http".equalsIgnoreCase(string)) {
            return "ws://";
        }
        if ("https".equalsIgnoreCase(string)) {
            return "wss://";
        }
        throw new HandshakeException("Unrecognized scheme " + string);
    }

    public Hybi00ServerWebSocket(WebOp webOp) {
        this.op = webOp;
        this.ctx = new ServerWebSocketContext(webOp);
    }
}

