/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.websockets.niagara;

import com.tridium.websockets.ByteUtil;
import com.tridium.websockets.SocketClosedException;
import com.tridium.websockets.WebSocket;
import com.tridium.websockets.WebSocketCloseReason;
import com.tridium.websockets.WebSocketEventHandler;
import java.io.IOException;
import javax.baja.log.Log;

public class WebSocketMessageReceiver
extends Thread {
    private static int counter = 0;
    private static Log LOG = Log.getLog((String)"websockets.niagara");
    private WebSocket socket;
    private WebSocketEventHandler handler;

    public void closeSocket(WebSocketCloseReason webSocketCloseReason, String string) {
        try {
            this.socket.close(webSocketCloseReason, ByteUtil.getUTF8Bytes(string));
        }
        catch (IOException iOException) {
            LOG.warning("WebSocketMessageReceiver: IOException closing socket", (Throwable)iOException);
        }
    }

    public void run() {
        try {
            while (true) {
                byte[] byArray = this.socket.parse();
                this.handler.onMessage(byArray, this.socket.getContext());
            }
        }
        catch (IOException iOException) {
            LOG.trace("WebSocketMessageReceiver: IOException during web socket channel polling:", (Throwable)iOException);
            this.closeSocket(WebSocketCloseReason.NORMAL, "IOException reading from socket");
        }
        catch (SocketClosedException socketClosedException) {
            if (LOG.isTraceOn()) {
                LOG.trace("WebSocketMessageReceiver: Client closed socket " + this.socket.getKey());
            }
            this.closeSocket(socketClosedException.getReason(), "Client closed socket");
        }
    }

    private static final int getNextCounter() {
        return counter++;
    }

    public WebSocketMessageReceiver(WebSocket webSocket, WebSocketEventHandler webSocketEventHandler) {
        super("WebSocketMessageReceiver-" + WebSocketMessageReceiver.getNextCounter());
        this.socket = webSocket;
        this.handler = webSocketEventHandler;
    }
}

