/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.websockets.niagara;

import com.tridium.websockets.WebSocket;
import com.tridium.websockets.WebSocketCloseReason;
import com.tridium.websockets.WebSocketEventHandler;
import com.tridium.websockets.WebSocketState;
import com.tridium.websockets.WebSocketUtil;
import java.util.Date;
import javax.baja.log.Log;
import javax.baja.sys.Context;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WebSocketCloser
extends WebSocketEventHandler {
    public static final long DEFAULT_TIMEOUT = 10000L;
    private static Log LOG = Log.getLog((String)"websockets.niagara");
    private boolean active;
    private WaitThread waitThread;
    private long timeout;

    public static void cleanupSocket(WebSocket webSocket) {
        WebSocketCloser.cleanupSocket(webSocket, 10000L);
    }

    public static void cleanupSocket(WebSocket webSocket, long l) {
        if (webSocket.getState() != WebSocketState.OPEN) {
            return;
        }
        WebSocketCloser webSocketCloser = new WebSocketCloser(webSocket, l);
        webSocketCloser.start();
        webSocket.attachHandler(webSocketCloser);
    }

    public void start() {
        this.waitThread.start();
    }

    public void onClose(WebSocketCloseReason webSocketCloseReason, Context context) {
        if (LOG.isTraceOn()) {
            LOG.trace("WebSocketCloser: onClose fired for socket " + this.getSocket().getKey());
        }
        if (this.active) {
            this.cleanup();
        }
        this.active = false;
    }

    public void cleanup() {
        WebSocketUtil.closeSocketStreams(this.getSocket());
    }

    private final /* synthetic */ void this() {
        this.active = true;
        this.timeout = 10000L;
    }

    private WebSocketCloser(WebSocket webSocket, long l) {
        super(webSocket);
        this.this();
        this.timeout = l;
        this.waitThread = new WaitThread();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class WaitThread
    extends Thread {
        public void run() {
            long l = new Date().getTime();
            do {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                if (!WebSocketCloser.this.active || WebSocketCloser.this.getSocket().getState() != WebSocketState.CLOSED) continue;
                WebSocketCloser.this.onClose(null, null);
            } while (WebSocketCloser.this.active && new Date().getTime() - l <= WebSocketCloser.this.timeout);
            if (WebSocketCloser.this.active) {
                WebSocketCloser.this.onClose(null, null);
            }
        }

        private WaitThread() {
        }
    }
}

