/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.websockets.niagara;

import com.tridium.websockets.WebSocketContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import javax.baja.net.HttpConnection;
import javax.baja.sys.BasicContext;

public class ClientWebSocketContext
extends BasicContext
implements WebSocketContext {
    private HttpConnection conn;
    private String remoteHost;
    private String requestURI;
    private String scheme;

    public String getRequestURI() {
        return this.requestURI;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public String getScheme() {
        return this.scheme;
    }

    public InputStream getInputStream() throws IOException {
        if (this.conn.getSocket() != null) {
            return this.conn.getSocket().getInputStream();
        }
        throw new IOException("Connection closed");
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.conn.getSocket() != null) {
            return this.conn.getSocket().getOutputStream();
        }
        throw new IOException("Connection closed");
    }

    public ClientWebSocketContext(HttpConnection httpConnection) {
        InetAddress inetAddress;
        if (httpConnection == null) {
            throw new IllegalArgumentException("HttpConnection required");
        }
        this.conn = httpConnection;
        this.requestURI = httpConnection.getUri();
        Socket socket = httpConnection.getSocket();
        if (socket != null && (inetAddress = socket.getInetAddress()) != null) {
            this.remoteHost = inetAddress.getHostName();
        }
        if (this.requestURI != null && this.requestURI.indexOf("://") >= 0) {
            this.scheme = this.requestURI.substring(this.requestURI.indexOf("://"));
        }
    }
}

