/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.websockets;

import com.tridium.websockets.WebSocket;
import com.tridium.websockets.WebSocketContext;
import java.io.IOException;
import javax.baja.log.Log;

public class WebSocketUtil {
    private static Log LOG = Log.getLog((String)"websockets");

    public static void closeSocketStreams(WebSocket webSocket) {
        if (LOG.isTraceOn()) {
            LOG.trace("WebSocketUtil: closing streams for socket " + webSocket.getKey());
        }
        WebSocketContext webSocketContext = webSocket.getContext();
        try {
            if (webSocketContext.getInputStream() != null) {
                webSocketContext.getInputStream().close();
            }
        }
        catch (IOException iOException) {
            LOG.error("IOException closing request input stream: ", (Throwable)iOException);
        }
        try {
            if (webSocketContext.getOutputStream() != null) {
                webSocketContext.getOutputStream().close();
            }
        }
        catch (IOException iOException) {
            LOG.error("IOException closing response output stream: ", (Throwable)iOException);
        }
    }
}

