/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.websockets;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.baja.log.Log;

public class ByteUtil {
    private static Log LOG = Log.getLog((String)"websockets");

    public static byte[] longToBytes(long l, int n) {
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n - 1 - n2] = (byte)l;
            l >>= 8;
            ++n2;
        }
        return byArray;
    }

    public static int readInt(InputStream inputStream, int n) throws IOException {
        byte[] byArray = ByteUtil.readBytes(inputStream, n);
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = byArray[n3] & 0xFF;
            n2 += n4 << (n - n3 - 1) * 8;
            n3 = (byte)(n3 + 1);
        }
        return n2;
    }

    public static byte[] readBytes(InputStream inputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = inputStream.read(byArray);
        if (n2 < n) {
            throw new IOException("Only read " + n2 + " bytes out of " + n + " expected");
        }
        return byArray;
    }

    public static String toUTF8String(byte[] byArray) {
        try {
            return new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOG.error("Running on a platform that does not support UTF-8!", (Throwable)unsupportedEncodingException);
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public static String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        int n = 0;
        while (n < byArray.length) {
            byte by = byArray[n];
            String string = Integer.toHexString(by);
            int n2 = string.length();
            if (n2 == 1) {
                stringBuffer.append("0").append(string);
            } else {
                stringBuffer.append(string.substring(n2 - 2));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static byte[] getUTF8Bytes(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOG.error("Running on a platform that does not support UTF-8!", (Throwable)unsupportedEncodingException);
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public static byte[] cloneBytes(byte[] byArray) {
        if (byArray == null) {
            return new byte[0];
        }
        return (byte[])byArray.clone();
    }
}

