/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.websockets;

import com.tridium.websockets.BIWebSocketAcceptor;
import com.tridium.websockets.BWebSocketDispatch;
import com.tridium.websockets.HandshakeException;
import com.tridium.websockets.NoSocketsAvailableException;
import com.tridium.websockets.SocketRejectedException;
import com.tridium.websockets.WebSocket;
import com.tridium.websockets.WebSocketFactory;
import com.tridium.websockets.WebSocketUtil;
import com.tridium.websockets.niagara.NWebSocketFactory;
import java.io.IOException;
import javax.baja.log.Log;
import javax.baja.security.BPermissions;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.BWebServlet;
import javax.baja.web.WebOp;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BWebSocketServlet
extends BWebServlet {
    public static final Property servletName = BWebSocketServlet.newProperty((int)5, (String)"ws", null);
    public static final Property dispatch = BWebSocketServlet.newProperty((int)4, (BValue)new BWebSocketDispatch(), null);
    public static final Type TYPE;
    private static Log LOG;
    private WebSocketFactory factory;
    static /* synthetic */ Class class$com$tridium$websockets$BWebSocketServlet;

    public String getServletName() {
        return this.getString(servletName);
    }

    public void setServletName(String string) {
        this.setString(servletName, string, null);
    }

    public BWebSocketDispatch getDispatch() {
        return (BWebSocketDispatch)this.get(dispatch);
    }

    public void setDispatch(BWebSocketDispatch bWebSocketDispatch) {
        this.set(dispatch, (BValue)bWebSocketDispatch, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void serviceStarted() {
        if (LOG.isTraceOn()) {
            LOG.trace("BWebSocketServlet: service started");
        }
    }

    public void serviceStopped() {
        if (LOG.isTraceOn()) {
            LOG.trace("BWebSocketServlet: service stopped");
        }
        this.factory.shutdown();
    }

    public void doGet(WebOp webOp) throws HandshakeException, ServiceNotFoundException, NoSocketsAvailableException, SocketRejectedException, IOException {
        WebSocket webSocket = this.factory.getWebSocket(webOp);
        if (webSocket == null) {
            throw new HandshakeException("Could not negotiate WebSocket protocol");
        }
        try {
            this.getDispatch().dispatch(webSocket);
            webSocket.handshake();
        }
        catch (HandshakeException handshakeException) {
            WebSocketUtil.closeSocketStreams(webSocket);
            throw handshakeException;
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            WebSocketUtil.closeSocketStreams(webSocket);
            throw serviceNotFoundException;
        }
        catch (SocketRejectedException socketRejectedException) {
            WebSocketUtil.closeSocketStreams(webSocket);
            throw socketRejectedException;
        }
    }

    public void doPost(WebOp webOp) throws HandshakeException, ServiceNotFoundException, NoSocketsAvailableException, SocketRejectedException, IOException {
        this.doGet(webOp);
    }

    public boolean isNavChild() {
        return false;
    }

    public static void register(String string, BIWebSocketAcceptor bIWebSocketAcceptor) throws ServiceNotFoundException {
        BWebSocketServlet bWebSocketServlet = (BWebSocketServlet)Sys.getService((Type)TYPE);
        bWebSocketServlet.getDispatch().register(string, bIWebSocketAcceptor);
    }

    public BPermissions getPermissions(Context context) {
        int n = super.getPermissions(context).getMask();
        return BPermissions.make((int)(n | 1));
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.factory = new NWebSocketFactory();
    }

    public BWebSocketServlet() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$websockets$BWebSocketServlet;
        if (clazz == null) {
            clazz = class$com$tridium$websockets$BWebSocketServlet = BWebSocketServlet.class("[Lcom.tridium.websockets.BWebSocketServlet;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        LOG = Log.getLog((String)"websockets");
    }
}

