/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.websockets;

import com.tridium.websockets.BIWebSocketAcceptor;
import com.tridium.websockets.BWebSocketServlet;
import com.tridium.websockets.ByteUtil;
import com.tridium.websockets.WebSocket;
import com.tridium.websockets.WebSocketCloseReason;
import com.tridium.websockets.WebSocketEventHandler;
import java.io.IOException;
import javax.baja.log.Log;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.Context;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BWebSocketEchoService
extends BAbstractService
implements BIWebSocketAcceptor {
    public static final Type TYPE;
    private static Log LOG;
    static /* synthetic */ Class class$com$tridium$websockets$BWebSocketEchoService;

    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE, BIWebSocketAcceptor.TYPE};
    }

    public void accept(WebSocket webSocket) {
        LOG.trace("BWebSocketEchoService: accepting web socket with key " + webSocket.getKey());
        webSocket.attachHandler(new EchoEventHandler(webSocket));
    }

    public void serviceStarted() {
        try {
            BWebSocketServlet.register("echo", this);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            LOG.error("No WebSocketServlet installed", (Throwable)serviceNotFoundException);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$websockets$BWebSocketEchoService;
        if (clazz == null) {
            clazz = class$com$tridium$websockets$BWebSocketEchoService = BWebSocketEchoService.class("[Lcom.tridium.websockets.BWebSocketEchoService;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        LOG = Log.getLog((String)"websockets");
    }

    private static class EchoEventHandler
    extends WebSocketEventHandler {
        public void onOpen(Context context) {
            LOG.trace("BWebSocketEchoService: web socket opened " + this.getSocket().getKey());
        }

        public void onClose(WebSocketCloseReason webSocketCloseReason, Context context) {
            LOG.trace("BWebSocketEchoService: web socket closed: " + webSocketCloseReason);
        }

        public void onMessage(byte[] byArray, Context context) {
            String string = ByteUtil.toUTF8String(byArray);
            LOG.trace("BWebSocketEchoService: received message: '" + string + '\'');
            try {
                this.getSocket().send(byArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                try {
                    String string2 = "Could not echo back to socket";
                    this.getSocket().close(WebSocketCloseReason.UNEXPECTED_CONDITION, ByteUtil.getUTF8Bytes(string2));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }

        public EchoEventHandler(WebSocket webSocket) {
            super(webSocket);
        }
    }
}

