/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.adr;

import com.tridium.adr.AdrRestUtility;
import com.tridium.adr.BAdrDeviceFolder;
import com.tridium.adr.BAdrNetwork;
import com.tridium.adr.components.BAdrEventInfoInstance;
import com.tridium.adr.components.BAdrEventInfoValue;
import com.tridium.adr.components.BAdrEventOpModeSchedule;
import com.tridium.adr.enums.BAdrEventInfoTypeIdEnum;
import com.tridium.adr.enums.BAdrEventStatusEnum;
import com.tridium.adr.enums.BAdrLoadLevelEnum;
import com.tridium.adr.enums.BAdrOperationModeValueEnum;
import com.tridium.adr.program.BAdrActiveEvent;
import com.tridium.adr.program.BAdrDeviceExt;
import com.tridium.adr.program.BAdrEvent;
import com.tridium.adr.program.BAdrProgram;
import com.tridium.adr.program.BAdrProxyExt;
import com.tridium.basicdriver.BBasicDevice;
import com.tridium.basicdriver.util.BIBasicPollable;
import java.io.IOException;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.security.BPassword;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.xml.XElem;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BAdrDevice
extends BBasicDevice
implements BIBasicPollable {
    public static final Property restUrl = BAdrDevice.newProperty((int)0, (String)"https://hon2.openadr.com/RestClientWS/rest2", null);
    public static final Property userName = BAdrDevice.newProperty((int)0, (String)"", null);
    public static final Property password = BAdrDevice.newProperty((int)0, (BValue)BPassword.make((String)""), null);
    public static final Property pollFrequency = BAdrDevice.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    public static final Property activeEvent = BAdrDevice.newProperty((int)0, (BValue)new BAdrActiveEvent(), null);
    public static final Property programs = BAdrDevice.newProperty((int)0, (BValue)new BAdrDeviceExt(), null);
    public static final Property lastPollTime = BAdrDevice.newProperty((int)1, (String)BAbsTime.now().toString(), null);
    public static final Property eventInfo = BAdrDevice.newProperty((int)1, (String)"", null);
    public static final Property acknowledgementURL = BAdrDevice.newProperty((int)0, (String)"https://hon2.openadr.com/RestClientWS/restConfirm", null);
    public static final Property enableCache = BAdrDevice.newProperty((int)0, (boolean)false, null);
    public static final Type TYPE;
    static BFacets timeFacets;
    private boolean mHasEvents;
    public boolean toContinue;
    AdrRestUtility mRESTClient;
    Log logAdrPoll;
    Log logAdrComm;
    Log logAdrDebug;
    Log logAdrEventsCache;
    private boolean mIsPollInProgress;
    private Object mPollingProgressSync;
    private boolean mManualConfigSet;
    public int mHttpErrorCode;
    public int dummy;
    static /* synthetic */ Class class$com$tridium$adr$BAdrDevice;
    static /* synthetic */ Class class$com$tridium$adr$program$BAdrProgram;
    static /* synthetic */ Class class$com$tridium$adr$program$BAdrEvent;
    static /* synthetic */ Class class$com$tridium$adr$components$BAdrEventInfoInstance;
    static /* synthetic */ Class class$com$tridium$adr$components$BAdrEventInfoValue;

    public String getRestUrl() {
        return this.getString(restUrl);
    }

    public void setRestUrl(String string) {
        this.setString(restUrl, string, null);
    }

    public String getUserName() {
        return this.getString(userName);
    }

    public void setUserName(String string) {
        this.setString(userName, string, null);
    }

    public BPassword getPassword() {
        return (BPassword)this.get(password);
    }

    public void setPassword(BPassword bPassword) {
        this.set(password, (BValue)bPassword, null);
    }

    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    public void setPollFrequency(BPollFrequency bPollFrequency) {
        this.set(pollFrequency, (BValue)bPollFrequency, null);
    }

    public BAdrActiveEvent getActiveEvent() {
        return (BAdrActiveEvent)this.get(activeEvent);
    }

    public void setActiveEvent(BAdrActiveEvent bAdrActiveEvent) {
        this.set(activeEvent, (BValue)bAdrActiveEvent, null);
    }

    public BAdrDeviceExt getPrograms() {
        return (BAdrDeviceExt)this.get(programs);
    }

    public void setPrograms(BAdrDeviceExt bAdrDeviceExt) {
        this.set(programs, (BValue)bAdrDeviceExt, null);
    }

    public String getLastPollTime() {
        return this.getString(lastPollTime);
    }

    public void setLastPollTime(String string) {
        this.setString(lastPollTime, string, null);
    }

    public String getEventInfo() {
        return this.getString(eventInfo);
    }

    public void setEventInfo(String string) {
        this.setString(eventInfo, string, null);
    }

    public String getAcknowledgementURL() {
        return this.getString(acknowledgementURL);
    }

    public void setAcknowledgementURL(String string) {
        this.setString(acknowledgementURL, string, null);
    }

    public boolean getEnableCache() {
        return this.getBoolean(enableCache);
    }

    public void setEnableCache(boolean bl) {
        this.setBoolean(enableCache, bl, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final BAdrNetwork getAdrNetwork() {
        return (BAdrNetwork)this.getNetwork();
    }

    public Type getNetworkType() {
        return BAdrNetwork.TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.mRESTClient = new AdrRestUtility(this, this.getUserName(), this.getPassword().getString(), this.getRestUrl());
        this.getAdrNetwork().getPollScheduler().subscribe((BIPollable)this);
    }

    public void stopped() throws Exception {
        if (this.isRunning()) {
            ((BAdrNetwork)this.getNetwork()).getPollScheduler().unsubscribe((BIPollable)this);
        }
        if (this.mRESTClient != null) {
            this.mRESTClient = null;
        }
        super.stopped();
    }

    public void changed(Property property, Context context) {
        block2: {
            block1: {
                if (!this.isRunning()) {
                    return;
                }
                super.changed(property, context);
                if (property != restUrl) break block1;
                this.logAdrEventsCache.trace(BAdrDevice.unescape(this.getName()) + "::configuration changed, cache cleared");
                this.setAcknowledgementURL(AdrRestUtility.formAckURL(this.getRestUrl()));
                this.clearUnavailableEventInfo("", "", -1);
                this.clearActiveEventInfo(false);
                this.ping();
                break block2;
            }
            if (property != userName && property != password) break block2;
            this.logAdrEventsCache.trace(BAdrDevice.unescape(this.getName()) + "::configuration changed, cache cleared");
            this.clearUnavailableEventInfo("", "", -1);
            this.clearActiveEventInfo(false);
            this.ping();
        }
    }

    public boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BAdrNetwork || bComponent instanceof BAdrDeviceFolder;
    }

    public AdrRestUtility getRestClient() {
        return this.mRESTClient;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void poll() {
        if (!this.isDeviceOk() || !this.isRunning()) {
            this.setIsPollInProgress(false);
            return;
        }
        if (this.getIsPollInProgress()) {
            this.logAdrPoll.trace(BAdrDevice.unescape(this.getName()) + "::previous poll cycle has not yet completed, returning");
            return;
        }
        if (this.mRESTClient == null) {
            this.mRESTClient = new AdrRestUtility(this, this.getUserName(), this.getPassword().getString(), this.getRestUrl());
        } else {
            this.mRESTClient.reInitialize(this.getUserName(), this.getPassword().getString(), this.getRestUrl());
        }
        this.logAdrPoll.trace(BAdrDevice.unescape(this.getName()) + "::Poll starts");
        try {
            try {
                this.setIsPollInProgress(true);
                XElem xElem = this.getRestClient().connectToServer();
                if (xElem != null) {
                    this.clearParsedAlreadyFlags();
                    this.parseEventInfoWithXParser(xElem);
                    this.deleteObsoleteProgramsAndEvents();
                } else if (this.getRestClient() != null) {
                    this.pingFail(this.getRestClient().getErrorString());
                }
            }
            catch (Exception exception) {
                this.logAdrPoll.error(BAdrDevice.unescape(this.getName()) + "::Poll caught into exception ", (Throwable)exception);
                this.pingFail(" POLL caught in exception::" + exception.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.setIsPollInProgress(false);
            this.setLastPollTime(BAbsTime.now().toString((Context)timeFacets));
            throw throwable;
        }
        {
            Object var2_5 = null;
            this.setIsPollInProgress(false);
            this.setLastPollTime(BAbsTime.now().toString((Context)timeFacets));
        }
        this.logAdrPoll.trace(BAdrDevice.unescape(this.getName()) + "::Poll ends");
    }

    public void deleteObsoleteProgramsAndEvents() {
        BAdrProgram[] bAdrProgramArray;
        BAdrDeviceExt bAdrDeviceExt = this.getPrograms();
        Class clazz = class$com$tridium$adr$program$BAdrProgram;
        if (clazz == null) {
            clazz = class$com$tridium$adr$program$BAdrProgram = BAdrDevice.class("[Lcom.tridium.adr.program.BAdrProgram;", false);
        }
        if ((bAdrProgramArray = (BAdrProgram[])bAdrDeviceExt.getChildren(clazz)) != null && bAdrProgramArray.length > 0) {
            int n = 0;
            while (n < bAdrProgramArray.length) {
                if (bAdrProgramArray[n].getMarkedForDeletion()) {
                    this.getPrograms().remove((BComplex)bAdrProgramArray[n]);
                } else {
                    BAdrEvent[] bAdrEventArray;
                    BAdrProgram bAdrProgram = bAdrProgramArray[n];
                    Class clazz2 = class$com$tridium$adr$program$BAdrEvent;
                    if (clazz2 == null) {
                        clazz2 = BAdrDevice.class("[Lcom.tridium.adr.program.BAdrEvent;", false);
                    }
                    if ((bAdrEventArray = (BAdrEvent[])bAdrProgram.getChildren(clazz2)) != null && bAdrEventArray.length > 0) {
                        int n2 = 0;
                        while (n2 < bAdrEventArray.length) {
                            if (bAdrEventArray[n2].markedForDeletion) {
                                bAdrProgramArray[n].remove((BComplex)bAdrEventArray[n2]);
                            }
                            ++n2;
                        }
                    }
                }
                ++n;
            }
        }
    }

    public void parseEventInfoWithXParser(XElem xElem) {
        try {
            XElem[] xElemArray = xElem.elems("eventStates");
            if (xElemArray != null) {
                int n = 0;
                while (n < xElemArray.length) {
                    Object object;
                    String string;
                    Object object2;
                    XElem xElem2 = xElemArray[n];
                    BAdrEvent bAdrEvent = null;
                    String string2 = xElem2.get("eventIdentifier");
                    String string3 = xElem2.get("programName");
                    if (string3.equals("")) {
                        object2 = xElem2.elem("simpleDRModeData");
                        string = this.getManuallyConfiguredValue((XElem)object2);
                        if (string.equalsIgnoreCase("")) {
                            this.mManualConfigSet = false;
                            this.clearActiveEventInfo(false);
                            this.clearUnavailableEventInfo("", "", -1);
                            this.setEventInfo("");
                            this.mHasEvents = false;
                        } else {
                            this.mManualConfigSet = true;
                            this.clearActiveEventInfo(false);
                            this.clearUnavailableEventInfo("", "", -1);
                            this.setEventInfo("");
                            this.logAdrPoll.trace(BAdrDevice.escape(this.getName()) + "::manual configuration is done, no events in Auto-DR mode");
                            object = null;
                            object = (BAdrProxyExt)this.getActiveEvent().getOpModeValue().getProxyExt();
                            object.readOk((BStatusValue)new BStatusEnum((BEnum)BAdrOperationModeValueEnum.make(string)));
                        }
                    } else {
                        this.mManualConfigSet = false;
                        this.mHasEvents = true;
                        object2 = this.getProgramAndMarkForDeletionIfNotPresent(string3);
                        if (object2 == null) {
                            object2 = new BAdrProgram();
                            object2.setProgramName(string3);
                            object2.setParsedAlready(true);
                            bAdrEvent = new BAdrEvent(string3, string2, true);
                            object2.add(BAdrDevice.escape(bAdrEvent.getEventIdentifier()), (BValue)bAdrEvent);
                            this.getPrograms().add(BAdrDevice.escape(string3), (BValue)object2);
                        } else {
                            bAdrEvent = this.getEventAlreadyModeled((BAdrProgram)((Object)object2), string2);
                            if (bAdrEvent == null) {
                                bAdrEvent = new BAdrEvent(string3, string2, true);
                                object2.add(BAdrDevice.escape(bAdrEvent.getEventIdentifier()), (BValue)bAdrEvent);
                            }
                        }
                        bAdrEvent.setEventInfo("");
                        this.parseDREventInfo(xElem2, bAdrEvent);
                        string = xElem2.elem("simpleDRModeData");
                        if (string != null) {
                            this.parseSimpleEventData((XElem)string, bAdrEvent);
                        } else {
                            this.logAdrPoll.trace(BAdrDevice.unescape(this.getName()) + "::Simple DR mode data is missing in the event state info");
                            this.clearUnavailableEventInfo(bAdrEvent.getProgramName(), bAdrEvent.getEventIdentifier(), 1);
                        }
                        object = this.getRestClient().sendResponse(this.getAcknowledgementURL(), this.createResponse(false, bAdrEvent.getDrasClientID(), bAdrEvent.getEventIdentifier(), "" + bAdrEvent.getEventModNumber(), "" + bAdrEvent.getEventStateId(), "" + bAdrEvent.getCurrentTime(), bAdrEvent.getOpModeValue().toString()));
                        if (((String)object).equals("SUCCESS")) {
                            this.logAdrPoll.trace(BAdrDevice.unescape(this.getName()) + "::Event " + bAdrEvent.getEventIdentifier() + "- confirmation sent to DRAS server");
                            bAdrEvent.setEventConfirmation((String)object);
                        } else {
                            this.logAdrPoll.message(BAdrDevice.unescape(this.getName()) + "::Event " + bAdrEvent.getEventIdentifier() + "- confirmation not sent to DRAS server");
                            bAdrEvent.setEventConfirmation((String)object);
                        }
                        XElem xElem3 = xElem2.elem("drEventData");
                        if (xElem3 != null) {
                            this.parseSmartEventData(xElem3, bAdrEvent);
                        } else {
                            this.logAdrPoll.trace(BAdrDevice.unescape(this.getName()) + "::There is no smart event data, cannot handle Opmode schedule for this event " + string2);
                            this.clearUnavailableEventInfo(bAdrEvent.getProgramName(), bAdrEvent.getEventIdentifier(), 2);
                        }
                        if (n == 0) {
                            bAdrEvent.setHighestPriorityEvent(true);
                            if (bAdrEvent.getEventStatus().getOrdinal() == 4) {
                                this.fillActiveEventInfo(bAdrEvent, false);
                            } else {
                                this.clearActiveEventInfo(false);
                            }
                        } else {
                            bAdrEvent.setHighestPriorityEvent(false);
                        }
                    }
                    ++n;
                }
            } else {
                this.logAdrPoll.error(BAdrDevice.unescape(this.getName()) + "::Event list node is not found, verify the server url");
                this.clearActiveEventInfo(false);
                this.clearUnavailableEventInfo("", "", -1);
            }
        }
        catch (Exception exception) {
            this.clearActiveEventInfo(true);
            this.logAdrPoll.error(BAdrDevice.unescape(this.getName()) + "::Parsing DR event caught into exception ", (Throwable)exception);
        }
    }

    private final void parseDREventInfo(XElem xElem, BAdrEvent bAdrEvent) {
        try {
            String string = xElem.get("eventModNumber");
            int n = Integer.parseInt(string.trim());
            bAdrEvent.setEventModNumber(n);
            String string2 = xElem.get("drasClientID");
            bAdrEvent.setDrasClientID(string2);
            String string3 = xElem.get("eventStateID");
            int n2 = Integer.parseInt(string3.trim());
            bAdrEvent.setEventStateId(n2);
            String string4 = xElem.get("schemaVersion");
            bAdrEvent.setSchemaVersion(string4);
            String string5 = xElem.get("drasName");
            bAdrEvent.setDrasName(string5);
            boolean bl = Boolean.getBoolean(xElem.get("testEvent"));
            bAdrEvent.setTestEvent(bl);
            boolean bl2 = Boolean.getBoolean(xElem.get("offLine"));
            bAdrEvent.setOffline(bl2);
        }
        catch (Exception exception) {
            this.logAdrPoll.error(BAdrDevice.unescape(this.getName()) + "::Parsing DR event info caught in exception", (Throwable)exception);
        }
    }

    public void clearActiveEventInfo(boolean bl) {
        this.getActiveEvent().setEventId("");
        this.getActiveEvent().setProgramName("");
        this.getActiveEvent().setEventStartTime(BAbsTime.NULL);
        this.getActiveEvent().setEventEndTime(BAbsTime.NULL);
        this.setEventInfo("");
        BStatus bStatus = null;
        BAdrProxyExt bAdrProxyExt = (BAdrProxyExt)this.getActiveEvent().getOpModeValue().getProxyExt();
        if (!bl) {
            bStatus = BStatus.makeNull((BStatus)bAdrProxyExt.getStatus(), (boolean)true);
            bAdrProxyExt.readOk((BStatusValue)new BStatusEnum(this.getActiveEvent().getOpModeValue().getEnum(), bStatus));
        } else {
            bAdrProxyExt.readFail("Parsing exception");
        }
        bAdrProxyExt = (BAdrProxyExt)this.getActiveEvent().getPriceAbsolute().getProxyExt();
        if (!bl) {
            bStatus = BStatus.makeNull((BStatus)bAdrProxyExt.getStatus(), (boolean)true);
            bAdrProxyExt.readOk((BStatusValue)new BStatusNumeric(0.0, bStatus));
        } else {
            bAdrProxyExt.readFail("Parsing exception");
        }
        bAdrProxyExt = (BAdrProxyExt)this.getActiveEvent().getPriceRelative().getProxyExt();
        if (!bl) {
            bStatus = BStatus.makeNull((BStatus)bAdrProxyExt.getStatus(), (boolean)true);
            bAdrProxyExt.readOk((BStatusValue)new BStatusNumeric(0.0, bStatus));
        } else {
            bAdrProxyExt.readFail("Parsing exception");
        }
        bAdrProxyExt = (BAdrProxyExt)this.getActiveEvent().getPriceMultiple().getProxyExt();
        if (!bl) {
            bStatus = BStatus.makeNull((BStatus)bAdrProxyExt.getStatus(), (boolean)true);
            bAdrProxyExt.readOk((BStatusValue)new BStatusNumeric(0.0, bStatus));
        } else {
            bAdrProxyExt.readFail("Parsing exception");
        }
        bAdrProxyExt = (BAdrProxyExt)this.getActiveEvent().getLoadLevel().getProxyExt();
        if (!bl) {
            bStatus = BStatus.makeNull((BStatus)bAdrProxyExt.getStatus(), (boolean)true);
            bAdrProxyExt.readOk((BStatusValue)new BStatusEnum(this.getActiveEvent().getLoadLevel().getEnum(), bStatus));
        } else {
            bAdrProxyExt.readFail("Parsing exception");
        }
        bAdrProxyExt = (BAdrProxyExt)this.getActiveEvent().getLoadAmount().getProxyExt();
        if (!bl) {
            bStatus = BStatus.makeNull((BStatus)bAdrProxyExt.getStatus(), (boolean)true);
            bAdrProxyExt.readOk((BStatusValue)new BStatusNumeric(0.0, bStatus));
        } else {
            bAdrProxyExt.readFail("Parsing exception");
        }
        bAdrProxyExt = (BAdrProxyExt)this.getActiveEvent().getLoadPercentage().getProxyExt();
        if (!bl) {
            bStatus = BStatus.makeNull((BStatus)bAdrProxyExt.getStatus(), (boolean)true);
            bAdrProxyExt.readOk((BStatusValue)new BStatusNumeric(0.0, bStatus));
        } else {
            bAdrProxyExt.readFail("Parsing exception");
        }
        bAdrProxyExt = (BAdrProxyExt)this.getActiveEvent().getGridReliability().getProxyExt();
        if (!bl) {
            bStatus = BStatus.makeNull((BStatus)bAdrProxyExt.getStatus(), (boolean)true);
            bAdrProxyExt.readOk((BStatusValue)new BStatusNumeric(0.0, bStatus));
        } else {
            bAdrProxyExt.readFail("Parsing exception");
        }
    }

    public void fillActiveEventInfo(BAdrEvent bAdrEvent, boolean bl) {
        Object object;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        BAbsTime bAbsTime = BAbsTime.now();
        boolean bl9 = false;
        if (bAbsTime.compareTo((Object)bAdrEvent.getStartTime()) >= 0) {
            bl9 = true;
        }
        boolean bl10 = bl9;
        boolean bl11 = false;
        if (bAbsTime.compareTo((Object)bAdrEvent.getEndTime()) < 0) {
            bl11 = true;
        }
        boolean bl12 = bl11;
        boolean bl13 = false;
        if (bl10 && bl12) {
            bl13 = true;
        }
        boolean bl14 = bl13;
        double d = bAdrEvent.getCurrentTime();
        BAdrEventStatusEnum bAdrEventStatusEnum = bAdrEvent.getEventStatus();
        if (d < 0.0 && bAdrEventStatusEnum == BAdrEventStatusEnum.active) {
            this.mManualConfigSet = true;
        }
        if (bl14) {
            this.getActiveEvent().setEventId(bAdrEvent.getEventIdentifier());
            this.getActiveEvent().setProgramName(bAdrEvent.getProgramName());
            this.getActiveEvent().setEventStartTime(bAdrEvent.getStartTime());
            this.getActiveEvent().setEventEndTime(bAdrEvent.getEndTime());
            this.setEventInfo(bAdrEvent.getEventInfo());
        } else {
            this.getActiveEvent().setEventId("");
            this.getActiveEvent().setProgramName("");
            this.getActiveEvent().setEventStartTime(BAbsTime.NULL);
            this.getActiveEvent().setEventEndTime(BAbsTime.NULL);
            this.setEventInfo("");
        }
        if (bl14) {
            if (!bl) {
                this.logAdrPoll.trace("Updating active event from polled data");
                if (bAdrEvent.priceAbsolute != null) {
                    ((BAdrProxyExt)this.getActiveEvent().getPriceAbsolute().getProxyExt()).readOk((BStatusValue)new BStatusNumeric(bAdrEvent.priceAbsolute.doubleValue(), BStatus.ok));
                    bl2 = true;
                }
                if (bAdrEvent.priceRelative != null) {
                    ((BAdrProxyExt)this.getActiveEvent().getPriceRelative().getProxyExt()).readOk((BStatusValue)new BStatusNumeric(bAdrEvent.priceRelative.doubleValue(), BStatus.ok));
                    bl3 = true;
                }
                if (bAdrEvent.priceMultiple != null) {
                    ((BAdrProxyExt)this.getActiveEvent().getPriceMultiple().getProxyExt()).readOk((BStatusValue)new BStatusNumeric(bAdrEvent.priceMultiple.doubleValue(), BStatus.ok));
                    bl4 = true;
                }
                if (bAdrEvent.loadAmount != null) {
                    ((BAdrProxyExt)this.getActiveEvent().getLoadAmount().getProxyExt()).readOk((BStatusValue)new BStatusNumeric(bAdrEvent.loadAmount.doubleValue(), BStatus.ok));
                    bl6 = true;
                }
                if (bAdrEvent.loadLevel != null) {
                    ((BAdrProxyExt)this.getActiveEvent().getLoadLevel().getProxyExt()).readOk((BStatusValue)new BStatusEnum((BEnum)bAdrEvent.loadLevel, BStatus.ok));
                    bl5 = true;
                }
                if (bAdrEvent.loadPercentage != null) {
                    ((BAdrProxyExt)this.getActiveEvent().getLoadPercentage().getProxyExt()).readOk((BStatusValue)new BStatusNumeric(bAdrEvent.loadPercentage.doubleValue(), BStatus.ok));
                    bl7 = true;
                }
                if (bAdrEvent.gridReliability != null) {
                    ((BAdrProxyExt)this.getActiveEvent().getGridReliability().getProxyExt()).readOk((BStatusValue)new BStatusNumeric(bAdrEvent.gridReliability.doubleValue(), BStatus.ok));
                    bl8 = true;
                }
            } else {
                this.logAdrEventsCache.trace("Updating active event from cached data");
                BFolder bFolder = bAdrEvent.getEventInfoInstances();
                Class clazz = class$com$tridium$adr$components$BAdrEventInfoInstance;
                if (clazz == null) {
                    clazz = class$com$tridium$adr$components$BAdrEventInfoInstance = BAdrDevice.class("[Lcom.tridium.adr.components.BAdrEventInfoInstance;", false);
                }
                if ((object = (BAdrEventInfoInstance[])bFolder.getChildren(clazz)) != null) {
                    int n = 0;
                    while (n < ((BAdrEventInfoInstance[])object).length) {
                        BAdrEventInfoInstance bAdrEventInfoInstance = object[n];
                        Class clazz2 = class$com$tridium$adr$components$BAdrEventInfoValue;
                        if (clazz2 == null) {
                            clazz2 = BAdrDevice.class("[Lcom.tridium.adr.components.BAdrEventInfoValue;", false);
                        }
                        BAdrEventInfoValue[] bAdrEventInfoValueArray = (BAdrEventInfoValue[])bAdrEventInfoInstance.getChildren(clazz2);
                        int n2 = -1;
                        int n3 = 0;
                        while (n3 < bAdrEventInfoValueArray.length) {
                            BAbsTime bAbsTime2 = BAbsTime.now();
                            long l = bAbsTime2.getMillis();
                            long l2 = bAdrEvent.getStartTime().getMillis() + bAdrEventInfoValueArray[n3].getTimeOffset() * 1000L;
                            if (n3 != bAdrEventInfoValueArray.length - 1) {
                                long l3 = bAdrEvent.getStartTime().getMillis() + bAdrEventInfoValueArray[n3 + 1].getTimeOffset() * 1000L;
                                if (l >= l2 && l < l3) {
                                    n2 = n3;
                                    break;
                                }
                            } else if (l >= l2 && l <= bAdrEvent.getEndTime().getMillis()) {
                                n2 = n3;
                                break;
                            }
                            ++n3;
                        }
                        if (n2 >= 0) {
                            if (object[n].getEventInfoTypeID().equalsIgnoreCase(BAdrEventInfoTypeIdEnum.price_Absolute.getTag())) {
                                ((BAdrProxyExt)this.getActiveEvent().getPriceAbsolute().getProxyExt()).readOk((BStatusValue)new BStatusNumeric(Double.parseDouble(bAdrEventInfoValueArray[n2].getValue()), BStatus.ok));
                                bl2 = true;
                            }
                            if (object[n].getEventInfoTypeID().equalsIgnoreCase(BAdrEventInfoTypeIdEnum.price_relative.getTag())) {
                                ((BAdrProxyExt)this.getActiveEvent().getPriceRelative().getProxyExt()).readOk((BStatusValue)new BStatusNumeric(Double.parseDouble(bAdrEventInfoValueArray[n2].getValue()), BStatus.ok));
                                bl3 = true;
                            }
                            if (object[n].getEventInfoTypeID().equalsIgnoreCase(BAdrEventInfoTypeIdEnum.price_multiple.getTag())) {
                                ((BAdrProxyExt)this.getActiveEvent().getPriceMultiple().getProxyExt()).readOk((BStatusValue)new BStatusNumeric(Double.parseDouble(bAdrEventInfoValueArray[n2].getValue()), BStatus.ok));
                                bl4 = true;
                            }
                            if (object[n].getEventInfoTypeID().equalsIgnoreCase(BAdrEventInfoTypeIdEnum.load_amount.getTag())) {
                                ((BAdrProxyExt)this.getActiveEvent().getLoadAmount().getProxyExt()).readOk((BStatusValue)new BStatusNumeric(Double.parseDouble(bAdrEventInfoValueArray[n2].getValue()), BStatus.ok));
                                bl6 = true;
                            }
                            if (object[n].getEventInfoTypeID().equalsIgnoreCase(BAdrEventInfoTypeIdEnum.load_level.getTag())) {
                                ((BAdrProxyExt)this.getActiveEvent().getLoadLevel().getProxyExt()).readOk((BStatusValue)new BStatusEnum((BEnum)BAdrLoadLevelEnum.make(bAdrEventInfoValueArray[n2].getValue()), BStatus.ok));
                                bl5 = true;
                            }
                            if (object[n].getEventInfoTypeID().equalsIgnoreCase(BAdrEventInfoTypeIdEnum.load_percentage.getTag())) {
                                ((BAdrProxyExt)this.getActiveEvent().getLoadPercentage().getProxyExt()).readOk((BStatusValue)new BStatusNumeric(Double.parseDouble(bAdrEventInfoValueArray[n2].getValue()), BStatus.ok));
                                bl7 = true;
                            }
                            if (object[n].getEventInfoTypeID().equalsIgnoreCase(BAdrEventInfoTypeIdEnum.grid_reliability.getTag())) {
                                ((BAdrProxyExt)this.getActiveEvent().getGridReliability().getProxyExt()).readOk((BStatusValue)new BStatusNumeric(Double.parseDouble(bAdrEventInfoValueArray[n2].getValue()), BStatus.ok));
                                bl8 = true;
                            }
                        }
                        ++n;
                    }
                }
            }
        } else {
            this.logAdrEventsCache.trace("Need not fill active event- event got expired");
            this.logAdrPoll.trace("Need not fill active event- event got expired");
            this.clearActiveEventInfo(false);
        }
        if (bl14 || this.mManualConfigSet) {
            object = null;
            object = (BAdrProxyExt)this.getActiveEvent().getOpModeValue().getProxyExt();
            object.readOk((BStatusValue)new BStatusEnum((BEnum)bAdrEvent.getOpModeValue()));
            if (!bl2) {
                object = (BAdrProxyExt)this.getActiveEvent().getPriceAbsolute().getProxyExt();
                BStatus bStatus = BStatus.makeNull((BStatus)object.getStatus(), (boolean)true);
                object.readOk((BStatusValue)new BStatusNumeric(0.0, bStatus));
            }
            if (!bl3) {
                object = (BAdrProxyExt)this.getActiveEvent().getPriceRelative().getProxyExt();
                BStatus bStatus = BStatus.makeNull((BStatus)object.getStatus(), (boolean)true);
                object.readOk((BStatusValue)new BStatusNumeric(0.0, bStatus));
            }
            if (!bl4) {
                object = (BAdrProxyExt)this.getActiveEvent().getPriceMultiple().getProxyExt();
                BStatus bStatus = BStatus.makeNull((BStatus)object.getStatus(), (boolean)true);
                object.readOk((BStatusValue)new BStatusNumeric(0.0, bStatus));
            }
            if (!bl5) {
                object = (BAdrProxyExt)this.getActiveEvent().getLoadLevel().getProxyExt();
                BStatus bStatus = BStatus.makeNull((BStatus)object.getStatus(), (boolean)true);
                object.readOk((BStatusValue)new BStatusEnum(this.getActiveEvent().getLoadLevel().getEnum(), bStatus));
            }
            if (!bl6) {
                object = (BAdrProxyExt)this.getActiveEvent().getLoadAmount().getProxyExt();
                BStatus bStatus = BStatus.makeNull((BStatus)object.getStatus(), (boolean)true);
                object.readOk((BStatusValue)new BStatusNumeric(0.0, bStatus));
            }
            if (!bl7) {
                object = (BAdrProxyExt)this.getActiveEvent().getLoadPercentage().getProxyExt();
                BStatus bStatus = BStatus.makeNull((BStatus)object.getStatus(), (boolean)true);
                object.readOk((BStatusValue)new BStatusNumeric(0.0, bStatus));
            }
            if (!bl8) {
                object = (BAdrProxyExt)this.getActiveEvent().getGridReliability().getProxyExt();
                BStatus bStatus = BStatus.makeNull((BStatus)object.getStatus(), (boolean)true);
                object.readOk((BStatusValue)new BStatusNumeric(0.0, bStatus));
            }
        } else {
            this.logAdrPoll.trace("Event is not in active period");
            this.logAdrEventsCache.trace("Event is not in active period");
        }
    }

    public void clearUnavailableEventInfo(String string, String string2, int n) {
        if (string.equals("")) {
            this.getPrograms().removeAll();
            return;
        }
        this.logAdrDebug.trace(BAdrDevice.unescape(this.getName()) + "::clear obsolete event info");
        BAdrProgram bAdrProgram = this.getProgram(string);
        if (bAdrProgram != null) {
            this.logAdrDebug.trace(BAdrDevice.unescape(this.getName()) + "::found program- " + string);
            BAdrEvent bAdrEvent = this.getEventAlreadyModeled(bAdrProgram, string2);
            this.logAdrDebug.trace("Searched event " + string2);
            if (bAdrEvent != null) {
                this.logAdrDebug.trace(BAdrDevice.unescape(this.getName()) + "::found searched event-" + string2);
                if (n == 0) {
                    bAdrEvent.setDrasName("");
                    bAdrEvent.setDrasClientID("");
                    bAdrEvent.setProgramName("");
                    bAdrEvent.setSchemaVersion("");
                    bAdrEvent.setEventModNumber(0);
                    bAdrEvent.setEventStateId(0L);
                    bAdrEvent.setTestEvent(false);
                    bAdrEvent.setOffline(false);
                }
                if (n == 1) {
                    bAdrEvent.setCurrentTime(0.0);
                    bAdrEvent.setEventStatus(BAdrEventStatusEnum.none);
                    bAdrEvent.setOpModeValue(BAdrOperationModeValueEnum.normal);
                    bAdrEvent.getOpModeSchedules().removeAll();
                }
                if (n == 2) {
                    bAdrEvent.setStartTime(BAbsTime.NULL);
                    bAdrEvent.setEndTime(BAbsTime.NULL);
                    bAdrEvent.setNotificationTime(BAbsTime.NULL);
                    bAdrEvent.getEventInfoInstances().removeAll();
                }
            } else {
                this.logAdrDebug.trace(BAdrDevice.unescape(this.getName()) + "::Event " + string2 + " under program " + string + " is not found");
            }
        } else {
            this.logAdrDebug.trace(BAdrDevice.unescape(this.getName()) + "::Program " + string + " is not found");
        }
    }

    private final void clearParsedAlreadyFlags() {
        BAdrProgram[] bAdrProgramArray;
        BAdrDeviceExt bAdrDeviceExt = this.getPrograms();
        Class clazz = class$com$tridium$adr$program$BAdrProgram;
        if (clazz == null) {
            clazz = class$com$tridium$adr$program$BAdrProgram = BAdrDevice.class("[Lcom.tridium.adr.program.BAdrProgram;", false);
        }
        if ((bAdrProgramArray = (BAdrProgram[])bAdrDeviceExt.getChildren(clazz)) != null && bAdrProgramArray.length > 0) {
            int n = 0;
            while (n < bAdrProgramArray.length) {
                BAdrEvent[] bAdrEventArray;
                bAdrProgramArray[n].setParsedAlready(false);
                bAdrProgramArray[n].setMarkedForDeletion(false);
                BAdrProgram bAdrProgram = bAdrProgramArray[n];
                Class clazz2 = class$com$tridium$adr$program$BAdrEvent;
                if (clazz2 == null) {
                    clazz2 = BAdrDevice.class("[Lcom.tridium.adr.program.BAdrEvent;", false);
                }
                if ((bAdrEventArray = (BAdrEvent[])bAdrProgram.getChildren(clazz2)) != null && bAdrEventArray.length > 0) {
                    int n2 = 0;
                    while (n2 < bAdrEventArray.length) {
                        bAdrEventArray[n2].parsedAlready = false;
                        bAdrEventArray[n2].markedForDeletion = false;
                        ++n2;
                    }
                }
                ++n;
            }
        }
    }

    private final void parseSmartEventData(XElem xElem, BAdrEvent bAdrEvent) {
        XElem xElem2 = xElem.elem("notificationTime");
        XElem xElem3 = xElem.elem("startTime");
        XElem xElem4 = xElem.elem("endTime");
        if (xElem2 != null) {
            try {
                bAdrEvent.setNotificationTime(BAbsTime.make((String)xElem2.string()));
            }
            catch (IOException iOException) {
                this.logAdrPoll.error(BAdrDevice.unescape(this.getName()), (Throwable)iOException);
            }
        }
        if (xElem3 != null) {
            try {
                bAdrEvent.setStartTime(BAbsTime.make((String)xElem3.string()));
            }
            catch (IOException iOException) {
                this.logAdrPoll.error(BAdrDevice.unescape(this.getName()), (Throwable)iOException);
            }
        }
        if (xElem4 != null) {
            try {
                bAdrEvent.setEndTime(BAbsTime.make((String)xElem4.string()));
            }
            catch (IOException iOException) {
                this.logAdrPoll.error(BAdrDevice.unescape(this.getName()), (Throwable)iOException);
            }
        }
        this.parseEventInfoInstances(xElem, bAdrEvent);
    }

    private final void parseEventInfoInstances(XElem xElem, BAdrEvent bAdrEvent) {
        try {
            bAdrEvent.getEventInfoInstances().removeAll();
            XElem[] xElemArray = xElem.elems("eventInfoInstances");
            if (xElemArray != null) {
                int n = 0;
                while (n < xElemArray.length) {
                    XElem xElem2 = xElemArray[n].elem("eventInfoTypeID");
                    XElem xElem3 = xElemArray[n].elem("eventInfoName");
                    if (xElem2 != null && xElem3 != null) {
                        XElem[] xElemArray2;
                        BAdrEventInfoInstance bAdrEventInfoInstance = null;
                        if (this.getEnableCache()) {
                            bAdrEventInfoInstance = new BAdrEventInfoInstance();
                            bAdrEventInfoInstance.setEventInfoTypeID(xElem2.string());
                            bAdrEventInfoInstance.setEventInfoName(xElem3.string());
                        }
                        if ((xElemArray2 = xElemArray[n].elems("eventInfoValues")) != null && xElemArray2.length > 0) {
                            int n2 = 0;
                            while (n2 < xElemArray2.length) {
                                XElem xElem4 = null;
                                XElem xElem5 = null;
                                XElem xElem6 = null;
                                String string = "";
                                String string2 = "";
                                double d = 0.0;
                                double d2 = 0.0;
                                if (n2 != xElemArray2.length - 1) {
                                    xElem4 = xElemArray2[n2].elem("value");
                                    xElem5 = xElemArray2[n2].elem("timeOffset");
                                    xElem6 = xElemArray2[n2 + 1].elem("timeOffset");
                                    string = xElem5.string();
                                    string2 = xElem6.string();
                                    d = Double.parseDouble(string);
                                    d2 = Double.parseDouble(string2);
                                } else {
                                    xElem4 = xElemArray2[n2].elem("value");
                                    xElem5 = xElemArray2[n2].elem("timeOffset");
                                    string = xElem5.string();
                                    d = Double.parseDouble(string);
                                }
                                if (xElem4 != null && xElem5 != null) {
                                    if (this.getEnableCache()) {
                                        BAdrEventInfoValue bAdrEventInfoValue = new BAdrEventInfoValue();
                                        bAdrEventInfoValue.setValue(xElem4.string());
                                        bAdrEventInfoValue.setTimeOffset(BInteger.make((String)xElem5.string()).getLong());
                                        bAdrEventInfoInstance.add("EventInfoValue" + n2, (BValue)bAdrEventInfoValue);
                                    }
                                    if (n2 != xElemArray2.length - 1) {
                                        if (bAdrEvent.getCurrentTime() >= d && bAdrEvent.getCurrentTime() < d2) {
                                            if (xElem2.string().equalsIgnoreCase("PRICE_ABSOLUTE")) {
                                                bAdrEvent.priceAbsolute = new Double(xElem4.string());
                                            }
                                            if (xElem2.string().equalsIgnoreCase("PRICE_RELATIVE")) {
                                                bAdrEvent.priceRelative = new Double(xElem4.string());
                                            }
                                            if (xElem2.string().equalsIgnoreCase("PRICE_MULTIPLE")) {
                                                bAdrEvent.priceMultiple = new Double(xElem4.string());
                                            }
                                            if (xElem2.string().equalsIgnoreCase("LOAD_AMOUNT")) {
                                                bAdrEvent.loadAmount = new Double(xElem4.string());
                                            }
                                            if (xElem2.string().equalsIgnoreCase("LOAD_LEVEL")) {
                                                bAdrEvent.loadLevel = BAdrLoadLevelEnum.make(xElem4.string());
                                            }
                                            if (xElem2.string().equalsIgnoreCase("LOAD_PERCENTAGE")) {
                                                bAdrEvent.loadPercentage = new Double(xElem4.string());
                                            }
                                            if (xElem2.string().equalsIgnoreCase("GRID_RELIABILITY")) {
                                                bAdrEvent.gridReliability = new Double(xElem4.string());
                                            }
                                        }
                                    } else if (bAdrEvent.getCurrentTime() >= d) {
                                        if (xElem2.string().equalsIgnoreCase("PRICE_ABSOLUTE")) {
                                            bAdrEvent.priceAbsolute = new Double(xElem4.string());
                                        }
                                        if (xElem2.string().equalsIgnoreCase("PRICE_RELATIVE")) {
                                            bAdrEvent.priceRelative = new Double(xElem4.string());
                                        }
                                        if (xElem2.string().equalsIgnoreCase("PRICE_MULTIPLE")) {
                                            bAdrEvent.priceMultiple = new Double(xElem4.string());
                                        }
                                        if (xElem2.string().equalsIgnoreCase("LOAD_AMOUNT")) {
                                            bAdrEvent.loadAmount = new Double(xElem4.string());
                                        }
                                        if (xElem2.string().equalsIgnoreCase("LOAD_LEVEL")) {
                                            bAdrEvent.loadLevel = BAdrLoadLevelEnum.make(xElem4.string());
                                        }
                                        if (xElem2.string().equalsIgnoreCase("LOAD_PERCENTAGE")) {
                                            bAdrEvent.loadPercentage = new Double(xElem4.string());
                                        }
                                        if (xElem2.string().equalsIgnoreCase("GRID_RELIABILITY")) {
                                            bAdrEvent.gridReliability = new Double(xElem4.string());
                                        }
                                    }
                                }
                                ++n2;
                            }
                        }
                        if (bAdrEvent.getEventInfo().equalsIgnoreCase("")) {
                            bAdrEvent.setEventInfo(xElem2.string());
                        } else {
                            String string = bAdrEvent.getEventInfo();
                            bAdrEvent.setEventInfo(string + ',' + xElem2.string());
                        }
                        if (this.getEnableCache()) {
                            bAdrEvent.getEventInfoInstances().add("EventInfoInstance" + n, (BValue)bAdrEventInfoInstance);
                        }
                    }
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            this.logAdrPoll.trace(BAdrDevice.unescape(this.getName()) + "::EventInfoInstances parsing caught in exception ", (Throwable)exception);
        }
    }

    private final String getManuallyConfiguredValue(XElem xElem) {
        XElem xElem2;
        String string = "";
        XElem xElem3 = xElem.elem("EventStatus");
        if (xElem3 != null && xElem3.string().toLowerCase().equals("active") && (xElem2 = xElem.elem("OperationModeValue")) != null) {
            string = xElem2.string().toLowerCase();
        }
        return string;
    }

    private final void parseSimpleEventData(XElem xElem, BAdrEvent bAdrEvent) {
        this.mHasEvents = true;
        XElem xElem2 = xElem.elem("EventStatus");
        if (xElem2 != null) {
            bAdrEvent.setEventStatus(BAdrEventStatusEnum.make(xElem2.string().toLowerCase()));
            this.parseOpModeSchedule(xElem, bAdrEvent);
        }
    }

    private final BAdrProgram getProgram(String string) {
        BAdrProgram[] bAdrProgramArray;
        BAdrProgram bAdrProgram = null;
        BAdrDeviceExt bAdrDeviceExt = this.getPrograms();
        Class clazz = class$com$tridium$adr$program$BAdrProgram;
        if (clazz == null) {
            clazz = class$com$tridium$adr$program$BAdrProgram = BAdrDevice.class("[Lcom.tridium.adr.program.BAdrProgram;", false);
        }
        if ((bAdrProgramArray = (BAdrProgram[])bAdrDeviceExt.getChildren(clazz)) != null && bAdrProgramArray.length > 0) {
            int n = 0;
            while (n < bAdrProgramArray.length) {
                if (bAdrProgramArray[n].getProgramName().equalsIgnoreCase(string)) {
                    bAdrProgram = bAdrProgramArray[n];
                    break;
                }
                ++n;
            }
        }
        return bAdrProgram;
    }

    public boolean hasEvents() {
        return this.mHasEvents;
    }

    public void setHasEvents(boolean bl) {
        this.mHasEvents = bl;
    }

    public BAdrProgram getProgramAndMarkForDeletionIfNotPresent(String string) {
        BAdrProgram[] bAdrProgramArray;
        BAdrProgram bAdrProgram = null;
        BAdrDeviceExt bAdrDeviceExt = this.getPrograms();
        Class clazz = class$com$tridium$adr$program$BAdrProgram;
        if (clazz == null) {
            clazz = class$com$tridium$adr$program$BAdrProgram = BAdrDevice.class("[Lcom.tridium.adr.program.BAdrProgram;", false);
        }
        if ((bAdrProgramArray = (BAdrProgram[])bAdrDeviceExt.getChildren(clazz)) != null && bAdrProgramArray.length > 0) {
            this.logAdrDebug.trace(BAdrDevice.unescape(this.getName()) + "::program mark for deletion,programs.length ::" + bAdrProgramArray.length);
            this.logAdrDebug.trace(BAdrDevice.unescape(this.getName()) + "::searched program:: " + string);
            int n = 0;
            while (n < bAdrProgramArray.length) {
                this.logAdrDebug.trace(BAdrDevice.unescape(this.getName()) + "::looped progName:: " + bAdrProgramArray[n].getProgramName());
                if (bAdrProgramArray[n].getProgramName().equalsIgnoreCase(string)) {
                    bAdrProgram = bAdrProgramArray[n];
                    bAdrProgram.setMarkedForDeletion(false);
                    bAdrProgram.setParsedAlready(true);
                } else if (!bAdrProgramArray[n].getParsedAlready()) {
                    bAdrProgramArray[n].setMarkedForDeletion(true);
                }
                this.logAdrDebug.trace(BAdrDevice.unescape(this.getName()) + "::program-" + bAdrProgramArray[n].getName() + ", marked for deletion::" + bAdrProgramArray[n].getMarkedForDeletion() + " , parsed already::" + bAdrProgramArray[n].getParsedAlready());
                ++n;
            }
        }
        return bAdrProgram;
    }

    private final void parseOpModeSchedule(XElem xElem, BAdrEvent bAdrEvent) {
        String string;
        String string2;
        bAdrEvent.getOpModeSchedules().removeAll();
        XElem xElem2 = xElem.elem("OperationModeValue");
        if (xElem2 != null) {
            string2 = xElem2.string().toLowerCase();
            bAdrEvent.setOpModeValue(BAdrOperationModeValueEnum.make(string2));
            if (bAdrEvent.getEventInfo().equalsIgnoreCase("")) {
                bAdrEvent.setEventInfo("OPMODE_VALUE");
            } else {
                string = bAdrEvent.getEventInfo();
                bAdrEvent.setEventInfo(string + ",OPMODE_VALUE");
            }
            this.pingOk();
        } else {
            this.logAdrPoll.error(BAdrDevice.unescape(this.getName()) + "::Cannot call readOK on proxy point. Op Mode value XML tag is null");
        }
        string2 = xElem.elem("currentTime");
        if (string2 != null) {
            bAdrEvent.setCurrentTime(Double.parseDouble(string2.string().trim()));
        } else {
            this.logAdrPoll.error(BAdrDevice.unescape(this.getName()) + "::Simple DR Mode Data: Current time field is null");
        }
        if (this.getEnableCache()) {
            XElem[] xElemArray;
            string = xElem.elem("operationModeSchedule");
            if (string != null && (xElemArray = string.elems("modeSlot")) != null) {
                int n = 0;
                while (n < xElemArray.length) {
                    XElem xElem3 = xElemArray[n].elem("OperationModeValue");
                    XElem xElem4 = xElemArray[n].elem("modeTimeSlot");
                    if (xElem3 != null && xElem4 != null) {
                        String string3 = xElem3.string();
                        BAdrEventOpModeSchedule bAdrEventOpModeSchedule = new BAdrEventOpModeSchedule();
                        if (string3 != null) {
                            bAdrEventOpModeSchedule.setOpModeValue(BAdrOperationModeValueEnum.make(string3.trim().toLowerCase()));
                            bAdrEventOpModeSchedule.setModeTimeOffset(Integer.parseInt(xElem4.string().trim()));
                            bAdrEvent.getOpModeSchedules().add("Schedule" + n, (BValue)bAdrEventOpModeSchedule, 2);
                        }
                    }
                    ++n;
                }
            }
        } else {
            bAdrEvent.getOpModeSchedules().removeAll();
        }
    }

    private final BAdrEvent getEventAlreadyModeled(BAdrProgram bAdrProgram, String string) {
        BAdrEvent bAdrEvent = null;
        if (bAdrProgram != null) {
            BAdrEvent[] bAdrEventArray;
            Class clazz = class$com$tridium$adr$program$BAdrEvent;
            if (clazz == null) {
                clazz = class$com$tridium$adr$program$BAdrEvent = BAdrDevice.class("[Lcom.tridium.adr.program.BAdrEvent;", false);
            }
            if ((bAdrEventArray = (BAdrEvent[])bAdrProgram.getChildren(clazz)) != null && bAdrEventArray.length > 0) {
                int n = 0;
                while (n < bAdrEventArray.length) {
                    if (bAdrEventArray[n].getEventIdentifier().equalsIgnoreCase(string)) {
                        bAdrEvent = bAdrEventArray[n];
                        bAdrEvent.parsedAlready = true;
                        bAdrEvent.markedForDeletion = false;
                    } else if (!bAdrEventArray[n].parsedAlready) {
                        bAdrEventArray[n].markedForDeletion = true;
                    }
                    ++n;
                }
            }
        }
        return bAdrEvent;
    }

    public void doPing() {
        if (!this.isRunning()) {
            return;
        }
        this.logAdrPoll.trace(BAdrDevice.unescape(this.getName()) + "::Ping DRAS Server");
        if (this.mRESTClient == null) {
            this.mRESTClient = new AdrRestUtility(this, this.getUserName(), this.getPassword().getString(), this.getRestUrl());
        } else {
            this.mRESTClient.reInitialize(this.getUserName(), this.getPassword().getString(), this.getRestUrl());
        }
        this.executePing();
    }

    public void executePing() {
        try {
            XElem xElem = this.getRestClient().connectToServer();
            if (xElem != null) {
                this.pingOk();
            } else {
                this.logAdrComm.trace(BAdrDevice.unescape(this.getName()) + "::Device Ping failed-" + this.getRestClient().getErrorString());
                this.pingFail(this.getRestClient().getErrorString());
            }
        }
        catch (Exception exception) {
            this.logAdrComm.error(BAdrDevice.unescape(this.getName()) + "::doPing() got into exception ", (Throwable)exception);
            this.pingFail(this.getRestClient().getErrorString());
        }
    }

    protected IFuture postPing() {
        return this.getAdrNetwork().postAsync((Runnable)new Invocation((BComponent)this, ping, null, null));
    }

    public boolean isDeviceOk() {
        boolean bl = false;
        if (!(this.isDown() || this.isFatalFault() || this.isDisabled())) {
            bl = true;
        }
        boolean bl2 = bl;
        return bl2;
    }

    public boolean isDeviceUnhealthy() {
        boolean bl = false;
        if (this.isDown() || this.isFatalFault() || this.isDisabled()) {
            bl = true;
        }
        boolean bl2 = bl;
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getIsPollInProgress() {
        Object object = this.mPollingProgressSync;
        synchronized (object) {
            return this.mIsPollInProgress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setIsPollInProgress(boolean bl) {
        Object object = this.mPollingProgressSync;
        synchronized (object) {
            this.mIsPollInProgress = bl;
            return;
        }
    }

    public StringBuffer createResponse(boolean bl, String string, String string2, String string3, String string4, String string5, String string6) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        stringBuffer.append("<p:eventStateConfirmation currentTime=\"" + string5 + "\" drasClientID=\"" + string + '\"');
        stringBuffer.append(" eventIdentifier=\"" + string2 + "\" eventModNumber=\"" + string3 + "\" eventStateID=\"" + string4 + '\"');
        stringBuffer.append(" operationModeValue=\"" + string6 + "\" optInStatus=\"" + (bl ^ true) + "\" programName=\"Niagara\"");
        stringBuffer.append(" schemaVersion=\"\" xmlns:p=\"urn:EventState\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xsi:schemaLocation=\"urn:EventState EventState.xsd \">");
        stringBuffer.append("</p:eventStateConfirmation>");
        return stringBuffer;
    }

    static String escape(String string) {
        String string2 = "";
        try {
            string2 = SlotPath.escape((String)string);
        }
        catch (Exception exception) {
            string2 = string;
        }
        return string2;
    }

    static String unescape(String string) {
        String string2 = "";
        try {
            string2 = SlotPath.unescape((String)string);
        }
        catch (Exception exception) {
            string2 = string;
        }
        return string2;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.mHasEvents = true;
        this.toContinue = true;
        this.logAdrPoll = Log.getLog((String)"AdrPoll");
        this.logAdrComm = Log.getLog((String)"AdrComm");
        this.logAdrDebug = Log.getLog((String)"AdrDebug");
        this.logAdrEventsCache = Log.getLog((String)"AdrCache");
        this.mIsPollInProgress = false;
        this.mPollingProgressSync = new Object();
        this.mManualConfigSet = false;
        this.mHttpErrorCode = 200;
        this.dummy = 0;
    }

    public BAdrDevice() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$adr$BAdrDevice;
        if (clazz == null) {
            clazz = class$com$tridium$adr$BAdrDevice = BAdrDevice.class("[Lcom.tridium.adr.BAdrDevice;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        timeFacets = BFacets.make((String)"showMilliseconds", (boolean)true);
    }
}

