/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rapidEye.comm;

import com.tridium.ddf.comm.singleTransaction.BIDdfSingleTransactionMgr;
import com.tridium.ddfIp.comm.BDdfIpAddressPort;
import com.tridium.platform.tcpip.BPingArgs;
import com.tridium.platform.tcpip.BTcpIpPlatformService;
import com.tridium.rapidEye.comm.BRapidEyeTcpCommunicator;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import java.net.SocketException;
import javax.baja.log.Log;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RapidEyeLiveTcpSocketManager
implements Runnable {
    public static final int STATE_IDLE = 0;
    public static final int STATE_NO_SOCKET = 1;
    public static final int STATE_GOT_SOCKET = 2;
    public static final int NORMAL_MASTER_SLAVE = 0;
    public static final int SAME_SOCKET_MASTER_SLAVE = 1;
    public static final int SAME_SOCKET_SEND_OR_RECEIVE = 2;
    protected Object idleMonitor;
    protected Object connectMonitor;
    protected Socket commSocket;
    protected InputStream inStream;
    protected OutputStream outStream;
    protected int numOutstandingRequests;
    protected int numConnectionFailures;
    protected int state;
    public int mode;
    protected BRapidEyeTcpCommunicator tcpCommunicator;
    protected boolean running;
    public PipedOutputStream bos;
    public PipedInputStream bin;
    protected Object readMonitor;
    protected Object ioMonitor;
    protected boolean messageSent;
    protected long timeTxEnd;
    protected long timeRxEnd;
    protected BFacets SHOW_SECONDS_AND_MILLIS;

    protected boolean isTraceOn() {
        return this.getLog().isTraceOn();
    }

    public void startSocketManager() {
        this.running = true;
        if (this.isTraceOn()) {
            this.trace("entered method startSocketManager");
        }
        this.switchState(1);
    }

    protected boolean isConnected() {
        if (this.mode == 0) {
            boolean bl = false;
            if (this.state == 2) {
                bl = true;
            }
            return bl;
        }
        boolean bl = false;
        if (this.state != 0) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void switchState(int n) {
        if (this.isTraceOn()) {
            this.trace("entered method switchState");
            this.trace("old state = " + this.state);
            this.trace("new state = " + n);
        }
        if (this.state == n) {
            return;
        }
        this.state = n;
        if (n == 1) {
            this.numConnectionFailures = 0;
        }
        Object object = this.idleMonitor;
        synchronized (object) {
            this.idleMonitor.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stopSocketManager() {
        if (this.isTraceOn()) {
            this.trace("entered method stopSocketManager");
        }
        this.running = false;
        Object object = this.readMonitor;
        synchronized (object) {
            try {
                this.readMonitor.notifyAll();
            }
            catch (Exception exception) {}
            this.switchState(0);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doIdle() {
        this.closeSocket();
        this.nullStreams();
        Object object = this.idleMonitor;
        synchronized (object) {
            try {
                this.idleMonitor.wait(100L);
            }
            catch (InterruptedException interruptedException) {}
            return;
        }
    }

    protected void finiteStateMachine() {
        if (this.isTraceOn()) {
            this.trace("entered method finiteStateMachine()");
        }
        switch (this.state) {
            case 0: {
                this.doIdle();
                break;
            }
            case 1: {
                if (this.tcpCommunicator.getDdfTransactionMgr() instanceof BIDdfSingleTransactionMgr) {
                    if (this.mode == 2) {
                        this.waitLittleWhileForSend();
                    } else {
                        this.waitForeverForSend();
                    }
                }
                if (!this.running || this.state == 0) break;
                this.initSocketConnection();
                break;
            }
            case 2: {
                if (this.tcpCommunicator.getDdfTransactionMgr() instanceof BIDdfSingleTransactionMgr) {
                    this.waitLittleWhileForSend();
                }
                this.readMessage();
                break;
            }
        }
    }

    protected String getPrefix() {
        return "";
    }

    protected void trace(String string) {
        this.getLog().trace(this.getPrefix() + string + "[timestamp=" + Clock.ticks() + ']');
    }

    protected Log getLog() {
        return Log.getLog((String)(this.tcpCommunicator.getLog().getLogName() + "_TcpSocketManager_MODE" + this.mode));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readMessageFromStream() {
        Object object = this.ioMonitor;
        synchronized (object) {
            block18: {
                if (this.isTraceOn()) {
                    this.trace("entered method readMessageFromStream");
                }
                int n = 261;
                try {
                    n = this.inStream.available() > 0 ? this.inStream.available() : 261;
                }
                catch (Exception exception) {}
                try {
                    if (this.mode == 2 && this.inStream.available() <= 0) {
                        throw new InterruptedIOException("instream.available < 0");
                    }
                    byte[] byArray = new byte[n];
                    if (this.isTraceOn()) {
                        this.trace("Reading from input stream, inStream=" + this.inStream);
                    }
                    int n2 = this.inStream.read(byArray, 0, n);
                    if (this.isTraceOn()) {
                        this.trace("finished read from instream, rxSize=" + n2);
                    }
                    if (n2 == -1) {
                        if (this.isTraceOn()) {
                            this.trace("bad read! switching state to force reinitialize socket");
                        }
                        this.switchState(1);
                    } else {
                        this.timeRxEnd = System.currentTimeMillis();
                        if (this.isTraceOn()) {
                            StringWriter stringWriter = new StringWriter();
                            PrintWriter printWriter = new PrintWriter(stringWriter);
                            ByteArrayUtil.hexDump((PrintWriter)printWriter, (byte[])byArray, (int)0, (int)n2);
                            printWriter.flush();
                            printWriter.close();
                            String string = stringWriter.toString();
                            this.trace(":" + this.tcpCommunicator.getSlotPath() + ':' + this.getDebugCurTimeSecAndMs() + ":RX:\n" + string + "\nTcp/Ip response time(milliSec) = " + (this.timeRxEnd - this.timeTxEnd));
                        }
                        this.numOutstandingRequests = 0;
                        try {
                            this.bos.write(byArray, 0, n2);
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Exception exception) {
                    this.processReadStreamException(exception);
                    if (this.state == 0) break block18;
                    this.switchState(1);
                }
            }
            if (this.mode == 0) {
                this.considerReinitialize();
            }
            return;
        }
    }

    public int readByte() throws Exception {
        return this.bin.read();
    }

    protected void processReadStreamException(Exception exception) {
        if (this.isTraceOn()) {
            this.trace("entered method processReadStreamException");
        }
        if (exception instanceof SocketException) {
            this.trace("Tcp/Ip SOCKET connection lost to " + this.getPrefix() + "!!!");
            try {
                this.tcpCommunicator.doRestartSession();
            }
            catch (Exception exception2) {}
        } else if (exception instanceof NullPointerException) {
            this.trace("java.lang.NullPointerException\n" + exception.getLocalizedMessage());
        } else if (exception instanceof InterruptedIOException) {
            this.trace("java.io.InterruptedIOException\n" + exception.getLocalizedMessage());
        } else {
            this.tcpCommunicator.getLog().error(exception.toString(), (Throwable)exception);
        }
    }

    protected void considerReinitialize() {
        if (this.isTraceOn()) {
            this.trace("entered method considerReinitialize");
        }
        if (this.numOutstandingRequests > 1) {
            this.switchState(1);
        }
    }

    protected void setNextReadTimeout() {
        block3: {
            if (this.isTraceOn()) {
                this.trace("entered method setNextReadTimeout()");
            }
            try {
                this.commSocket.setSoTimeout(3000);
            }
            catch (Exception exception) {
                if (!this.isTraceOn()) break block3;
                this.trace("exception caught setting so timeout, e=" + exception);
            }
        }
    }

    protected void readMessage() {
        this.setNextReadTimeout();
        this.readMessageFromStream();
    }

    public void run() {
        if (this.isTraceOn()) {
            this.trace("entered method run");
        }
        while (this.running) {
            this.finiteStateMachine();
        }
        if (this.isTraceOn()) {
            this.trace("Socket Manager Thread Stopped" + Thread.currentThread().getName());
        }
    }

    protected void closeSocket() {
        block4: {
            if (this.isTraceOn()) {
                this.trace("entered method closeSocket");
            }
            if (this.commSocket != null) {
                try {
                    this.commSocket.shutdownInput();
                    this.commSocket.shutdownOutput();
                    this.commSocket.close();
                }
                catch (Exception exception) {
                    if (!this.isTraceOn()) break block4;
                    this.trace("exception caught from closeSocket() while closing commSocket" + exception);
                }
            }
        }
        this.commSocket = null;
    }

    protected void failureSocketConnectionInit(Exception exception) {
        if (this.isTraceOn()) {
            this.trace("entered method failureSocketConnectionInit");
            this.trace(this.getDebugCurTimeSecAndMs() + " Tcp/Ip - Cannot open socket connection to " + this.getPrefix() + '.');
            exception.printStackTrace();
        }
        ++this.numConnectionFailures;
        this.nullStreams();
        this.closeSocket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void notifyConnectMonitor() {
        Object object = this.connectMonitor;
        synchronized (object) {
            this.connectMonitor.notifyAll();
            return;
        }
    }

    protected void successSocketConnectionInit() {
        if (this.isTraceOn()) {
            this.trace("entered method successSocketConnectionInit");
            this.trace(this.getDebugCurTimeSecAndMs() + " Tcp/Ip - socket connection established to " + this.getPrefix() + '.');
        }
        this.switchState(2);
        this.numOutstandingRequests = 0;
        this.notifyConnectMonitor();
    }

    protected String getDestAddress() {
        return this.tcpCommunicator.getMainCommunicator().getDestinationAddress().getIpAddress();
    }

    protected int getConnectionTimeout() {
        return (int)this.tcpCommunicator.getTcpIpComm().getSocketConnectionTimeout().getMillis();
    }

    protected long getResponseTimeout() {
        long l = this.tcpCommunicator.getReceiver().getResponseTimeout().getMillis();
        if (l < 100L) {
            l = 100L;
        }
        return l;
    }

    protected boolean icmpPing(String string) {
        BTcpIpPlatformService bTcpIpPlatformService = (BTcpIpPlatformService)Sys.getService((Type)BTcpIpPlatformService.TYPE);
        try {
            BInteger bInteger = bTcpIpPlatformService.ping(new BPingArgs(string, 10));
            boolean bl = false;
            if (bInteger.getInt() >= 0) {
                bl = true;
            }
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected void connectSocket() throws Exception {
        if (this.isTraceOn()) {
            this.trace("entered method connectSocket");
        }
        String string = this.getDestAddress();
        if (this.isTraceOn()) {
            this.trace("userIpText=" + string);
        }
        if (string == null || string.length() <= 0 || string.equals("[***DEFAULT***]") || string.equals(BDdfIpAddressPort.ipAddress.getDefaultValue().toString())) {
            if (this.isTraceOn()) {
                this.trace("Could not conclude that the IP address [" + string + "] is valid.");
            }
            throw new SocketException("Could not conclude that the IP address [" + string + "] is valid.");
        }
        if (this.isTraceOn()) {
            this.trace("Pinging  device (same ping as DOS cmd prompt would use) using 500 ms. ping timeout...");
        }
        if (this.mode == 0 && !this.icmpPing(string)) {
            if (!this.icmpPing(string)) {
                if (this.isTraceOn()) {
                    this.trace("--- NO RESPONSE to ping (same procedure as DOS cmd prompt would use)!!! ---");
                }
                throw new IOException("Device did not respond to ping (same ping as DOS cmd prompt would use)!");
            }
            if (this.isTraceOn()) {
                this.trace("Device responded to ping (same ping as DOS cmd prompt would use)!");
            }
        } else if (this.isTraceOn()) {
            this.trace("Device responded to ping (same ping as DOS cmd prompt would use)!");
        }
        if (this.isTraceOn()) {
            this.trace("getting new socket");
        }
        this.commSocket = this.tcpCommunicator.getTcpIpComm().createSocket();
    }

    protected void nullStreams() {
        if (this.isTraceOn()) {
            this.trace("entered method nullStreams");
        }
        try {
            this.inStream.close();
            this.outStream.close();
        }
        catch (Exception exception) {}
        this.inStream = null;
        this.outStream = null;
    }

    protected void createStreams() throws IOException {
        if (this.isTraceOn()) {
            this.trace("entered method createStreams");
        }
        if (this.inStream == null) {
            if (this.isTraceOn()) {
                this.trace("getting new input stream");
            }
            this.inStream = this.commSocket.getInputStream();
        }
        if (this.outStream == null) {
            if (this.isTraceOn()) {
                this.trace("getting new output stream");
            }
            this.outStream = this.commSocket.getOutputStream();
        }
    }

    protected synchronized void initSocketConnection() {
        if (this.isTraceOn()) {
            this.trace("entered method initSocketConnection");
        }
        try {
            if (this.mode == 0) {
                this.nullStreams();
                this.closeSocket();
            }
            if (this.commSocket == null || this.mode == 0) {
                this.connectSocket();
            }
            this.createStreams();
            this.successSocketConnectionInit();
        }
        catch (Exception exception) {
            this.failureSocketConnectionInit(exception);
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception2) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void notifyReceiveMonitor() {
        Object object = this.readMonitor;
        synchronized (object) {
            this.readMonitor.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void waitForeverForSend() {
        if (this.isTraceOn()) {
            this.trace("entered method waitForeverForSend");
        }
        if (!this.messageSent) {
            Object object = this.readMonitor;
            synchronized (object) {
                try {
                    this.readMonitor.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.isTraceOn()) {
            this.trace("exiting method waitForeverForSend");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void waitLittleWhileForSend() {
        if (this.isTraceOn()) {
            this.trace("entered method waitLittleWhileForSend");
        }
        if (!this.messageSent) {
            Object object = this.readMonitor;
            synchronized (object) {
                try {
                    this.readMonitor.wait(3000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.isTraceOn()) {
            this.trace("exiting method waitLittleWhileForSend");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void waitForConnect(long l) {
        Object object = this.connectMonitor;
        synchronized (object) {
            try {
                if (this.isTraceOn()) {
                    this.trace("waitForConnect - waiting for up to " + l + " milliseconds.");
                }
                this.connectMonitor.wait(l);
                if (this.isTraceOn()) {
                    this.trace("waitForConnect - woke up from wait");
                }
            }
            catch (InterruptedException interruptedException) {
                if (this.isTraceOn()) {
                    this.trace("waitForConnect interrupted while waiting");
                }
            }
            return;
        }
    }

    protected void waitAWhileForConnect() {
        long l = this.getConnectionTimeout();
        long l2 = l = l < 13000L ? 13000L : l;
        if (this.isTraceOn()) {
            this.trace("entered method waitLittleWhileForConnect");
        }
        this.waitForConnect(l);
        if (this.isTraceOn()) {
            this.trace("exiting method waitLittleWhileForConnect");
        }
    }

    protected boolean isConnecting() {
        boolean bl = false;
        if (this.state == 1) {
            bl = true;
        }
        return bl;
    }

    protected boolean isConnectingFirstTime() {
        boolean bl = false;
        if (this.isConnecting() && this.numConnectionFailures == 0) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeOutputStream(byte[] byArray, int n, int n2, boolean bl) throws Exception {
        Object object;
        block10: {
            if (this.isTraceOn()) {
                this.trace("entered method writeOutputStream");
            }
            if (this.isConnecting() && bl) {
                object = this.connectMonitor;
                synchronized (object) {
                    block9: {
                        this.notifyReceiveMonitor();
                        if (!this.isConnectingFirstTime()) break block9;
                        this.waitAWhileForConnect();
                        break block10;
                    }
                    this.waitForConnect(this.getResponseTimeout());
                }
            }
        }
        if (!this.isConnected()) throw new SocketException();
        object = this.ioMonitor;
        synchronized (object) {
            ++this.numOutstandingRequests;
            this.outStream.write(byArray, n, n2);
            if (this.isTraceOn()) {
                this.trace("Message written to the stream ::  Start >>>");
                ByteArrayUtil.hexDump((byte[])byArray);
                this.trace("<<< End of Message written to the stream ");
            }
            this.outStream.flush();
            // MONITOREXIT @DISABLED, blocks:[1, 3] lbl27 : MonitorExitStatement: MONITOREXIT : var5_5
            if (!bl) return;
            this.notifyReceiveMonitor();
            return;
        }
    }

    protected String getDebugCurTimeSecAndMs() {
        return BAbsTime.now().toString((Context)this.SHOW_SECONDS_AND_MILLIS);
    }

    private final /* synthetic */ void this() {
        this.idleMonitor = new Object();
        this.connectMonitor = new Object();
        this.inStream = null;
        this.outStream = null;
        this.numOutstandingRequests = 0;
        this.numConnectionFailures = 0;
        this.state = 0;
        this.mode = 0;
        this.running = true;
        this.readMonitor = new Object();
        this.ioMonitor = new Object();
        this.messageSent = false;
        this.SHOW_SECONDS_AND_MILLIS = BFacets.make((BFacets)BFacets.make((String)"showSeconds", (boolean)true), (BFacets)BFacets.make((String)"showMilliseconds", (boolean)true));
    }

    public RapidEyeLiveTcpSocketManager(BRapidEyeTcpCommunicator bRapidEyeTcpCommunicator, int n) {
        this.this();
        this.tcpCommunicator = bRapidEyeTcpCommunicator;
        this.mode = n;
        if (this.isTraceOn()) {
            this.trace("entered constructor RapidEyeLiveTcpSocketManager");
        }
        this.switchState(0);
        this.bos = new PipedOutputStream();
        try {
            this.bin = new PipedInputStream(this.bos);
        }
        catch (Exception exception) {
            this.tcpCommunicator.getLog().error(exception.toString(), (Throwable)exception);
        }
    }
}

