/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rapidEye.comm;

import com.tridium.ddf.IDdfFacetConst;
import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.defaultComm.BDdfReceiver;
import com.tridium.ddf.comm.defaultComm.BDdfTransactionMgr;
import com.tridium.ddf.comm.defaultComm.BDdfTransmitter;
import com.tridium.ddf.comm.defaultComm.BDdfUnsolicitedMgr;
import com.tridium.ddf.comm.req.BDdfDiscoveryRequest;
import com.tridium.ddf.comm.req.BDdfRequest;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.comm.singleTransaction.BDdfSingleTransactionMgr;
import com.tridium.ddfIp.comm.BDdfIpCommunicator;
import com.tridium.rapidEye.BRapidEyeDvr;
import com.tridium.rapidEye.comm.BRapidEyeCommunicator;
import com.tridium.rapidEye.comm.BRapidEyeTcpHelper;
import com.tridium.rapidEye.comm.BRapidEyeTcpReceiver;
import com.tridium.rapidEye.comm.BRapidEyeTcpTransmitter;
import com.tridium.rapidEye.comm.BRapidEyeUnsolicitedMgr;
import com.tridium.rapidEye.comm.RapidEyeLiveTcpSocketManager;
import com.tridium.rapidEye.comm.req.BIRapidEyeBasicTcpRequest;
import com.tridium.rapidEye.comm.req.BIRapidEyeCommand;
import com.tridium.rapidEye.comm.req.BIRapidEyeDiscover;
import com.tridium.rapidEye.comm.req.BIRapidEyeSessionRequest;
import com.tridium.rapidEye.comm.req.live.BRapidEyeOpenLiveRequest;
import javax.baja.job.BJobState;
import javax.baja.log.Log;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BRapidEyeTcpCommunicator
extends BDdfIpCommunicator {
    public static final Property tcpIpComm = BRapidEyeTcpCommunicator.newProperty((int)0, (BValue)new BRapidEyeTcpHelper(), (BFacets)IDdfFacetConst.MGR_INCLUDE);
    public static final Property transactionManager = BRapidEyeTcpCommunicator.newProperty((int)0, (BValue)new BDdfSingleTransactionMgr(), null);
    public static final Property transmitter = BRapidEyeTcpCommunicator.newProperty((int)0, (BValue)new BRapidEyeTcpTransmitter(), null);
    public static final Property receiver = BRapidEyeTcpCommunicator.newProperty((int)0, (BValue)new BRapidEyeTcpReceiver(), null);
    public static final Property unsolicitedMgr = BRapidEyeTcpCommunicator.newProperty((int)0, (BValue)new BRapidEyeUnsolicitedMgr(), null);
    public static final Property mode = BRapidEyeTcpCommunicator.newProperty((int)4, (int)0, null);
    public static final Property sessionActive = BRapidEyeTcpCommunicator.newProperty((int)1, (boolean)false, null);
    public static final Property sessionRequestSent = BRapidEyeTcpCommunicator.newProperty((int)1, (boolean)false, null);
    public static final Property activated = BRapidEyeTcpCommunicator.newProperty((int)1, (boolean)false, null);
    public static final Action startSession = BRapidEyeTcpCommunicator.newAction((int)0, null);
    public static final Action stopSession = BRapidEyeTcpCommunicator.newAction((int)0, null);
    public static final Action restartSession = BRapidEyeTcpCommunicator.newAction((int)0, null);
    public static final Type TYPE;
    public static final int NORMAL_MASTER_SLAVE = 0;
    public static final int SAME_SOCKET_MASTER_SLAVE = 1;
    public static final int SAME_SOCKET_SEND_OR_RECEIVE = 2;
    protected RapidEyeLiveTcpSocketManager socketManager;
    protected Thread socketManagerThread;
    public Thread sessionStarter;
    public BAbsTime lastSessionStartTime;
    protected IDdfDataFrame discoverResponse;
    public IDdfDataFrame discoveredData;
    BRapidEyeCommunicator mainCommunicator;
    static /* synthetic */ Class class$com$tridium$rapidEye$comm$BRapidEyeTcpCommunicator;

    public BRapidEyeTcpHelper getTcpIpComm() {
        return (BRapidEyeTcpHelper)this.get(tcpIpComm);
    }

    public void setTcpIpComm(BRapidEyeTcpHelper bRapidEyeTcpHelper) {
        this.set(tcpIpComm, (BValue)bRapidEyeTcpHelper, null);
    }

    public BDdfTransactionMgr getTransactionManager() {
        return (BDdfTransactionMgr)this.get(transactionManager);
    }

    public void setTransactionManager(BDdfTransactionMgr bDdfTransactionMgr) {
        this.set(transactionManager, (BValue)bDdfTransactionMgr, null);
    }

    public BDdfTransmitter getTransmitter() {
        return (BDdfTransmitter)this.get(transmitter);
    }

    public void setTransmitter(BDdfTransmitter bDdfTransmitter) {
        this.set(transmitter, (BValue)bDdfTransmitter, null);
    }

    public BDdfReceiver getReceiver() {
        return (BDdfReceiver)this.get(receiver);
    }

    public void setReceiver(BDdfReceiver bDdfReceiver) {
        this.set(receiver, (BValue)bDdfReceiver, null);
    }

    public BDdfUnsolicitedMgr getUnsolicitedMgr() {
        return (BDdfUnsolicitedMgr)this.get(unsolicitedMgr);
    }

    public void setUnsolicitedMgr(BDdfUnsolicitedMgr bDdfUnsolicitedMgr) {
        this.set(unsolicitedMgr, (BValue)bDdfUnsolicitedMgr, null);
    }

    public int getMode() {
        return this.getInt(mode);
    }

    public void setMode(int n) {
        this.setInt(mode, n, null);
    }

    public boolean getSessionActive() {
        return this.getBoolean(sessionActive);
    }

    public void setSessionActive(boolean bl) {
        this.setBoolean(sessionActive, bl, null);
    }

    public boolean getSessionRequestSent() {
        return this.getBoolean(sessionRequestSent);
    }

    public void setSessionRequestSent(boolean bl) {
        this.setBoolean(sessionRequestSent, bl, null);
    }

    public boolean getActivated() {
        return this.getBoolean(activated);
    }

    public void setActivated(boolean bl) {
        this.setBoolean(activated, bl, null);
    }

    public void startSession() {
        this.invoke(startSession, null, null);
    }

    public void stopSession() {
        this.invoke(stopSession, null, null);
    }

    public void restartSession() {
        this.invoke(restartSession, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Log getLog() {
        String string = this.getType().getTypeSpec().getTypeName();
        if (string != null) {
            Object object = this.getHandle();
            if (object != null) {
                string = string + ".h" + object + '.' + this.getMainCommunicator().getDestinationAddress().getIpAddress();
            }
            return Log.getLog((String)string);
        }
        return Log.getLog((String)(this.getName() + '_' + this.getMainCommunicator().getDestinationAddress().getIpAddress()));
    }

    public void startTcpCommunicating() {
        this.initSocketManager();
        if (this.getLog().isTraceOn()) {
            this.getLog().trace("Starting Normal communications.");
        }
        this.socketManager.startSocketManager();
        if (this.getLog().isTraceOn()) {
            this.getLog().trace("BDdfTcpCommunicator [" + (Object)((Object)this) + " - TcpSocket] started!");
        }
    }

    public void startCommunicating() {
        this.startTcpCommunicating();
        super.startCommunicating();
    }

    public void stopCommunicating() {
        this.finishSocketManager();
        super.stopCommunicating();
    }

    public final void ipCommunicatorStarted() throws Exception {
        this.tcpCommunicatorStarted();
    }

    public final void ipCommunicatorStopped() throws Exception {
        if (this.getLog().isTraceOn()) {
            this.getLog().trace("BDdfTcpCommunicator [" + (Object)((Object)this) + " -TcpSocket] stopped!");
        }
        this.tcpCommunicatorStopped();
    }

    protected RapidEyeLiveTcpSocketManager makeSocketManager() {
        return new RapidEyeLiveTcpSocketManager(this, this.getMode());
    }

    protected Thread makeSocketManagerThread(RapidEyeLiveTcpSocketManager rapidEyeLiveTcpSocketManager) {
        return new Thread((Runnable)rapidEyeLiveTcpSocketManager, this.getLog().getLogName() + ":TcpSoMan");
    }

    protected void initSocketManager() {
        this.socketManager = this.makeSocketManager();
        this.socketManagerThread = this.makeSocketManagerThread(this.socketManager);
        if (this.getLog().isTraceOn()) {
            this.getLog().trace("starting new socket manager thread");
        }
        this.socketManagerThread.start();
    }

    protected void finishSocketManager() {
        if (this.getLog().isTraceOn()) {
            this.getLog().trace("Interrupting the present Socket Manager");
        }
        this.socketManager.stopSocketManager();
        this.socketManagerThread.interrupt();
    }

    public RapidEyeLiveTcpSocketManager getTcpSocketManager() {
        return this.socketManager;
    }

    protected void tcpCommunicatorStarted() throws Exception {
        this.setSessionActive(false);
        this.setActivated(false);
        this.setSessionRequestSent(false);
    }

    protected void tcpCommunicatorStopped() throws Exception {
        this.discoverResponse = null;
        this.doStopSession();
    }

    public BRapidEyeDvr getDvr() {
        return ((BRapidEyeCommunicator)this.getParent()).getHoneywellDvr();
    }

    public BRapidEyeCommunicator getMainCommunicator() {
        if (this.getParent() instanceof BRapidEyeCommunicator) {
            return (BRapidEyeCommunicator)this.getParent();
        }
        return this.mainCommunicator;
    }

    public void communicate(BIDdfRequest bIDdfRequest) {
        if (this.getMode() == 0 || this.getSessionActive() || bIDdfRequest instanceof BIRapidEyeSessionRequest || bIDdfRequest instanceof BRapidEyeOpenLiveRequest || bIDdfRequest instanceof BIRapidEyeDiscover) {
            if (bIDdfRequest instanceof BIRapidEyeCommand) {
                this.getDdfTransmitter().transmitRequest(bIDdfRequest);
            } else {
                super.communicate(bIDdfRequest);
                if (bIDdfRequest instanceof BIRapidEyeDiscover && !this.getSessionActive() && ((BDdfDiscoveryRequest)bIDdfRequest).getDiscoverer() != null) {
                    ((BDdfDiscoveryRequest)bIDdfRequest).getDiscoverer().getJob().complete(BJobState.failed);
                    ((BDdfDiscoveryRequest)bIDdfRequest).getDiscoverer().discoverFail("Illegal Device Status");
                }
            }
        } else {
            try {
                this.doRestartSession();
            }
            catch (Exception exception) {
                this.getLog().error("Exception in restarting session in communicate " + exception.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createAndSendRequestOfType(Type type) throws Exception {
        BDdfRequest bDdfRequest = (BDdfRequest)type.getInstance();
        ((BIRapidEyeBasicTcpRequest)bDdfRequest).setCommunicator(this);
        bDdfRequest.setResponseTimeout(this.getDdfReceiver().getResponseTimeout());
        bDdfRequest.setRemainingRetryCount(0);
        this.communicate((BIDdfRequest)bDdfRequest);
        BDdfRequest bDdfRequest2 = bDdfRequest;
        synchronized (bDdfRequest2) {
            Log.getLog((String)"RapidEyeRequest.sync").trace("Waiting on " + bDdfRequest.getType());
            bDdfRequest.wait(this.getDdfReceiver().getResponseTimeout().getMillis());
            return;
        }
    }

    public void sendSeesionRequest() throws Exception {
        if (this.getSessionActive() || this.getActivated()) {
            throw new BajaRuntimeException("Session Already Active");
        }
        Type type = this.getSessionRequestType();
        if (type != null) {
            this.setSessionRequestSent(true);
            this.createAndSendRequestOfType(type);
            if (!this.getSessionActive()) {
                throw new Exception("Did not get a valid session");
            }
        }
    }

    public void sendActivateRequest() throws Exception {
        if (this.getActivated()) {
            return;
        }
        Type type = this.getActivateRequestType();
        if (type != null) {
            this.createAndSendRequestOfType(type);
            if (!this.getActivated()) {
                throw new Exception("Did not get activated response");
            }
        }
    }

    public void sendDiscoverRequest() throws Exception {
        Type type = this.getDiscoverRequestType();
        if (type != null) {
            this.createAndSendRequestOfType(type);
        }
    }

    public void processUnsolicitedFrame(IDdfDataFrame iDdfDataFrame) throws Exception {
    }

    public Type getSessionRequestType() {
        return null;
    }

    public Type getActivateRequestType() {
        return null;
    }

    public Type getDiscoverRequestType() {
        return null;
    }

    public void setCommunicator(BRapidEyeCommunicator bRapidEyeCommunicator) {
        this.mainCommunicator = bRapidEyeCommunicator;
    }

    public void doStopSession() {
        this.discoveredData = null;
        this.socketManager.doIdle();
        this.setSessionActive(false);
        this.setSessionRequestSent(false);
        this.setActivated(false);
        if (this.socketManager.mode != 0) {
            this.socketManager.mode = 1;
        }
        this.infiniteQueue.clear();
    }

    public void doStartSession() throws Exception {
        if (!this.getSessionActive() && !this.getSessionRequestSent()) {
            this.setSessionRequestSent(true);
            this.sendSeesionRequest();
            this.sendActivateRequest();
        }
        this.socketManager.mode = this.getMode();
    }

    public void doRestartSession() throws Exception {
        this.doStopSession();
        this.doStartSession();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.discoverResponse = null;
        this.discoveredData = null;
        this.mainCommunicator = null;
    }

    public BRapidEyeTcpCommunicator(int n) {
        this.this();
        this.setMode(n);
    }

    public BRapidEyeTcpCommunicator() {
        this.this();
        this.setMode(0);
    }

    static {
        Class clazz = class$com$tridium$rapidEye$comm$BRapidEyeTcpCommunicator;
        if (clazz == null) {
            clazz = class$com$tridium$rapidEye$comm$BRapidEyeTcpCommunicator = BRapidEyeTcpCommunicator.class("[Lcom.tridium.rapidEye.comm.BRapidEyeTcpCommunicator;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

