/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rapidEye.comm;

import com.tridium.ddf.IDdfFacetConst;
import com.tridium.ddf.comm.BIDdfCommunicating;
import com.tridium.ddf.comm.defaultComm.BDdfCommunicator;
import com.tridium.ddf.comm.defaultComm.BDdfReceiver;
import com.tridium.ddf.comm.defaultComm.BDdfTransactionMgr;
import com.tridium.ddf.comm.defaultComm.BDdfTransmitter;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.comm.singleTransaction.BDdfSingleTransactionMgr;
import com.tridium.ddfIp.comm.BDdfIpAddressPort;
import com.tridium.ddfVideo.camera.BDdfCameraDeviceExt;
import com.tridium.rapidEye.BRapidEyeCamera;
import com.tridium.rapidEye.BRapidEyeDvr;
import com.tridium.rapidEye.BRapidEyeNetwork;
import com.tridium.rapidEye.comm.BRapidEyeAlarmTcpCommunicator;
import com.tridium.rapidEye.comm.BRapidEyeEventTcpCommunicator;
import com.tridium.rapidEye.comm.BRapidEyeLiveTcpCommunicator;
import com.tridium.rapidEye.comm.BRapidEyeReceiver;
import com.tridium.rapidEye.comm.BRapidEyeTcpCommunicator;
import com.tridium.rapidEye.comm.BRapidEyeTransmitter;
import com.tridium.rapidEye.comm.req.BIRapidEyeBasicTcpRequest;
import com.tridium.rapidEye.comm.req.BIRapidEyeTcpRequest;
import com.tridium.rapidEye.comm.req.BRapidEyeCameraStreamRequest;
import com.tridium.rapidEye.comm.req.alarm.BIRapidEyeAlarmTcpRequest;
import com.tridium.rapidEye.comm.req.events.BIRapidEyeEventTcpRequest;
import com.tridium.rapidEye.comm.req.live.BIRapidEyeLiveTcpRequest;
import com.tridium.rapidEye.identify.BRapidEyeCameraId;
import com.tridium.rapidEye.identify.BRapidEyeDvrId;
import javax.baja.log.Log;
import javax.baja.security.BPassword;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BRapidEyeCommunicator
extends BDdfCommunicator {
    public static final Property transmitter = BRapidEyeCommunicator.newProperty((int)0, (BValue)new BRapidEyeTransmitter(), null);
    public static final Property receiver = BRapidEyeCommunicator.newProperty((int)0, (BValue)new BRapidEyeReceiver(), null);
    public static final Property tcpCommunicator = BRapidEyeCommunicator.newProperty((int)0, (BValue)new BRapidEyeTcpCommunicator(0), null);
    public static final Property liveTcpCommunicator = BRapidEyeCommunicator.newProperty((int)0, (BValue)new BRapidEyeLiveTcpCommunicator(1), null);
    public static final Property alarmTcpCommunicator = BRapidEyeCommunicator.newProperty((int)0, (BValue)new BRapidEyeAlarmTcpCommunicator(2), null);
    public static final Property eventTcpCommunicator = BRapidEyeCommunicator.newProperty((int)0, (BValue)new BRapidEyeEventTcpCommunicator(1), null);
    public static final Property transactionManager = BRapidEyeCommunicator.newProperty((int)0, (BValue)new BDdfSingleTransactionMgr(), null);
    public static final Property destinationAddress = BRapidEyeCommunicator.newProperty((int)0, (BValue)new BDdfIpAddressPort(10000), (BFacets)IDdfFacetConst.MGR_INCLUDE);
    public static final Property rapidEyeUserName = BRapidEyeCommunicator.newProperty((int)0, (String)"administrator", (BFacets)IDdfFacetConst.MGR_INCLUDE);
    public static final Property rapidEyePassword = BRapidEyeCommunicator.newProperty((int)0, (BValue)BPassword.make((String)""), (BFacets)IDdfFacetConst.MGR_INCLUDE);
    public static final Type TYPE;
    public static Log log1;
    protected static Log log2;
    public static Object connection;
    public boolean needToDisconnect;
    private BIDdfCommunicating communicatingParent;
    public int connectionStatus;
    boolean connecting;
    BAbsTime lastfailedAttempt;
    int failedConnectAttemptCount;
    int maxNumFailedAttempts;
    static /* synthetic */ Class class$com$tridium$rapidEye$comm$BRapidEyeCommunicator;
    static /* synthetic */ Class class$com$tridium$rapidEye$BRapidEyeCamera;

    public BDdfTransmitter getTransmitter() {
        return (BDdfTransmitter)this.get(transmitter);
    }

    public void setTransmitter(BDdfTransmitter bDdfTransmitter) {
        this.set(transmitter, (BValue)bDdfTransmitter, null);
    }

    public BDdfReceiver getReceiver() {
        return (BDdfReceiver)this.get(receiver);
    }

    public void setReceiver(BDdfReceiver bDdfReceiver) {
        this.set(receiver, (BValue)bDdfReceiver, null);
    }

    public BRapidEyeTcpCommunicator getTcpCommunicator() {
        return (BRapidEyeTcpCommunicator)this.get(tcpCommunicator);
    }

    public void setTcpCommunicator(BRapidEyeTcpCommunicator bRapidEyeTcpCommunicator) {
        this.set(tcpCommunicator, (BValue)bRapidEyeTcpCommunicator, null);
    }

    public BRapidEyeLiveTcpCommunicator getLiveTcpCommunicator() {
        return (BRapidEyeLiveTcpCommunicator)this.get(liveTcpCommunicator);
    }

    public void setLiveTcpCommunicator(BRapidEyeLiveTcpCommunicator bRapidEyeLiveTcpCommunicator) {
        this.set(liveTcpCommunicator, (BValue)bRapidEyeLiveTcpCommunicator, null);
    }

    public BRapidEyeAlarmTcpCommunicator getAlarmTcpCommunicator() {
        return (BRapidEyeAlarmTcpCommunicator)this.get(alarmTcpCommunicator);
    }

    public void setAlarmTcpCommunicator(BRapidEyeAlarmTcpCommunicator bRapidEyeAlarmTcpCommunicator) {
        this.set(alarmTcpCommunicator, (BValue)bRapidEyeAlarmTcpCommunicator, null);
    }

    public BRapidEyeEventTcpCommunicator getEventTcpCommunicator() {
        return (BRapidEyeEventTcpCommunicator)this.get(eventTcpCommunicator);
    }

    public void setEventTcpCommunicator(BRapidEyeEventTcpCommunicator bRapidEyeEventTcpCommunicator) {
        this.set(eventTcpCommunicator, (BValue)bRapidEyeEventTcpCommunicator, null);
    }

    public BDdfTransactionMgr getTransactionManager() {
        return (BDdfTransactionMgr)this.get(transactionManager);
    }

    public void setTransactionManager(BDdfTransactionMgr bDdfTransactionMgr) {
        this.set(transactionManager, (BValue)bDdfTransactionMgr, null);
    }

    public BDdfIpAddressPort getDestinationAddress() {
        return (BDdfIpAddressPort)this.get(destinationAddress);
    }

    public void setDestinationAddress(BDdfIpAddressPort bDdfIpAddressPort) {
        this.set(destinationAddress, (BValue)bDdfIpAddressPort, null);
    }

    public String getRapidEyeUserName() {
        return this.getString(rapidEyeUserName);
    }

    public void setRapidEyeUserName(String string) {
        this.setString(rapidEyeUserName, string, null);
    }

    public BPassword getRapidEyePassword() {
        return (BPassword)this.get(rapidEyePassword);
    }

    public void setRapidEyePassword(BPassword bPassword) {
        this.set(rapidEyePassword, (BValue)bPassword, null);
    }

    public Type getType() {
        return TYPE;
    }

    public native int InitializeCommunicator(int var1, String var2, boolean var3);

    public native int initializeCom();

    public native void uninitializeCom();

    public native void unInitializeCommunicator(int var1);

    public native String pingDvr(int var1);

    public native void StopAllStreaming(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int connectCommunicator() {
        if (this.connecting) {
            try {
                Thread.sleep(7000L);
                return this.connectionStatus;
            }
            catch (Exception exception) {}
            return this.connectionStatus;
        }
        Object object = connection;
        synchronized (object) {
            if (this.isConnected() && this.needToDisconnect) {
                this.unInitializeCommunicator(this.connectionStatus);
                this.needToDisconnect = false;
                this.connectionStatus = -1;
            }
            if (!this.isConnected() && this.shouldConnect()) {
                this.connecting = true;
                String string = "<streamDeviceConnectionParameters><address>";
                string = string + this.getHoneywellVideoIpAddress();
                string = string + "</address><username>";
                string = string + this.getRapidEyeUserName();
                string = string + "</username><password>";
                string = string + this.getRapidEyePassword().getString();
                string = string + "</password></streamDeviceConnectionParameters>";
                this.getLog().trace("Trying to connect to the communicator >>>> ");
                this.getLog().trace(string);
                this.getLog().trace(" --- <<<< ");
                this.connectionStatus = this.InitializeCommunicator(((BRapidEyeDvrId)this.getHoneywellDvr().getDeviceId()).getDvrId() - 1, string, this.getLog().isTraceOn());
                this.getLog().trace(" Connection Status " + this.connectionStatus);
                string = null;
                this.connecting = false;
                if (this.connectionStatus >= 0) return this.connectionStatus;
                ++this.failedConnectAttemptCount;
                this.lastfailedAttempt = BAbsTime.now();
                throw new BajaRuntimeException("Cannot connect to the dvr");
            }
            if (this.shouldConnect()) return this.connectionStatus;
            ++this.failedConnectAttemptCount;
            throw new BajaRuntimeException("Cannot Connect to dvr (" + this.failedConnectAttemptCount + ')');
        }
    }

    public boolean shouldConnect() {
        if (this.failedConnectAttemptCount < this.maxNumFailedAttempts) {
            return true;
        }
        return !this.lastfailedAttempt.isNull() && this.lastfailedAttempt.delta(BAbsTime.now()).getSeconds() > 300;
    }

    public void connectFirstTime() throws Exception {
        if (!this.connecting && this.getNetwork().loadDll() && this.connectCommunicator() < 0) {
            throw new BajaRuntimeException("Dll Not loaded / communication not yet initialized");
        }
    }

    public BRapidEyeNetwork getNetwork() {
        BComplex bComplex = this.getParent();
        while (!(bComplex instanceof BRapidEyeNetwork)) {
            bComplex = bComplex.getParent();
        }
        return (BRapidEyeNetwork)bComplex;
    }

    public synchronized void disconnectCommunicator() {
        this.needToDisconnect = true;
    }

    public synchronized void stopNativeCommunicator() {
        if (this.connectionStatus >= 0) {
            this.unInitializeCommunicator(this.connectionStatus);
            this.connectionStatus = -1;
        }
    }

    public void startCommunicating() {
        super.startCommunicating();
    }

    public void stopCommunicating() {
        if (this.getComponentSpace().isProxyComponentSpace()) {
            this.disconnectCommunicator();
        }
        super.stopCommunicating();
    }

    public synchronized String getNativeDeviceError(int n) {
        if (n >= 0) {
            return this.getHoneywellDvr().getDeviceError(this.connectionStatus, n);
        }
        return null;
    }

    public String getHoneywellVideoIpAddress() {
        return this.getDestinationAddress().getIpAddress();
    }

    public BRapidEyeCamera getCamera(int n) {
        BDdfCameraDeviceExt bDdfCameraDeviceExt = this.getHoneywellDvr().getCameras();
        Class clazz = class$com$tridium$rapidEye$BRapidEyeCamera;
        if (clazz == null) {
            clazz = class$com$tridium$rapidEye$BRapidEyeCamera = BRapidEyeCommunicator.class("[Lcom.tridium.rapidEye.BRapidEyeCamera;", false);
        }
        Object[] objectArray = bDdfCameraDeviceExt.getChildren(clazz);
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (((BRapidEyeCameraId)((BRapidEyeCamera)((Object)objectArray[n2])).getDeviceId()).getCameraId() == n) {
                return (BRapidEyeCamera)((Object)objectArray[n2]);
            }
            ++n2;
        }
        return null;
    }

    public BRapidEyeDvr getHoneywellDvr() {
        return (BRapidEyeDvr)this.getDdfCommunicatingParent();
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if ((property.equals((Object)destinationAddress) || property.equals((Object)rapidEyeUserName) || property.equals((Object)rapidEyePassword)) && context != Context.decoding) {
            log1.trace("Changed Parameters");
            this.getHoneywellDvr().doStopSessions();
            this.getHoneywellDvr().post(BRapidEyeDvr.ping, null, context);
            super.changed(property, context);
        }
    }

    public void communicate(BIDdfRequest bIDdfRequest) {
        if (bIDdfRequest instanceof BIRapidEyeTcpRequest) {
            log1.trace(":::  " + bIDdfRequest.getType().getTypeName() + "In Normal Socket");
            ((BIRapidEyeBasicTcpRequest)bIDdfRequest).setCommunicator(this.getTcpCommunicator());
            this.getTcpCommunicator().communicate(bIDdfRequest);
        } else if (bIDdfRequest instanceof BIRapidEyeLiveTcpRequest) {
            log1.trace("::: " + bIDdfRequest.getType().getTypeName() + "In Live Socket");
            ((BIRapidEyeBasicTcpRequest)bIDdfRequest).setCommunicator(this.getLiveTcpCommunicator());
            this.getLiveTcpCommunicator().communicate(bIDdfRequest);
        } else if (bIDdfRequest instanceof BIRapidEyeAlarmTcpRequest) {
            log1.trace("::: " + bIDdfRequest.getType().getTypeName() + "In Alarm Socket");
            ((BIRapidEyeBasicTcpRequest)bIDdfRequest).setCommunicator(this.getAlarmTcpCommunicator());
            this.getAlarmTcpCommunicator().communicate(bIDdfRequest);
        } else if (bIDdfRequest instanceof BIRapidEyeEventTcpRequest) {
            log1.trace("::: " + bIDdfRequest.getType().getTypeName() + "In Event Socket");
            ((BIRapidEyeBasicTcpRequest)bIDdfRequest).setCommunicator(this.getEventTcpCommunicator());
            this.getEventTcpCommunicator().communicate(bIDdfRequest);
        } else {
            super.communicate(bIDdfRequest);
        }
    }

    public void doCommunicate(BIDdfRequest bIDdfRequest) {
        if (bIDdfRequest instanceof BRapidEyeCameraStreamRequest) {
            try {
                this.getDdfTransmitter().forceTransmit(bIDdfRequest);
            }
            catch (Exception exception) {
                this.getLog().error(exception.getMessage());
            }
        } else {
            super.doCommunicate(bIDdfRequest);
        }
    }

    public boolean isConnected() {
        boolean bl = false;
        if (this.connectionStatus >= 0) {
            bl = true;
        }
        return bl;
    }

    public Log getLog() {
        if (this.getComponentSpace() != null && this.getComponentSpace().isProxyComponentSpace()) {
            return log2;
        }
        return log1;
    }

    public void loadClientSideSupport() {
        this.loadForClientRapidEyeComm((Object)this, "UnableToSyncProxySpace - communicator");
        this.getDdfTransactionMgr().getDdfCommunicator();
        this.getDdfTransmitter().getDdfCommunicator();
        this.getDdfReceiver().getDdfCommunicator();
        this.getUnsolicitedMgr().getDdfCommunicator();
        this.findCommunicatingParent();
    }

    void loadForClientRapidEyeComm(Object object, String string) {
        BComponentSpace bComponentSpace = this.getComponentSpace();
        if (bComponentSpace != null && bComponentSpace.isProxyComponentSpace() && object instanceof BComponent && (((BComponent)object).getParent() == null || !((BComponent)object).isSubscribed())) {
            BComponent bComponent = (BComponent)object;
            bComponent.lease(Integer.MAX_VALUE, Integer.MAX_VALUE);
            try {
                bComponent.getComponentSpace().sync();
            }
            catch (Exception exception) {
                this.getLog().error(string, (Throwable)exception);
            }
        }
    }

    private final void findCommunicatingParent() {
        BComplex bComplex = this.getParent();
        while (bComplex != null) {
            if (bComplex instanceof BIDdfCommunicating) {
                this.communicatingParent = (BIDdfCommunicating)bComplex;
                return;
            }
            bComplex = bComplex.getParent();
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.needToDisconnect = false;
        this.connectionStatus = -1;
        this.connecting = false;
        this.failedConnectAttemptCount = 0;
        this.maxNumFailedAttempts = 3;
    }

    public BRapidEyeCommunicator() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$rapidEye$comm$BRapidEyeCommunicator;
        if (clazz == null) {
            clazz = class$com$tridium$rapidEye$comm$BRapidEyeCommunicator = BRapidEyeCommunicator.class("[Lcom.tridium.rapidEye.comm.BRapidEyeCommunicator;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log1 = Log.getLog((String)"rapidEyeCommunicator.Log");
        log2 = Log.getLog((String)"videoWrapper.Log");
        connection = new Object();
    }
}

