/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rapidEye;

import com.tridium.rapidEye.BRapidEyeCamera;
import com.tridium.rapidEye.BRapidEyeNetwork;
import com.tridium.rapidEye.point.VideoNetReceiveFrame;
import com.tridium.rapidEye.point.VideoStream;
import com.tridium.videoDriver.ui.BIVideoPlayer;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import com.tridium.videoDriver.videoStream.IVideoSession;
import com.tridium.videoDriver.videoStream.WaitForStopDecoding;
import com.tridium.videoDriver.videoStream.decoder.VidFrame;
import com.tridium.videoDriver.videoStream.decoder.VideoDecoder;
import javax.baja.gx.BImage;
import javax.baja.log.Log;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.xml.XParser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RapidEyeDecoder
extends VideoDecoder {
    BImage blackImage;
    int invalidCount;
    protected boolean loopActive;
    protected int width;
    protected int height;
    ByteBuffer videoBuffer;
    protected VideoStream videoIn;
    protected Log log;
    public String showReason;
    int[] blackPixel;

    public void init(BIVideoSource bIVideoSource, BIVideoPlayer bIVideoPlayer, BRelTime bRelTime, IVideoSession iVideoSession) {
        super.init(bIVideoSource, bIVideoPlayer, bRelTime, iVideoSession);
    }

    public BRapidEyeNetwork getNetwork() {
        BComplex bComplex = ((BRapidEyeCamera)this.getVideoSource(this.videoSource)).getParent();
        while (!(bComplex instanceof BRapidEyeNetwork)) {
            bComplex = bComplex.getParent();
        }
        return (BRapidEyeNetwork)bComplex;
    }

    public void readFrameData(VidFrame vidFrame) throws Exception {
        this.videoBuffer.reset();
        vidFrame.rawData = this.videoBuffer;
        this.width = 640;
        this.height = 480;
        while (this.loopActive) {
            if (this.videoIn != null) {
                VideoNetReceiveFrame videoNetReceiveFrame = null;
                int n = this.videoIn.available();
                if (n > 0) {
                    if (n > 20) {
                        int n2 = this.videoIn.popPacketsFromQueue(n - 8);
                        if (n2 == 0) {
                            this.showReason = ",Try to restart the stream";
                            this.stopDecoding(null);
                        }
                        this.log.trace("Flushed out " + n2 + " packets, because of the delay");
                    }
                    if ((videoNetReceiveFrame = this.videoIn.getVideoPacket()) != null) {
                        if (videoNetReceiveFrame.getFrameBytes() == null) {
                            return;
                        }
                        this.videoBuffer.write(videoNetReceiveFrame.getFrameBytes());
                        this.width = videoNetReceiveFrame.width;
                        this.height = videoNetReceiveFrame.height;
                        vidFrame.timeIndex = BAbsTime.make((long)videoNetReceiveFrame.timest);
                        videoNetReceiveFrame = null;
                        this.getVideoPlayer().setMessage("");
                        Thread.sleep(30L);
                        this.invalidCount = 0;
                        videoNetReceiveFrame = null;
                        vidFrame.rawData = this.videoBuffer;
                    }
                    return;
                }
                try {
                    this.checkErrors(this.videoIn.theNativeCameraId);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {}
                    ++this.invalidCount;
                    if (this.invalidCount > 100) {
                        this.getVideoPlayer().setMessage("Delay in recieving packets");
                        if (this.invalidCount > 1500) {
                            this.getVideoPlayer().setMessage("Stream closed [ Dvr Not Reachable ]");
                            continue;
                        }
                    }
                }
                catch (Exception exception) {
                    this.getVideoPlayer().setMessage("[" + exception.getMessage() + ']');
                    ((BRapidEyeCamera)this.getVideoSource(this.videoSource)).getRapidEyeDvr().getHVideoNetCommunicator().disconnectCommunicator();
                    this.videoIn = null;
                }
                return;
            }
            Thread.sleep(30L);
            this.videoIn = (VideoStream)this.videoStream.getInputStream();
            return;
        }
    }

    public synchronized void checkErrors(int n) {
        String string = "";
        int n2 = 0;
        try {
            String string2 = ((BRapidEyeCamera)this.getVideoSource(this.videoSource)).getRapidEyeDvr().getHVideoNetCommunicator().getNativeDeviceError(n);
            if (string2 != null && string2 != "") {
                XParser xParser = XParser.make((String)string2);
                while (xParser.next() != -1) {
                    if (xParser.elem().name().trim().equals("IsRecoverable")) {
                        xParser.next();
                        Integer.parseInt(xParser.text().string().trim());
                        xParser.next();
                    }
                    if (xParser.elem().name().trim().equals("ErrorMsg")) {
                        xParser.next();
                        string = xParser.text().string().trim();
                        xParser.next();
                    }
                    if (!xParser.elem().name().trim().equals("ErrorCode")) continue;
                    xParser.next();
                    n2 = Integer.parseInt(xParser.text().string().trim());
                    xParser.next();
                }
            }
            string2 = null;
        }
        catch (Exception exception) {
            Object var5_5 = null;
            try {
                ((BRapidEyeCamera)this.getVideoSource(this.videoSource)).getRapidEyeDvr().getHVideoNetCommunicator().getLog().error(exception.getMessage());
            }
            catch (Exception exception2) {}
        }
        if (string != "" && this.getVideoPlayer() != null) {
            if (n2 == 13) {
                throw new BajaRuntimeException(string);
            }
            this.showReason = " " + string + " [" + n2 + ']';
            if (!this.requestToStop) {
                this.stopDecoding(null);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void decodeFrame(VidFrame vidFrame) throws Exception {
        ByteBuffer byteBuffer = vidFrame.rawData;
        BImage bImage = null;
        if (byteBuffer != null && byteBuffer.getLength() > 0) {
            try {
                block9: {
                    try {
                        if (this.width <= 0 || this.height <= 0) {
                            bImage = DISCONNECTED_IMAGE;
                            break block9;
                        }
                        int[] nArray = new int[this.height * this.width];
                        int n = 0;
                        while (true) {
                            if (n >= nArray.length) {
                                bImage = BImage.make((double)this.width, (double)this.height);
                                bImage.setPixels(nArray);
                                nArray = null;
                            }
                            nArray[n] = 0xFF000000 | (byteBuffer.read() | byteBuffer.read() << 8 | byteBuffer.read() << 16);
                            ++n;
                        }
                    }
                    catch (Exception exception) {
                        System.out.println("width :" + this.width + "height " + this.height);
                        exception.printStackTrace();
                        this.log.error(exception.getMessage());
                    }
                }
                Object var5_9 = null;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                byteBuffer.reset();
                throw throwable;
            }
            byteBuffer.reset();
        }
        vidFrame.image = bImage;
    }

    protected void closeStream() {
        super.closeStream();
        this.videoIn = null;
        if (this.getVideoPlayer() != null && this.showReason != "") {
            this.getVideoPlayer().setMessage(this.showReason);
        }
    }

    public synchronized void stopDecoding(WaitForStopDecoding waitForStopDecoding) {
        super.stopDecoding(waitForStopDecoding);
    }

    public boolean isStillBeingViewed() {
        if (!BRapidEyeNetwork.dllLoaded || !((BRapidEyeCamera)this.getVideoSource(this.videoSource)).getRapidEyeDvr().getHVideoNetCommunicator().isConnected()) {
            return false;
        }
        return super.isStillBeingViewed();
    }

    public BIVideoSource getVideoSource(BIVideoSource bIVideoSource) {
        return bIVideoSource;
    }

    private final /* synthetic */ void this() {
        this.blackImage = null;
        this.invalidCount = 0;
        this.loopActive = true;
        this.width = 0;
        this.height = 0;
        this.videoBuffer = new ByteBuffer();
        this.videoIn = null;
        this.log = Log.getLog((String)"videoDecoder.Log");
        this.showReason = "";
    }

    public RapidEyeDecoder() {
        this.this();
        int n = 307200;
        this.blackPixel = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.blackPixel[n2] = -872415232;
            ++n2;
        }
        this.blackImage = BImage.make((double)640.0, (double)480.0);
        this.blackImage.setPixels(this.blackPixel);
    }
}

