/*
 * Decompiled with CFR 0.152.
 */
package com.honeywell.rapidEyeObjects;

import com.honeywell.rapidEyeObjects.REAlarm;
import com.honeywell.rapidEyeObjects.REDateTime;
import com.honeywell.rapidEyeObjects.REEvent;
import com.honeywell.rapidEyeObjects.RESensor;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.baja.nre.util.IntHashMap;

public class RESensors {
    private IntHashMap sensors = new IntHashMap(60);

    public RESensor find_sensor(short s, short s2) throws IOException {
        Sensor sensor = (Sensor)this.sensors.get((int)s);
        if (sensor == null) {
            throw new IOException("sensor type not found");
        }
        for (int i = 0; i < this.sensors.size(); ++i) {
            Event event = (Event)sensor.events.get(i);
            if (s2 != event.id) continue;
            return new RESensor(sensor.name, sensor.label, event.name, s, s2, event.report);
        }
        throw new IOException("event type not found");
    }

    public REAlarm build_alarm(short s, short s2, REDateTime rEDateTime) throws IOException {
        Sensor sensor = (Sensor)this.sensors.get((int)s);
        if (sensor == null) {
            throw new IOException("sensor type not found");
        }
        for (int i = 0; i < this.sensors.size(); ++i) {
            Event event = (Event)sensor.events.get(i);
            if (s2 != event.id) continue;
            return new REAlarm(sensor.name, sensor.label, event.name, s, s2, rEDateTime);
        }
        throw new IOException("event type not found");
    }

    public REEvent build_event(short s, short s2, REDateTime rEDateTime) throws IOException {
        Sensor sensor = (Sensor)this.sensors.get((int)s);
        if (sensor == null) {
            throw new IOException("sensor type not found");
        }
        for (int i = 0; i < this.sensors.size(); ++i) {
            Event event = (Event)sensor.events.get(i);
            if (s2 != event.id) continue;
            return new REEvent(sensor.name, sensor.label, event.name, s, s2, rEDateTime);
        }
        throw new IOException("event type not found");
    }

    public void add_sensor(String string, String string2, short s, int n) {
        Sensor sensor = new Sensor(string, string2, s, n);
        this.sensors.put((int)s, (Object)sensor);
    }

    public void add_event(short s, String string, short s2, boolean bl, boolean bl2) {
        Sensor sensor = (Sensor)this.sensors.get((int)s);
        Event event = new Event(string, s2, bl, bl2);
        sensor.events.add(event);
    }

    public Iterator iterator() {
        return new REIterator();
    }

    static /* synthetic */ IntHashMap access$000(RESensors rESensors) {
        return rESensors.sensors;
    }

    public class REIterator
    implements Iterator {
        private int event_index = -1;
        private IntHashMap.Iterator itr = RESensors.access$000(RESensors.this).iterator();
        private Sensor sensor = (Sensor)this.itr.next();

        public boolean hasNext() {
            if (this.sensor == null) {
                return false;
            }
            if (this.event_index < this.sensor.events.size() - 1) {
                return true;
            }
            return this.itr.hasNext();
        }

        public Object next() {
            if (this.sensor == null) {
                throw new NoSuchElementException();
            }
            if (this.event_index < this.sensor.events.size() - 1) {
                ++this.event_index;
            } else if (this.itr.hasNext()) {
                this.sensor = (Sensor)this.itr.next();
                this.event_index = 0;
            } else {
                throw new NoSuchElementException();
            }
            Event event = (Event)this.sensor.events.get(this.event_index);
            return new RESensor(this.sensor.name, this.sensor.label, event.name, this.sensor.id, event.id, event.report);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class Sensor {
        String name;
        String label;
        short id;
        Vector events;

        Sensor(String string, String string2, short s, int n) {
            this.name = string;
            this.label = string2;
            this.id = s;
            this.events = new Vector(n);
        }
    }

    private class Event {
        String name;
        short id;
        boolean record;
        boolean report;

        Event(String string, short s, boolean bl, boolean bl2) {
            this.name = string;
            this.id = s;
            this.record = bl;
            this.report = bl2;
        }
    }
}

