/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.value;

import net.percederberg.mibble.FileLocation;
import net.percederberg.mibble.MibContext;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.value.ObjectIdentifierValue;

public class ValueReference
extends MibValue {
    private FileLocation location;
    private MibContext context;
    private String name;

    public ValueReference(FileLocation fileLocation, MibContext mibContext, String string) {
        super("ReferenceToValue(" + string + ")");
        this.location = fileLocation;
        this.context = mibContext;
        this.name = string;
    }

    public MibValue initialize(MibLoaderLog mibLoaderLog, MibType mibType) throws MibException {
        MibSymbol mibSymbol = this.getSymbol(mibLoaderLog);
        if (mibSymbol instanceof MibValueSymbol) {
            MibValue mibValue = ((MibValueSymbol)mibSymbol).getValue();
            if (mibValue != null) {
                mibValue = mibValue.initialize(mibLoaderLog, mibType);
            }
            if (mibValue == null) {
                return null;
            }
            try {
                mibValue = mibValue.createReference();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                throw new MibException(this.location, unsupportedOperationException.getMessage());
            }
            if (!(mibValue instanceof ObjectIdentifierValue)) {
                mibValue.setReferenceSymbol((MibValueSymbol)mibSymbol);
            }
            return mibValue;
        }
        if (mibSymbol == null) {
            String string = "undefined symbol '" + this.name + "'";
            throw new MibException(this.location, string);
        }
        String string = "referenced symbol '" + this.name + "' is not a value";
        throw new MibException(this.location, string);
    }

    public FileLocation getLocation() {
        return this.location;
    }

    public MibSymbol getSymbol() {
        return this.getSymbol(null);
    }

    private MibSymbol getSymbol(MibLoaderLog mibLoaderLog) {
        MibSymbol mibSymbol = this.context.findSymbol(this.name, false);
        if (mibSymbol == null && (mibSymbol = this.context.findSymbol(this.name, true)) != null && mibLoaderLog != null) {
            String string = "missing import for '" + this.name + "', using " + "definition from " + mibSymbol.getMib().getName();
            mibLoaderLog.addWarning(this.location, string);
        }
        return mibSymbol;
    }

    public int compareTo(Object object) {
        return this.toString().compareTo(object.toString());
    }

    public boolean equals(Object object) {
        return this.toString().equals(object.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public Object toObject() {
        return null;
    }

    public String toString() {
        return "ReferenceToValue(" + this.name + ")";
    }
}

