/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.type.Constraint;
import net.percederberg.mibble.type.SizeConstraint;
import net.percederberg.mibble.type.StringType;

public class NumberValue
extends MibValue {
    private Number value;

    public NumberValue(Number number) {
        super("Number");
        this.value = number;
    }

    public MibValue initialize(MibLoaderLog mibLoaderLog, MibType mibType) {
        return this;
    }

    public MibValue createReference() {
        return new NumberValue(this.value);
    }

    public int compareTo(Object object) {
        if (object instanceof NumberValue) {
            return this.compareToNumber(((NumberValue)object).value);
        }
        if (object instanceof Number) {
            return this.compareToNumber((Number)object);
        }
        return this.toString().compareTo(object.toString());
    }

    private int compareToNumber(Number number) {
        if (this.value instanceof Integer && number instanceof Integer) {
            return ((Integer)this.value).compareTo((Integer)number);
        }
        if (this.value instanceof Long && number instanceof Long) {
            return ((Long)this.value).compareTo((Long)number);
        }
        if (this.value instanceof BigInteger && number instanceof BigInteger) {
            return ((BigInteger)this.value).compareTo((BigInteger)number);
        }
        BigDecimal bigDecimal = new BigDecimal(this.value.toString());
        BigDecimal bigDecimal2 = new BigDecimal(number.toString());
        return bigDecimal.compareTo(bigDecimal2);
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public Object toObject() {
        return this.value;
    }

    public String toString() {
        return this.value.toString();
    }

    protected int getByteSize(MibType mibType, int n) {
        Constraint constraint = null;
        int n2 = -1;
        if (mibType instanceof StringType) {
            constraint = ((StringType)mibType).getConstraint();
        }
        if (constraint instanceof SizeConstraint) {
            n2 = ((SizeConstraint)constraint).nextValue(n);
        }
        if (n2 < 0) {
            n2 = 1;
        }
        return n2;
    }
}

