/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.value;

import java.math.BigInteger;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.value.NumberValue;

public class HexNumberValue
extends NumberValue {
    private int minLength;

    public HexNumberValue(Number number) {
        this(number, 1);
    }

    public HexNumberValue(Number number, int n) {
        super(number);
        this.minLength = n;
    }

    public MibValue initialize(MibLoaderLog mibLoaderLog, MibType mibType) {
        int n = this.minLength / 2 + (this.minLength % 2 > 0 ? 1 : 0);
        int n2 = this.getByteSize(mibType, n) * 2;
        if (n2 > this.minLength) {
            this.minLength = n2;
        }
        return this;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("'");
        String string = this.toHexString();
        if (string.equals("0")) {
            string = "";
        }
        for (int i = string.length(); i < this.minLength; ++i) {
            stringBuffer.append("0");
        }
        stringBuffer.append(string);
        stringBuffer.append("'H");
        return stringBuffer.toString();
    }

    private String toHexString() {
        Number number = (Number)this.toObject();
        if (number instanceof BigInteger) {
            return ((BigInteger)number).toString(16).toUpperCase();
        }
        if (number instanceof Long) {
            return Long.toHexString(number.longValue()).toUpperCase();
        }
        return Integer.toHexString(number.intValue()).toUpperCase();
    }
}

