/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.type;

import java.math.BigInteger;
import net.percederberg.mibble.FileLocation;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.type.Constraint;
import net.percederberg.mibble.value.NumberValue;
import net.percederberg.mibble.value.StringValue;

public class ValueRangeConstraint
implements Constraint {
    private FileLocation location;
    private MibValue lower;
    private MibValue upper;
    private boolean strictLower;
    private boolean strictUpper;

    public ValueRangeConstraint(FileLocation fileLocation, MibValue mibValue, boolean bl, MibValue mibValue2, boolean bl2) {
        this.location = fileLocation;
        this.lower = mibValue;
        this.upper = mibValue2;
        this.strictLower = bl;
        this.strictUpper = bl2;
    }

    public void initialize(MibType mibType, MibLoaderLog mibLoaderLog) throws MibException {
        if (this.lower != null) {
            this.lower = this.lower.initialize(mibLoaderLog, mibType);
        }
        if (this.upper != null) {
            this.upper = this.upper.initialize(mibLoaderLog, mibType);
        }
        if (this.location != null && !this.isCompatible(mibType)) {
            String string = "Value range constraint not compatible with this type";
            mibLoaderLog.addWarning(this.location, string);
        }
        this.location = null;
    }

    public boolean isCompatible(MibType mibType) {
        return !(mibType != null && this.lower != null && !mibType.isCompatible(this.lower) || mibType != null && this.upper != null && !mibType.isCompatible(this.upper));
    }

    public boolean isCompatible(MibValue mibValue) {
        return !(this.lower != null && !this.isLessThan(this.strictLower, this.lower, mibValue) || this.upper != null && !this.isLessThan(this.strictUpper, mibValue, this.upper));
    }

    public boolean isCompatible(Number number) {
        Number number2 = null;
        Number number3 = null;
        if (this.lower instanceof NumberValue) {
            number2 = (Number)this.lower.toObject();
        }
        if (this.upper instanceof NumberValue) {
            number3 = (Number)this.upper.toObject();
        }
        return !(number2 != null && !this.isLessThan(this.strictLower, number2, number) || number3 != null && !this.isLessThan(this.strictUpper, number, number3));
    }

    private boolean isLessThan(boolean bl, MibValue mibValue, MibValue mibValue2) {
        if (mibValue instanceof NumberValue && mibValue2 instanceof NumberValue) {
            return this.isLessThan(bl, (Number)mibValue.toObject(), (Number)mibValue2.toObject());
        }
        if (mibValue instanceof StringValue && mibValue2 instanceof StringValue) {
            return this.isLessThan(bl, (String)mibValue.toObject(), (String)mibValue2.toObject());
        }
        return false;
    }

    private boolean isLessThan(boolean bl, Number number, Number number2) {
        if (number instanceof Float) {
            return number.floatValue() == Float.NEGATIVE_INFINITY;
        }
        if (number2 instanceof Float) {
            return number.floatValue() == Float.POSITIVE_INFINITY;
        }
        return this.isLessThan(bl, new BigInteger(number.toString()), new BigInteger(number2.toString()));
    }

    private boolean isLessThan(boolean bl, BigInteger bigInteger, BigInteger bigInteger2) {
        if (bl) {
            return bigInteger.compareTo(bigInteger2) < 0;
        }
        return bigInteger.compareTo(bigInteger2) <= 0;
    }

    private boolean isLessThan(boolean bl, String string, String string2) {
        if (bl) {
            return string.compareTo(string2) < 0;
        }
        return string.compareTo(string2) <= 0;
    }

    public MibValue getLowerBound() {
        return this.lower;
    }

    public MibValue getUpperBound() {
        return this.upper;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.lower == null) {
            stringBuffer.append("MIN");
        } else {
            stringBuffer.append(this.lower);
        }
        if (this.strictLower) {
            stringBuffer.append("<");
        }
        stringBuffer.append("..");
        if (this.strictUpper) {
            stringBuffer.append("<");
        }
        if (this.upper == null) {
            stringBuffer.append("MAX");
        } else {
            stringBuffer.append(this.upper);
        }
        return stringBuffer.toString();
    }
}

