/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.type;

import net.percederberg.mibble.FileLocation;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.type.Constraint;
import net.percederberg.mibble.value.NumberValue;
import net.percederberg.mibble.value.StringValue;

public class ValueConstraint
implements Constraint {
    private FileLocation location;
    private MibValue value;

    public ValueConstraint(FileLocation fileLocation, MibValue mibValue) {
        this.location = fileLocation;
        this.value = mibValue;
    }

    public void initialize(MibType mibType, MibLoaderLog mibLoaderLog) throws MibException {
        this.value = this.value.initialize(mibLoaderLog, mibType);
        if (this.location != null && !this.isCompatible(mibType)) {
            String string = "Value constraint not compatible with this type";
            mibLoaderLog.addWarning(this.location, string);
        }
        this.location = null;
    }

    public boolean isCompatible(MibType mibType) {
        return mibType == null || this.value == null || mibType.isCompatible(this.value);
    }

    public boolean isCompatible(MibValue mibValue) {
        String string = this.value.toString();
        String string2 = mibValue.toString();
        if (this.value instanceof NumberValue && mibValue instanceof NumberValue) {
            return string.equals(string2);
        }
        if (this.value instanceof StringValue && mibValue instanceof StringValue) {
            return string.equals(string2);
        }
        return false;
    }

    public MibValue getValue() {
        return this.value;
    }

    public String toString() {
        return this.value.toString();
    }
}

