/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.type;

import java.util.ArrayList;
import net.percederberg.mibble.FileLocation;
import net.percederberg.mibble.MibContext;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibTypeSymbol;
import net.percederberg.mibble.MibTypeTag;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.type.Constraint;

public class TypeReference
extends MibType
implements MibContext {
    private FileLocation location;
    private MibContext context;
    private String name;
    private MibType type = null;
    private Constraint constraint = null;
    private ArrayList values = null;
    private MibTypeTag tag = null;
    private boolean implicitTag = true;

    public TypeReference(FileLocation fileLocation, MibContext mibContext, String string) {
        super("ReferenceToType(" + string + ")", false);
        this.location = fileLocation;
        this.context = mibContext;
        this.name = string;
    }

    public TypeReference(FileLocation fileLocation, MibContext mibContext, String string, Constraint constraint) {
        this(fileLocation, mibContext, string);
        this.constraint = constraint;
    }

    public TypeReference(FileLocation fileLocation, MibContext mibContext, String string, ArrayList arrayList) {
        this(fileLocation, mibContext, string);
        this.values = arrayList;
    }

    public MibType initialize(MibSymbol mibSymbol, MibLoaderLog mibLoaderLog) throws MibException {
        MibSymbol mibSymbol2 = this.getSymbol(mibLoaderLog);
        if (mibSymbol2 instanceof MibTypeSymbol) {
            this.type = this.initializeReference(mibSymbol, mibLoaderLog, (MibTypeSymbol)mibSymbol2);
            if (this.type == null) {
                String string = "referenced symbol '" + mibSymbol2.getName() + "' contains undefined type";
                throw new MibException(this.location, string);
            }
            return this.type;
        }
        if (mibSymbol2 == null) {
            String string = "undefined symbol '" + this.name + "'";
            throw new MibException(this.location, string);
        }
        String string = "referenced symbol '" + this.name + "' is not a type";
        throw new MibException(this.location, string);
    }

    private MibType initializeReference(MibSymbol mibSymbol, MibLoaderLog mibLoaderLog, MibTypeSymbol mibTypeSymbol) throws MibException {
        MibType mibType = mibTypeSymbol.getType();
        if (mibType != null) {
            mibType = mibType.initialize(mibSymbol, mibLoaderLog);
        }
        if (mibType == null) {
            return null;
        }
        try {
            mibType = this.constraint != null ? mibType.createReference(this.constraint) : (this.values != null ? mibType.createReference(this.values) : mibType.createReference());
            mibType = mibType.initialize(mibSymbol, mibLoaderLog);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new MibException(this.location, unsupportedOperationException.getMessage());
        }
        mibType.setReferenceSymbol(mibTypeSymbol);
        this.initializeTypeTag(mibType, this.tag);
        return mibType;
    }

    private void initializeTypeTag(MibType mibType, MibTypeTag mibTypeTag) {
        if (mibTypeTag != null) {
            if (mibTypeTag.getNext() == null) {
                mibType.setTag(this.implicitTag, mibTypeTag);
            } else {
                this.initializeTypeTag(mibType, mibTypeTag.getNext());
                mibType.setTag(false, mibTypeTag);
            }
        }
    }

    public FileLocation getLocation() {
        return this.location;
    }

    public MibSymbol getSymbol() {
        return this.getSymbol(null);
    }

    private MibSymbol getSymbol(MibLoaderLog mibLoaderLog) {
        MibSymbol mibSymbol = this.context.findSymbol(this.name, false);
        if (mibSymbol == null && (mibSymbol = this.context.findSymbol(this.name, true)) != null && mibLoaderLog != null) {
            String string = "missing import for '" + this.name + "', using " + "definition from " + mibSymbol.getMib().getName();
            mibLoaderLog.addWarning(this.location, string);
        }
        return mibSymbol;
    }

    public boolean isCompatible(MibValue mibValue) {
        return false;
    }

    public MibSymbol findSymbol(String string, boolean bl) {
        if (this.type instanceof MibContext) {
            return ((MibContext)((Object)this.type)).findSymbol(string, bl);
        }
        return null;
    }

    public void setTag(boolean bl, MibTypeTag mibTypeTag) {
        if (this.tag == null) {
            this.tag = mibTypeTag;
            this.implicitTag = bl;
        } else if (bl) {
            mibTypeTag.setNext(this.tag.getNext());
            this.tag = mibTypeTag;
        } else {
            mibTypeTag.setNext(this.tag);
            this.tag = mibTypeTag;
        }
    }
}

