/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.type;

import java.util.ArrayList;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibTypeTag;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.type.ElementType;

public class SequenceType
extends MibType {
    private ArrayList elements;

    public SequenceType(ArrayList arrayList) {
        this(true, arrayList);
    }

    private SequenceType(boolean bl, ArrayList arrayList) {
        super("SEQUENCE", bl);
        this.elements = arrayList;
        this.setTag(true, MibTypeTag.SEQUENCE);
    }

    public MibType initialize(MibSymbol mibSymbol, MibLoaderLog mibLoaderLog) throws MibException {
        for (int i = 0; i < this.elements.size(); ++i) {
            ElementType elementType = (ElementType)this.elements.get(i);
            elementType.initialize(mibSymbol, mibLoaderLog);
        }
        return this;
    }

    public MibType createReference() {
        SequenceType sequenceType = new SequenceType(false, this.elements);
        sequenceType.setTag(true, this.getTag());
        return sequenceType;
    }

    public boolean isCompatible(MibValue mibValue) {
        return false;
    }

    public ElementType[] getAllElements() {
        ElementType[] elementTypeArray = new ElementType[this.elements.size()];
        this.elements.toArray(elementTypeArray);
        return elementTypeArray;
    }

    public String toString() {
        return super.toString() + " " + this.elements.toString();
    }
}

