/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.type;

import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibTypeTag;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.type.Constraint;

public class SequenceOfType
extends MibType {
    private MibType base;
    private Constraint constraint = null;

    public SequenceOfType(MibType mibType) {
        this(true, mibType, null);
    }

    public SequenceOfType(MibType mibType, Constraint constraint) {
        this(true, mibType, constraint);
    }

    private SequenceOfType(boolean bl, MibType mibType, Constraint constraint) {
        super("SEQUENCE", bl);
        this.base = mibType;
        this.constraint = constraint;
        this.setTag(true, MibTypeTag.SEQUENCE);
    }

    public MibType initialize(MibSymbol mibSymbol, MibLoaderLog mibLoaderLog) throws MibException {
        this.base = this.base.initialize(mibSymbol, mibLoaderLog);
        if (this.base != null && this.constraint != null) {
            this.constraint.initialize(this, mibLoaderLog);
        }
        return this;
    }

    public MibType createReference() {
        SequenceOfType sequenceOfType = new SequenceOfType(false, this.base, this.constraint);
        sequenceOfType.setTag(true, this.getTag());
        return sequenceOfType;
    }

    public MibType createReference(Constraint constraint) {
        SequenceOfType sequenceOfType = new SequenceOfType(false, this.base, constraint);
        sequenceOfType.setTag(true, this.getTag());
        return sequenceOfType;
    }

    public boolean hasConstraint() {
        return this.constraint != null;
    }

    public boolean isCompatible(MibValue mibValue) {
        return false;
    }

    public Constraint getConstraint() {
        return this.constraint;
    }

    public MibType getElementType() {
        return this.base;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(" ");
        if (this.constraint != null) {
            stringBuffer.append("(");
            stringBuffer.append(this.constraint.toString());
            stringBuffer.append(") ");
        }
        stringBuffer.append("OF ");
        stringBuffer.append(this.base);
        return stringBuffer.toString();
    }
}

