/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.type;

import java.util.ArrayList;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.type.Constraint;

public class CompoundConstraint
implements Constraint {
    private Constraint first;
    private Constraint second;

    public CompoundConstraint(Constraint constraint, Constraint constraint2) {
        this.first = constraint;
        this.second = constraint2;
    }

    public void initialize(MibType mibType, MibLoaderLog mibLoaderLog) throws MibException {
        this.first.initialize(mibType, mibLoaderLog);
        this.second.initialize(mibType, mibLoaderLog);
    }

    public boolean isCompatible(MibType mibType) {
        return this.first.isCompatible(mibType) && this.second.isCompatible(mibType);
    }

    public boolean isCompatible(MibValue mibValue) {
        return this.first.isCompatible(mibValue) || this.second.isCompatible(mibValue);
    }

    public ArrayList getConstraintList() {
        ArrayList<Constraint> arrayList = new ArrayList<Constraint>();
        if (this.first instanceof CompoundConstraint) {
            arrayList.addAll(((CompoundConstraint)this.first).getConstraintList());
        } else {
            arrayList.add(this.first);
        }
        if (this.second instanceof CompoundConstraint) {
            arrayList.addAll(((CompoundConstraint)this.second).getConstraintList());
        } else {
            arrayList.add(this.second);
        }
        return arrayList;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.first.toString());
        stringBuffer.append(" | ");
        stringBuffer.append(this.second.toString());
        return stringBuffer.toString();
    }
}

