/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.type;

import java.util.ArrayList;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.type.ElementType;

public class ChoiceType
extends MibType {
    private ArrayList elements;

    public ChoiceType(ArrayList arrayList) {
        this(true, arrayList);
    }

    private ChoiceType(boolean bl, ArrayList arrayList) {
        super("CHOICE", bl);
        this.elements = arrayList;
    }

    public MibType initialize(MibSymbol mibSymbol, MibLoaderLog mibLoaderLog) throws MibException {
        for (int i = 0; i < this.elements.size(); ++i) {
            ElementType elementType = (ElementType)this.elements.get(i);
            elementType.initialize(mibSymbol, mibLoaderLog);
        }
        return this;
    }

    public MibType createReference() {
        ChoiceType choiceType = new ChoiceType(false, this.elements);
        choiceType.setTag(true, this.getTag());
        return choiceType;
    }

    public boolean isCompatible(MibValue mibValue) {
        for (int i = 0; i < this.elements.size(); ++i) {
            ElementType elementType = (ElementType)this.elements.get(i);
            if (!elementType.isCompatible(mibValue)) continue;
            return true;
        }
        return false;
    }

    public ElementType[] getAllElements() {
        ElementType[] elementTypeArray = new ElementType[this.elements.size()];
        this.elements.toArray(elementTypeArray);
        return elementTypeArray;
    }

    public String toString() {
        return super.toString() + " " + this.elements.toString();
    }
}

