/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.snmp;

import java.util.ArrayList;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.snmp.SnmpType;
import net.percederberg.mibble.value.NumberValue;

public class SnmpTrapType
extends SnmpType {
    private MibValue enterprise;
    private ArrayList variables;
    private String reference;

    public SnmpTrapType(MibValue mibValue, ArrayList arrayList, String string, String string2) {
        super("TRAP-TYPE", string);
        this.enterprise = mibValue;
        this.variables = arrayList;
        this.reference = string2;
    }

    public MibType initialize(MibSymbol mibSymbol, MibLoaderLog mibLoaderLog) throws MibException {
        ArrayList<MibValue> arrayList = new ArrayList<MibValue>();
        if (!(mibSymbol instanceof MibValueSymbol)) {
            throw new MibException(mibSymbol.getLocation(), "only values can have the " + this.getName() + " type");
        }
        this.enterprise = this.enterprise.initialize(mibLoaderLog, null);
        for (int i = 0; i < this.variables.size(); ++i) {
            arrayList.add(((MibValue)this.variables.get(i)).initialize(mibLoaderLog, null));
        }
        this.variables = arrayList;
        return this;
    }

    public boolean isCompatible(MibValue mibValue) {
        return mibValue instanceof NumberValue && !(mibValue.toObject() instanceof Float);
    }

    public MibValue getEnterprise() {
        return this.enterprise;
    }

    public ArrayList getVariables() {
        return this.variables;
    }

    public String getReference() {
        return this.reference;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(" (");
        stringBuffer.append("\n  Enterprise: ");
        stringBuffer.append(this.enterprise);
        stringBuffer.append("\n  Variables: ");
        stringBuffer.append(this.variables);
        if (this.getUnformattedDescription() != null) {
            stringBuffer.append("\n  Description: ");
            stringBuffer.append(this.getDescription("               "));
        }
        if (this.reference != null) {
            stringBuffer.append("\n  Reference: ");
            stringBuffer.append(this.reference);
        }
        stringBuffer.append("\n)");
        return stringBuffer.toString();
    }
}

