/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.snmp;

import java.util.ArrayList;
import net.percederberg.mibble.MibContext;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibTypeSymbol;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.snmp.SnmpObjectType;
import net.percederberg.mibble.snmp.SnmpStatus;
import net.percederberg.mibble.snmp.SnmpType;
import net.percederberg.mibble.type.Constraint;

public class SnmpTextualConvention
extends SnmpType
implements MibContext {
    private String displayHint;
    private SnmpStatus status;
    private String reference;
    private MibType syntax;

    public static SnmpTextualConvention findReference(MibType mibType) {
        if (mibType instanceof SnmpObjectType) {
            mibType = ((SnmpObjectType)mibType).getSyntax();
        }
        if (mibType instanceof SnmpTextualConvention) {
            return (SnmpTextualConvention)mibType;
        }
        MibTypeSymbol mibTypeSymbol = mibType.getReferenceSymbol();
        return mibTypeSymbol == null ? null : SnmpTextualConvention.findReference(mibTypeSymbol.getType());
    }

    public SnmpTextualConvention(String string, SnmpStatus snmpStatus, String string2, String string3, MibType mibType) {
        super("TEXTUAL-CONVENTION", string2);
        this.displayHint = string;
        this.status = snmpStatus;
        this.reference = string3;
        this.syntax = mibType;
    }

    public MibType initialize(MibSymbol mibSymbol, MibLoaderLog mibLoaderLog) throws MibException {
        this.syntax = this.syntax.initialize(mibSymbol, mibLoaderLog);
        return this;
    }

    public MibType createReference() throws UnsupportedOperationException {
        return this.syntax.createReference();
    }

    public MibType createReference(Constraint constraint) throws UnsupportedOperationException {
        return this.syntax.createReference(constraint);
    }

    public MibType createReference(ArrayList arrayList) throws UnsupportedOperationException {
        return this.syntax.createReference(arrayList);
    }

    public boolean isCompatible(MibValue mibValue) {
        return false;
    }

    public String getDisplayHint() {
        return this.displayHint;
    }

    public SnmpStatus getStatus() {
        return this.status;
    }

    public String getReference() {
        return this.reference;
    }

    public MibType getSyntax() {
        return this.syntax;
    }

    public MibSymbol findSymbol(String string, boolean bl) {
        if (this.syntax instanceof MibContext) {
            return ((MibContext)((Object)this.syntax)).findSymbol(string, bl);
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(" (");
        if (this.displayHint != null) {
            stringBuffer.append("\n  Display-Hint: ");
            stringBuffer.append(this.displayHint);
        }
        stringBuffer.append("\n  Status: ");
        stringBuffer.append(this.status);
        stringBuffer.append("\n  Description: ");
        stringBuffer.append(this.getDescription("               "));
        if (this.reference != null) {
            stringBuffer.append("\n  Reference: ");
            stringBuffer.append(this.reference);
        }
        stringBuffer.append("\n  Syntax: ");
        stringBuffer.append(this.syntax);
        stringBuffer.append("\n)");
        return stringBuffer.toString();
    }
}

