/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.snmp;

import java.util.ArrayList;
import net.percederberg.mibble.FileLocation;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibTypeSymbol;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.snmp.SnmpAccess;
import net.percederberg.mibble.snmp.SnmpIndex;
import net.percederberg.mibble.snmp.SnmpStatus;
import net.percederberg.mibble.snmp.SnmpType;
import net.percederberg.mibble.type.ElementType;
import net.percederberg.mibble.type.SequenceOfType;
import net.percederberg.mibble.type.SequenceType;
import net.percederberg.mibble.value.ObjectIdentifierValue;
import net.percederberg.mibble.value.ValueReference;

public class SnmpObjectType
extends SnmpType {
    private MibType syntax;
    private String units;
    private SnmpAccess access;
    private SnmpStatus status;
    private String reference;
    private ArrayList index;
    private MibValue augments;
    private MibValue defaultValue;

    public SnmpObjectType(MibType mibType, String string, SnmpAccess snmpAccess, SnmpStatus snmpStatus, String string2, String string3, ArrayList arrayList, MibValue mibValue) {
        super("OBJECT-TYPE", string2);
        this.syntax = mibType;
        this.units = string;
        this.access = snmpAccess;
        this.status = snmpStatus;
        this.reference = string3;
        this.index = arrayList;
        this.augments = null;
        this.defaultValue = mibValue;
    }

    public SnmpObjectType(MibType mibType, String string, SnmpAccess snmpAccess, SnmpStatus snmpStatus, String string2, String string3, MibValue mibValue, MibValue mibValue2) {
        super("OBJECT-TYPE", string2);
        this.syntax = mibType;
        this.units = string;
        this.access = snmpAccess;
        this.status = snmpStatus;
        this.reference = string3;
        this.index = new ArrayList();
        this.augments = mibValue;
        this.defaultValue = mibValue2;
    }

    public MibType initialize(MibSymbol mibSymbol, MibLoaderLog mibLoaderLog) throws MibException {
        if (!(mibSymbol instanceof MibValueSymbol)) {
            throw new MibException(mibSymbol.getLocation(), "only values can have the " + this.getName() + " type");
        }
        this.syntax = this.syntax.initialize(mibSymbol, mibLoaderLog);
        this.checkType((MibValueSymbol)mibSymbol, mibLoaderLog, this.syntax);
        for (int i = 0; i < this.index.size(); ++i) {
            ((SnmpIndex)this.index.get(i)).initialize(mibSymbol, mibLoaderLog);
        }
        if (this.augments != null) {
            this.augments = this.augments.initialize(mibLoaderLog, this.syntax);
        }
        if (this.defaultValue != null) {
            try {
                this.defaultValue = this.defaultValue.initialize(mibLoaderLog, this.syntax);
            }
            catch (MibException mibException) {
                FileLocation fileLocation = this.defaultValue instanceof ValueReference ? ((ValueReference)this.defaultValue).getLocation() : null;
                mibLoaderLog.addWarning(fileLocation, "invalid defaultValue");
            }
        }
        return this;
    }

    private void checkType(MibValueSymbol mibValueSymbol, MibLoaderLog mibLoaderLog, MibType mibType) throws MibException {
        if (mibType instanceof SequenceOfType) {
            SequenceOfType sequenceOfType = (SequenceOfType)mibType;
            this.checkType(mibValueSymbol, mibLoaderLog, sequenceOfType.getElementType());
        } else if (mibType instanceof SequenceType) {
            ElementType[] elementTypeArray = ((SequenceType)mibType).getAllElements();
            for (int i = 0; i < elementTypeArray.length; ++i) {
                this.checkElement(mibValueSymbol, mibLoaderLog, elementTypeArray[i], i + 1);
            }
        }
    }

    private void checkElement(MibValueSymbol mibValueSymbol, MibLoaderLog mibLoaderLog, ElementType elementType, int n) throws MibException {
        Mib mib = mibValueSymbol.getMib();
        MibSymbol mibSymbol = mib.getSymbol(elementType.getName());
        if (mibSymbol == null) {
            String string = elementType.getName() != null ? n + " '" + elementType.getName() + "'" : String.valueOf(n);
            mibLoaderLog.addWarning(mibValueSymbol.getLocation(), "sequence element " + string + " is undefined " + "in MIB, a default symbol will be created");
            string = elementType.getName();
            if (string == null) {
                string = mibValueSymbol.getName() + "." + n;
            }
            SnmpObjectType snmpObjectType = new SnmpObjectType(elementType.getType(), null, SnmpAccess.READ_ONLY, SnmpStatus.CURRENT, "AUTOMATICALLY CREATED SYMBOL", null, new ArrayList(), null);
            ObjectIdentifierValue objectIdentifierValue = (ObjectIdentifierValue)mibValueSymbol.getValue();
            objectIdentifierValue = new ObjectIdentifierValue(mibValueSymbol.getLocation(), objectIdentifierValue, elementType.getName(), n);
            mibSymbol = new MibValueSymbol(mibValueSymbol.getLocation(), mib, string, snmpObjectType, objectIdentifierValue);
            mibSymbol.initialize(mibLoaderLog);
        } else if (mibSymbol instanceof MibTypeSymbol) {
            String string = elementType.getName() != null ? n + " '" + elementType.getName() + "'" : String.valueOf(n);
            throw new MibException(mibValueSymbol.getLocation(), "sequence element " + string + " does not refer to a value, but " + "to a type");
        }
    }

    public boolean isCompatible(MibValue mibValue) {
        return mibValue instanceof ObjectIdentifierValue;
    }

    public MibType getSyntax() {
        return this.syntax;
    }

    public String getUnits() {
        return this.units;
    }

    public SnmpAccess getAccess() {
        return this.access;
    }

    public SnmpStatus getStatus() {
        return this.status;
    }

    public String getReference() {
        return this.reference;
    }

    public ArrayList getIndex() {
        return this.index;
    }

    public MibValue getAugments() {
        return this.augments;
    }

    public MibValue getDefaultValue() {
        return this.defaultValue;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(" (");
        stringBuffer.append("\n  Syntax: ");
        stringBuffer.append(this.syntax);
        if (this.units != null) {
            stringBuffer.append("\n  Units: ");
            stringBuffer.append(this.units);
        }
        stringBuffer.append("\n  Access: ");
        stringBuffer.append(this.access);
        stringBuffer.append("\n  Status: ");
        stringBuffer.append(this.status);
        if (this.getUnformattedDescription() != null) {
            stringBuffer.append("\n  Description: ");
            stringBuffer.append(this.getDescription("               "));
        }
        if (this.reference != null) {
            stringBuffer.append("\n  Reference: ");
            stringBuffer.append(this.reference);
        }
        if (this.index.size() > 0) {
            stringBuffer.append("\n  Index: ");
            stringBuffer.append(this.index);
        }
        if (this.augments != null) {
            stringBuffer.append("\n  Augments: ");
            stringBuffer.append(this.augments);
        }
        if (this.defaultValue != null) {
            stringBuffer.append("\n  Default Value: ");
            stringBuffer.append(this.defaultValue);
        }
        stringBuffer.append("\n)");
        return stringBuffer.toString();
    }
}

