/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.snmp;

import java.util.ArrayList;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.snmp.SnmpStatus;
import net.percederberg.mibble.snmp.SnmpType;
import net.percederberg.mibble.value.ObjectIdentifierValue;

public class SnmpNotificationType
extends SnmpType {
    private ArrayList objects;
    private SnmpStatus status;
    private String reference;

    public SnmpNotificationType(ArrayList arrayList, SnmpStatus snmpStatus, String string, String string2) {
        super("NOTIFICATION-TYPE", string);
        this.objects = arrayList;
        this.status = snmpStatus;
        this.reference = string2;
    }

    public MibType initialize(MibSymbol mibSymbol, MibLoaderLog mibLoaderLog) throws MibException {
        ArrayList<MibValue> arrayList = new ArrayList<MibValue>();
        if (!(mibSymbol instanceof MibValueSymbol)) {
            throw new MibException(mibSymbol.getLocation(), "only values can have the " + this.getName() + " type");
        }
        for (int i = 0; i < this.objects.size(); ++i) {
            MibValue mibValue = (MibValue)this.objects.get(i);
            arrayList.add(mibValue.initialize(mibLoaderLog, null));
        }
        this.objects = arrayList;
        return this;
    }

    public boolean isCompatible(MibValue mibValue) {
        return mibValue instanceof ObjectIdentifierValue;
    }

    public ArrayList getObjects() {
        return this.objects;
    }

    public SnmpStatus getStatus() {
        return this.status;
    }

    public String getReference() {
        return this.reference;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(" (");
        stringBuffer.append("\n  Objects: ");
        stringBuffer.append(this.objects);
        stringBuffer.append("\n  Status: ");
        stringBuffer.append(this.status);
        stringBuffer.append("\n  Description: ");
        stringBuffer.append(this.getDescription("               "));
        if (this.reference != null) {
            stringBuffer.append("\n  Reference: ");
            stringBuffer.append(this.reference);
        }
        stringBuffer.append("\n)");
        return stringBuffer.toString();
    }
}

