/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.snmp;

import java.util.ArrayList;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.snmp.SnmpRevision;
import net.percederberg.mibble.snmp.SnmpType;
import net.percederberg.mibble.value.ObjectIdentifierValue;

public class SnmpModuleIdentity
extends SnmpType {
    private String lastUpdated;
    private String organization;
    private String contactInfo;
    private ArrayList revisions;

    public SnmpModuleIdentity(String string, String string2, String string3, String string4, ArrayList arrayList) {
        super("MODULE-IDENTITY", string4);
        this.lastUpdated = string;
        this.organization = string2;
        this.contactInfo = string3;
        this.revisions = arrayList;
    }

    public MibType initialize(MibSymbol mibSymbol, MibLoaderLog mibLoaderLog) throws MibException {
        if (!(mibSymbol instanceof MibValueSymbol)) {
            throw new MibException(mibSymbol.getLocation(), "only values can have the " + this.getName() + " type");
        }
        for (int i = 0; i < this.revisions.size(); ++i) {
            SnmpRevision snmpRevision = (SnmpRevision)this.revisions.get(i);
            snmpRevision.initialize(mibLoaderLog);
        }
        return this;
    }

    public boolean isCompatible(MibValue mibValue) {
        return mibValue instanceof ObjectIdentifierValue;
    }

    public String getLastUpdated() {
        return this.lastUpdated;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getContactInfo() {
        return SnmpModuleIdentity.removeIndent(this.contactInfo);
    }

    public String getUnformattedContactInfo() {
        return this.contactInfo;
    }

    public ArrayList getRevisions() {
        return this.revisions;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(" (");
        stringBuffer.append("\n  Last Updated: ");
        stringBuffer.append(this.lastUpdated);
        stringBuffer.append("\n  Organization: ");
        stringBuffer.append(this.organization);
        stringBuffer.append("\n  Contact Info: ");
        stringBuffer.append(this.contactInfo);
        stringBuffer.append("\n  Description: ");
        stringBuffer.append(this.getDescription("               "));
        for (int i = 0; i < this.revisions.size(); ++i) {
            stringBuffer.append("\n  Revision: ");
            stringBuffer.append(this.revisions.get(i));
        }
        stringBuffer.append("\n)");
        return stringBuffer.toString();
    }
}

