/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.snmp;

import java.util.ArrayList;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.snmp.SnmpModule;
import net.percederberg.mibble.snmp.SnmpStatus;
import net.percederberg.mibble.snmp.SnmpType;
import net.percederberg.mibble.value.ObjectIdentifierValue;

public class SnmpModuleCompliance
extends SnmpType {
    private SnmpStatus status;
    private String reference;
    private ArrayList modules;

    public SnmpModuleCompliance(SnmpStatus snmpStatus, String string, String string2, ArrayList arrayList) {
        super("MODULE-COMPLIANCE", string);
        this.status = snmpStatus;
        this.reference = string2;
        this.modules = arrayList;
    }

    public MibType initialize(MibSymbol mibSymbol, MibLoaderLog mibLoaderLog) throws MibException {
        if (!(mibSymbol instanceof MibValueSymbol)) {
            throw new MibException(mibSymbol.getLocation(), "only values can have the " + this.getName() + " type");
        }
        for (int i = 0; i < this.modules.size(); ++i) {
            ((SnmpModule)this.modules.get(i)).initialize(mibLoaderLog);
        }
        return this;
    }

    public boolean isCompatible(MibValue mibValue) {
        return mibValue instanceof ObjectIdentifierValue;
    }

    public SnmpStatus getStatus() {
        return this.status;
    }

    public String getReference() {
        return this.reference;
    }

    public ArrayList getModules() {
        return this.modules;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(" (");
        stringBuffer.append("\n  Status: ");
        stringBuffer.append(this.status);
        stringBuffer.append("\n  Description: ");
        stringBuffer.append(this.getDescription("               "));
        if (this.reference != null) {
            stringBuffer.append("\n  Reference: ");
            stringBuffer.append(this.reference);
        }
        for (int i = 0; i < this.modules.size(); ++i) {
            stringBuffer.append("\n  Module: ");
            stringBuffer.append(this.modules.get(i));
        }
        stringBuffer.append("\n)");
        return stringBuffer.toString();
    }
}

