/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.snmp;

import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;

public class SnmpIndex {
    private boolean implied;
    private MibValue value;
    private MibType type;

    public SnmpIndex(boolean bl, MibValue mibValue, MibType mibType) {
        this.implied = bl;
        this.value = mibValue;
        this.type = mibType;
    }

    void initialize(MibSymbol mibSymbol, MibLoaderLog mibLoaderLog) throws MibException {
        if (this.value != null) {
            this.value = this.value.initialize(mibLoaderLog, null);
        }
        if (this.type != null) {
            this.type = this.type.initialize(mibSymbol, mibLoaderLog);
        }
    }

    public boolean isImplied() {
        return this.implied;
    }

    public MibValue getValue() {
        return this.value;
    }

    public MibType getType() {
        return this.type;
    }

    public Object getTypeOrValue() {
        if (this.value != null) {
            return this.value;
        }
        return this.type;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.implied) {
            stringBuffer.append("IMPLIED ");
        }
        stringBuffer.append(this.getTypeOrValue());
        return stringBuffer.toString();
    }
}

