/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.snmp;

import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.snmp.SnmpAccess;
import net.percederberg.mibble.snmp.SnmpType;

public class SnmpCompliance {
    private boolean group;
    private MibValue value;
    private MibType syntax;
    private MibType writeSyntax;
    private SnmpAccess access;
    private String description;
    private String comment = null;

    public SnmpCompliance(boolean bl, MibValue mibValue, MibType mibType, MibType mibType2, SnmpAccess snmpAccess, String string) {
        this.group = bl;
        this.value = mibValue;
        this.syntax = mibType;
        this.writeSyntax = mibType2;
        this.access = snmpAccess;
        this.description = string;
    }

    void initialize(MibLoaderLog mibLoaderLog) throws MibException {
        this.value = this.value.initialize(mibLoaderLog, null);
        if (this.syntax != null) {
            this.syntax = this.syntax.initialize(null, mibLoaderLog);
        }
        if (this.writeSyntax != null) {
            this.writeSyntax = this.writeSyntax.initialize(null, mibLoaderLog);
        }
    }

    public boolean isGroup() {
        return this.group;
    }

    public boolean isObject() {
        return !this.group;
    }

    public MibValue getValue() {
        return this.value;
    }

    public MibType getSyntax() {
        return this.syntax;
    }

    public MibType getWriteSyntax() {
        return this.writeSyntax;
    }

    public SnmpAccess getAccess() {
        return this.access;
    }

    public String getDescription() {
        return SnmpType.removeIndent(this.description);
    }

    public String getUnformattedDescription() {
        return this.description;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.value);
        if (this.syntax != null) {
            stringBuffer.append("\n      Syntax: ");
            stringBuffer.append(this.syntax);
        }
        if (this.writeSyntax != null) {
            stringBuffer.append("\n      Write-Syntax: ");
            stringBuffer.append(this.writeSyntax);
        }
        if (this.access != null) {
            stringBuffer.append("\n      Access: ");
            stringBuffer.append(this.access);
        }
        stringBuffer.append("\n      Description: ");
        stringBuffer.append(this.description);
        return stringBuffer.toString();
    }
}

