/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibLoader;
import net.percederberg.mibble.MibLoaderException;

public class MibbleValidator {
    private static final String COMMAND_HELP = "Validates a set of SNMP MIB files. This program comes with\nABSOLUTELY NO WARRANTY; for details see the LICENSE.txt file.\n\nSyntax: MibbleValidator <file(s) or URL(s)>";
    private static final String INTERNAL_ERROR = "INTERNAL ERROR: An internal error has been found. Please report\n    this error to the maintainers (see the web site for\n    instructions). Be sure to include the version number, as\n    well as the text below:\n";

    public static void main(String[] stringArray) {
        File file;
        int n;
        MibLoader mibLoader = new MibLoader();
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
        int n2 = 0;
        int n3 = 0;
        if (stringArray.length < 1) {
            MibbleValidator.printHelp("No file(s) specified");
            System.exit(1);
        }
        for (n = 0; n < stringArray.length; ++n) {
            try {
                if (stringArray[0].contains(":")) {
                    arrayList.add(new URL(stringArray[0]));
                    continue;
                }
                file = new File(stringArray[n]);
                if (!file.exists()) {
                    System.out.println("Warning: Skipping " + stringArray[n] + ": file not found");
                    continue;
                }
                if (file.isDirectory()) {
                    MibbleValidator.addMibs(file, arrayList);
                    continue;
                }
                arrayList.add(file);
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println("Warning: Skipping " + stringArray[n] + ": " + malformedURLException.getMessage());
            }
        }
        for (n = 0; n < arrayList.size(); ++n) {
            Object e = arrayList.get(n);
            System.out.print(n);
            System.out.print("/");
            System.out.print(arrayList.size());
            System.out.print(": Reading " + e + "... ");
            System.out.flush();
            try {
                Mib mib;
                mibLoader.unloadAll();
                if (e instanceof URL) {
                    mibLoader.removeAllDirs();
                    mib = mibLoader.load((URL)e);
                } else {
                    file = (File)e;
                    if (!mibLoader.hasDir(file.getParentFile())) {
                        mibLoader.removeAllDirs();
                        mibLoader.addDir(file.getParentFile());
                    }
                    mib = mibLoader.load(file);
                }
                System.out.println("[OK]");
                if (mib.getLog().warningCount() <= 0) continue;
                mib.getLog().printTo(System.out);
                ++n3;
                continue;
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("[FAILED]");
                MibbleValidator.printError(e.toString(), fileNotFoundException);
                ++n2;
                continue;
            }
            catch (IOException iOException) {
                System.out.println("[FAILED]");
                MibbleValidator.printError(e.toString(), iOException);
                ++n2;
                continue;
            }
            catch (MibLoaderException mibLoaderException) {
                System.out.println("[FAILED]");
                mibLoaderException.getLog().printTo(System.out);
                ++n2;
                continue;
            }
            catch (RuntimeException runtimeException) {
                System.out.println();
                MibbleValidator.printInternalError(runtimeException);
                System.exit(1);
            }
        }
        System.out.println();
        System.out.println("Files processed:  " + arrayList.size());
        System.out.println("  with errors:    " + n2);
        System.out.println("  with warnings:  " + n3);
        if (n2 > 0) {
            System.err.println("Error: validation errors were encountered");
        }
        System.exit(n2);
    }

    private static void printHelp(String string) {
        System.err.println(COMMAND_HELP);
        System.err.println();
        if (string != null) {
            System.err.print("Error: ");
            System.err.println(string);
            System.err.println();
        }
    }

    private static void printInternalError(Exception exception) {
        System.err.println(INTERNAL_ERROR);
        exception.printStackTrace();
    }

    private static void printError(String string, FileNotFoundException fileNotFoundException) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Error: couldn't open file:");
        stringBuffer.append("\n    ");
        stringBuffer.append(string);
        System.out.println(stringBuffer.toString());
    }

    private static void printError(String string, IOException iOException) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Error: couldn't open URL:");
        stringBuffer.append("\n    ");
        stringBuffer.append(string);
        System.out.println(stringBuffer.toString());
    }

    private static void addMibs(File file, ArrayList arrayList) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isHidden()) continue;
            if (fileArray[i].isDirectory()) {
                MibbleValidator.addMibs(fileArray[i], arrayList);
                continue;
            }
            if (!MibbleValidator.isMib(fileArray[i])) continue;
            arrayList.add(fileArray[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isMib(File file) {
        BufferedReader bufferedReader = null;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        if (!file.canRead() || !file.isFile()) {
            return false;
        }
        try {
            String string;
            bufferedReader = new BufferedReader(new FileReader(file));
            while (n++ < 100 && (string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return stringBuffer.indexOf("DEFINITIONS") > 0 && stringBuffer.indexOf("::=") > 0 && stringBuffer.indexOf("BEGIN") > 0;
    }
}

