/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibLoader;
import net.percederberg.mibble.MibLoaderException;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.MibWriter;
import net.percederberg.mibble.value.ObjectIdentifierValue;

public class MibblePrinter {
    private static final String COMMAND_HELP = "Prints the contents of an SNMP MIB file. This program comes with\nABSOLUTELY NO WARRANTY; for details see the LICENSE.txt file.\n\nSyntax: MibblePrinter [--mib|--oid|--debug] <file(s) or URL(s)>\n\n    --mib     Prints a formatted and indented version of the MIB.\n              This is the default printing mode.\n    --oid     Prints the complete OID tree, including all nodes\n              in imported MIB files\n    --debug   Prints the MIB contents in debug format, which will\n              display all values completely resolved.";
    private static final String INTERNAL_ERROR = "INTERNAL ERROR: An internal error has been found. Please report\n    this error to the maintainers (see the web site for\n    instructions). Be sure to include the version number, as\n    well as the text below:\n";
    private static final int MIB_PRINT_MODE = 0;
    private static final int OID_PRINT_MODE = 1;
    private static final int DEBUG_PRINT_MODE = 2;

    public static void main(String[] stringArray) {
        MibLoader mibLoader = new MibLoader();
        int n = 0;
        Mib mib = null;
        int n2 = 0;
        if (stringArray.length < 1) {
            MibblePrinter.printHelp("No MIB file or URL specified");
            System.exit(1);
        } else if (stringArray[0].startsWith("--") && stringArray.length < 2) {
            MibblePrinter.printHelp("No MIB file or URL specified");
            System.exit(1);
        }
        if (stringArray[0].equals("--mib")) {
            n = 0;
            ++n2;
        } else if (stringArray[0].equals("--oid")) {
            n = 1;
            ++n2;
        } else if (stringArray[0].equals("--debug")) {
            n = 2;
            ++n2;
        } else if (stringArray[0].startsWith("--")) {
            MibblePrinter.printHelp("No option '" + stringArray[0] + "' exist");
            System.exit(1);
        }
        try {
            while (n2 < stringArray.length) {
                URL uRL;
                try {
                    uRL = new URL(stringArray[n2]);
                }
                catch (MalformedURLException malformedURLException) {
                    uRL = null;
                }
                if (uRL == null) {
                    File file = new File(stringArray[n2]);
                    mibLoader.addDir(file.getParentFile());
                    mib = mibLoader.load(file);
                } else {
                    mib = mibLoader.load(uRL);
                }
                if (mib.getLog().warningCount() > 0) {
                    mib.getLog().printTo(System.err);
                }
                ++n2;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            MibblePrinter.printError(stringArray[n2], fileNotFoundException);
            System.exit(1);
        }
        catch (IOException iOException) {
            MibblePrinter.printError(stringArray[n2], iOException);
            System.exit(1);
        }
        catch (MibLoaderException mibLoaderException) {
            mibLoaderException.getLog().printTo(System.err);
            System.exit(1);
        }
        catch (RuntimeException runtimeException) {
            MibblePrinter.printInternalError(runtimeException);
            System.exit(1);
        }
        if (n == 1) {
            MibblePrinter.printOidTree(mibLoader);
        } else {
            MibblePrinter.printMibs(mibLoader, n);
        }
    }

    private static void printMibs(MibLoader mibLoader, int n) {
        Mib[] mibArray = mibLoader.getAllMibs();
        for (int i = 0; i < mibArray.length; ++i) {
            if (!mibArray[i].isLoaded()) continue;
            if (n == 0) {
                MibblePrinter.printMib(mibArray[i]);
                continue;
            }
            MibblePrinter.printDebug(mibArray[i]);
        }
    }

    private static void printMib(Mib mib) {
        MibWriter mibWriter = new MibWriter(System.out);
        mibWriter.print(mib);
        System.out.println();
        System.out.println();
    }

    private static void printDebug(Mib mib) {
        Iterator iterator = mib.getAllSymbols().iterator();
        while (iterator.hasNext()) {
            System.out.println(iterator.next());
            System.out.println();
        }
        System.out.println();
        System.out.println();
    }

    private static void printOidTree(MibLoader mibLoader) {
        ObjectIdentifierValue objectIdentifierValue = null;
        if (mibLoader.getAllMibs().length <= 0) {
            MibblePrinter.printError("no MIB modules have been loaded");
            return;
        }
        Mib mib = mibLoader.getAllMibs()[0];
        Iterator iterator = mib.getAllSymbols().iterator();
        while (objectIdentifierValue == null && iterator.hasNext()) {
            MibValue mibValue;
            MibSymbol mibSymbol = (MibSymbol)iterator.next();
            if (!(mibSymbol instanceof MibValueSymbol) || !((mibValue = ((MibValueSymbol)mibSymbol).getValue()) instanceof ObjectIdentifierValue)) continue;
            objectIdentifierValue = (ObjectIdentifierValue)mibValue;
        }
        if (objectIdentifierValue == null) {
            MibblePrinter.printError("no OID value could be found in " + mib.getName());
        } else {
            while (objectIdentifierValue.getParent() != null) {
                objectIdentifierValue = objectIdentifierValue.getParent();
            }
            MibblePrinter.printOid(objectIdentifierValue);
        }
    }

    private static void printOid(ObjectIdentifierValue objectIdentifierValue) {
        System.out.println(objectIdentifierValue.toDetailString());
        for (int i = 0; i < objectIdentifierValue.getChildCount(); ++i) {
            MibblePrinter.printOid(objectIdentifierValue.getChild(i));
        }
    }

    private static void printHelp(String string) {
        System.err.println(COMMAND_HELP);
        System.err.println();
        if (string != null) {
            MibblePrinter.printError(string);
        }
    }

    private static void printInternalError(Exception exception) {
        System.err.println(INTERNAL_ERROR);
        exception.printStackTrace();
    }

    private static void printError(String string) {
        System.err.print("Error: ");
        System.err.println(string);
    }

    private static void printError(String string, FileNotFoundException fileNotFoundException) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("couldn't open file:\n    ");
        stringBuffer.append(string);
        MibblePrinter.printError(stringBuffer.toString());
    }

    private static void printError(String string, IOException iOException) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("couldn't open URL:\n    ");
        stringBuffer.append(string);
        MibblePrinter.printError(stringBuffer.toString());
    }
}

