/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import net.percederberg.mibble.FileLocation;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.snmp.SnmpObjectType;
import net.percederberg.mibble.type.SequenceOfType;
import net.percederberg.mibble.type.SequenceType;
import net.percederberg.mibble.value.ObjectIdentifierValue;

public class MibValueSymbol
extends MibSymbol {
    private MibType type;
    private MibValue value;

    public MibValueSymbol(FileLocation fileLocation, Mib mib, String string, MibType mibType, MibValue mibValue) {
        super(fileLocation, mib, string);
        this.type = mibType;
        this.value = mibValue;
    }

    public void initialize(MibLoaderLog mibLoaderLog) throws MibException {
        ObjectIdentifierValue objectIdentifierValue;
        if (this.type != null) {
            try {
                this.type = this.type.initialize(this, mibLoaderLog);
            }
            catch (MibException mibException) {
                mibLoaderLog.addError(mibException.getLocation(), mibException.getMessage());
                this.type = null;
            }
        }
        if (this.value != null) {
            try {
                this.value = this.value.initialize(mibLoaderLog, this.type);
            }
            catch (MibException mibException) {
                mibLoaderLog.addError(mibException.getLocation(), mibException.getMessage());
                this.value = null;
            }
        }
        if (this.type != null && this.value != null && !this.type.isCompatible(this.value)) {
            mibLoaderLog.addError(this.getLocation(), "value is not compatible with type");
        }
        if (this.value instanceof ObjectIdentifierValue && (objectIdentifierValue = (ObjectIdentifierValue)this.value).getSymbol() == null) {
            objectIdentifierValue.setSymbol(this);
        }
    }

    void clear() {
        this.type = null;
        if (this.value != null) {
            this.value.clear();
        }
        this.value = null;
    }

    public boolean isScalar() {
        return this.type instanceof SnmpObjectType && !this.isTable() && !this.isTableRow() && !this.isTableColumn();
    }

    public boolean isTable() {
        if (this.type instanceof SnmpObjectType) {
            MibType mibType = ((SnmpObjectType)this.type).getSyntax();
            return mibType instanceof SequenceOfType;
        }
        return false;
    }

    public boolean isTableRow() {
        if (this.type instanceof SnmpObjectType) {
            MibType mibType = ((SnmpObjectType)this.type).getSyntax();
            return mibType instanceof SequenceType;
        }
        return false;
    }

    public boolean isTableColumn() {
        MibValueSymbol mibValueSymbol = this.getParent();
        return this.type instanceof SnmpObjectType && mibValueSymbol != null && mibValueSymbol.isTableRow();
    }

    public MibType getType() {
        return this.type;
    }

    public MibValue getValue() {
        return this.value;
    }

    public MibValueSymbol getParent() {
        ObjectIdentifierValue objectIdentifierValue;
        if (this.value instanceof ObjectIdentifierValue && (objectIdentifierValue = ((ObjectIdentifierValue)this.value).getParent()) != null) {
            return objectIdentifierValue.getSymbol();
        }
        return null;
    }

    public int getChildCount() {
        if (this.value instanceof ObjectIdentifierValue) {
            return ((ObjectIdentifierValue)this.value).getChildCount();
        }
        return 0;
    }

    public MibValueSymbol getChild(int n) {
        ObjectIdentifierValue objectIdentifierValue;
        if (this.value instanceof ObjectIdentifierValue && (objectIdentifierValue = ((ObjectIdentifierValue)this.value).getChild(n)) != null) {
            return objectIdentifierValue.getSymbol();
        }
        return null;
    }

    public MibValueSymbol[] getChildren() {
        MibValueSymbol[] mibValueSymbolArray;
        if (this.value instanceof ObjectIdentifierValue) {
            ObjectIdentifierValue objectIdentifierValue = (ObjectIdentifierValue)this.value;
            mibValueSymbolArray = new MibValueSymbol[objectIdentifierValue.getChildCount()];
            for (int i = 0; i < objectIdentifierValue.getChildCount(); ++i) {
                mibValueSymbolArray[i] = objectIdentifierValue.getChild(i).getSymbol();
            }
        } else {
            mibValueSymbolArray = new MibValueSymbol[]{};
        }
        return mibValueSymbolArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("VALUE ");
        stringBuffer.append(this.getName());
        stringBuffer.append(" ");
        stringBuffer.append(this.getType());
        stringBuffer.append("\n    ::= ");
        stringBuffer.append(this.getValue());
        return stringBuffer.toString();
    }
}

