/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

public class MibTypeTag {
    public static final int UNIVERSAL_CATEGORY = 0;
    public static final int APPLICATION_CATEGORY = 1;
    public static final int CONTEXT_SPECIFIC_CATEGORY = 2;
    public static final int PRIVATE_CATEGORY = 3;
    public static final MibTypeTag BOOLEAN = new MibTypeTag(0, 1);
    public static final MibTypeTag INTEGER = new MibTypeTag(0, 2);
    public static final MibTypeTag BIT_STRING = new MibTypeTag(0, 3);
    public static final MibTypeTag OCTET_STRING = new MibTypeTag(0, 4);
    public static final MibTypeTag NULL = new MibTypeTag(0, 5);
    public static final MibTypeTag OBJECT_IDENTIFIER = new MibTypeTag(0, 6);
    public static final MibTypeTag REAL = new MibTypeTag(0, 9);
    public static final MibTypeTag SEQUENCE = new MibTypeTag(0, 16);
    public static final MibTypeTag SET = new MibTypeTag(0, 17);
    private int category;
    private int value;
    private MibTypeTag next = null;

    public MibTypeTag(int n, int n2) {
        this.category = n;
        this.value = n2;
    }

    public boolean equals(Object object) {
        if (object instanceof MibTypeTag) {
            MibTypeTag mibTypeTag = (MibTypeTag)object;
            return this.equals(mibTypeTag.category, mibTypeTag.value);
        }
        return false;
    }

    public boolean equals(int n, int n2) {
        return this.category == n && this.value == n2;
    }

    public int hashCode() {
        return (this.category << 8) + this.value;
    }

    public int getCategory() {
        return this.category;
    }

    public int getValue() {
        return this.value;
    }

    public MibTypeTag getNext() {
        return this.next;
    }

    public void setNext(MibTypeTag mibTypeTag) {
        this.next = mibTypeTag;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        if (this.category == 0) {
            stringBuffer.append("UNIVERSAL ");
        } else if (this.category == 1) {
            stringBuffer.append("APPLICATION ");
        } else if (this.category == 3) {
            stringBuffer.append("PRIVATE ");
        }
        stringBuffer.append(this.value);
        stringBuffer.append("]");
        if (this.next != null) {
            stringBuffer.append(" ");
            stringBuffer.append(this.next.toString());
        }
        return stringBuffer.toString();
    }
}

