/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import net.percederberg.mibble.MibContext;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibImport;
import net.percederberg.mibble.MibLoader;
import net.percederberg.mibble.MibLoaderException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.value.NumberValue;
import net.percederberg.mibble.value.ObjectIdentifierValue;

public class Mib
implements MibContext {
    private File file;
    private MibLoader loader;
    private MibLoaderLog log;
    private boolean loaded = false;
    private String name = null;
    private int smiVersion = 1;
    private String headerComment = null;
    private String footerComment = null;
    private ArrayList imports = new ArrayList();
    private ArrayList symbolList = new ArrayList();
    private HashMap symbolNameMap = new HashMap();
    private HashMap symbolValueMap = new HashMap();

    Mib(File file, MibLoader mibLoader, MibLoaderLog mibLoaderLog) {
        this.file = file;
        this.loader = mibLoader;
        this.log = mibLoaderLog;
    }

    void initialize() throws MibLoaderException {
        int n = this.log.errorCount();
        for (int i = 0; i < this.imports.size(); ++i) {
            MibImport mibImport = (MibImport)this.imports.get(i);
            try {
                mibImport.initialize(this.log);
                continue;
            }
            catch (MibException mibException) {
                this.log.addError(mibException.getLocation(), mibException.getMessage());
            }
        }
        if (n != this.log.errorCount()) {
            throw new MibLoaderException(this.log);
        }
    }

    void validate() throws MibLoaderException {
        int n = this.log.errorCount();
        for (int i = 0; i < this.symbolList.size(); ++i) {
            MibValueSymbol mibValueSymbol;
            MibSymbol mibSymbol = (MibSymbol)this.symbolList.get(i);
            try {
                mibSymbol.initialize(this.log);
            }
            catch (MibException mibException) {
                this.log.addError(mibException.getLocation(), mibException.getMessage());
            }
            if (!(mibSymbol instanceof MibValueSymbol) || !((mibValueSymbol = (MibValueSymbol)mibSymbol).getValue() instanceof NumberValue) && !(mibValueSymbol.getValue() instanceof ObjectIdentifierValue)) continue;
            this.symbolValueMap.put(mibValueSymbol.getValue().toString(), mibSymbol);
        }
        if (n != this.log.errorCount()) {
            throw new MibLoaderException(this.log);
        }
    }

    void clear() {
        this.loader = null;
        this.log = null;
        if (this.imports != null) {
            this.imports.clear();
        }
        this.imports = null;
        if (this.symbolList != null) {
            for (int i = 0; i < this.symbolList.size(); ++i) {
                ((MibSymbol)this.symbolList.get(i)).clear();
            }
            this.symbolList.clear();
        }
        this.symbolList = null;
        if (this.symbolNameMap != null) {
            this.symbolNameMap.clear();
        }
        this.symbolNameMap = null;
        if (this.symbolValueMap != null) {
            this.symbolValueMap.clear();
        }
        this.symbolValueMap = null;
    }

    public boolean equals(Object object) {
        if (object instanceof String) {
            return this.name.equals(object);
        }
        if (this.file != null && object instanceof File) {
            return this.file.equals(object);
        }
        if (object instanceof Mib) {
            return object.equals(this.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    void setLoaded(boolean bl) {
        this.loaded = bl;
    }

    public String getName() {
        return this.name;
    }

    void setName(String string) {
        this.name = string;
        if (this.file == null) {
            this.file = new File(string);
        }
    }

    public File getFile() {
        return this.file;
    }

    public MibLoader getLoader() {
        return this.loader;
    }

    public MibLoaderLog getLog() {
        return this.log;
    }

    public int getSmiVersion() {
        return this.smiVersion;
    }

    void setSmiVersion(int n) {
        this.smiVersion = n;
    }

    public String getHeaderComment() {
        return this.headerComment;
    }

    void setHeaderComment(String string) {
        this.headerComment = string;
    }

    public String getFooterComment() {
        return this.footerComment;
    }

    void setFooterComment(String string) {
        this.footerComment = string;
    }

    public Collection getAllImports() {
        ArrayList<MibImport> arrayList = new ArrayList<MibImport>();
        for (int i = 0; i < this.imports.size(); ++i) {
            MibImport mibImport = (MibImport)this.imports.get(i);
            if (!mibImport.hasSymbols()) continue;
            arrayList.add(mibImport);
        }
        return arrayList;
    }

    MibImport getImport(String string) {
        for (int i = 0; i < this.imports.size(); ++i) {
            MibImport mibImport = (MibImport)this.imports.get(i);
            if (!mibImport.getName().equals(string)) continue;
            return mibImport;
        }
        return null;
    }

    void addImport(MibImport mibImport) {
        this.imports.add(mibImport);
    }

    public Mib[] getImportingMibs() {
        ArrayList<Mib> arrayList = new ArrayList<Mib>();
        Mib[] mibArray = this.loader.getAllMibs();
        for (int i = 0; i < mibArray.length; ++i) {
            if (mibArray[i] == this || mibArray[i].getImport(this.name) == null) continue;
            arrayList.add(mibArray[i]);
        }
        mibArray = new Mib[arrayList.size()];
        arrayList.toArray(mibArray);
        return mibArray;
    }

    public Collection getAllSymbols() {
        return this.symbolList;
    }

    public MibSymbol getSymbol(String string) {
        return (MibSymbol)this.symbolNameMap.get(string);
    }

    public MibValueSymbol getSymbolByValue(String string) {
        return (MibValueSymbol)this.symbolValueMap.get(string);
    }

    public MibValueSymbol getSymbolByValue(MibValue mibValue) {
        return (MibValueSymbol)this.symbolValueMap.get(mibValue.toString());
    }

    public MibValueSymbol getSymbolByOid(String string) {
        int n;
        do {
            MibValueSymbol mibValueSymbol;
            if ((mibValueSymbol = this.getSymbolByValue(string)) != null) {
                return mibValueSymbol;
            }
            n = string.lastIndexOf(".");
            if (n <= 0) continue;
            string = string.substring(0, n);
        } while (n > 0);
        return null;
    }

    public MibValueSymbol getRootSymbol() {
        MibValueSymbol mibValueSymbol;
        MibValueSymbol mibValueSymbol2 = null;
        for (int i = 0; i < this.symbolList.size(); ++i) {
            if (!(this.symbolList.get(i) instanceof MibValueSymbol)) continue;
            mibValueSymbol2 = (MibValueSymbol)this.symbolList.get(i);
            break;
        }
        while (mibValueSymbol2 != null && (mibValueSymbol = mibValueSymbol2.getParent()) != null && mibValueSymbol2.getMib().equals(mibValueSymbol.getMib())) {
            mibValueSymbol2 = mibValueSymbol;
        }
        return mibValueSymbol2;
    }

    void addSymbol(MibSymbol mibSymbol) {
        this.symbolList.add(mibSymbol);
        this.symbolNameMap.put(mibSymbol.getName(), mibSymbol);
    }

    public MibSymbol findSymbol(String string, boolean bl) {
        return this.getSymbol(string);
    }

    public String toString() {
        return this.getName();
    }
}

