/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser.re;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.BitSet;
import net.percederberg.grammatica.parser.ReaderBuffer;
import net.percederberg.grammatica.parser.re.Element;
import net.percederberg.grammatica.parser.re.Matcher;

class RepeatElement
extends Element {
    public static final int GREEDY = 1;
    public static final int RELUCTANT = 2;
    public static final int POSSESSIVE = 3;
    private Element elem;
    private int min;
    private int max;
    private int type;
    private int matchStart;
    private BitSet matches;

    public RepeatElement(Element element, int n, int n2, int n3) {
        this.elem = element;
        this.min = n;
        this.max = n2 <= 0 ? Integer.MAX_VALUE : n2;
        this.type = n3;
        this.matchStart = -1;
        this.matches = null;
    }

    public Object clone() {
        return new RepeatElement((Element)this.elem.clone(), this.min, this.max, this.type);
    }

    public int match(Matcher matcher, ReaderBuffer readerBuffer, int n, int n2) throws IOException {
        if (n2 == 0) {
            this.matchStart = -1;
            this.matches = null;
        }
        switch (this.type) {
            case 1: {
                return this.matchGreedy(matcher, readerBuffer, n, n2);
            }
            case 2: {
                return this.matchReluctant(matcher, readerBuffer, n, n2);
            }
            case 3: {
                if (n2 != 0) break;
                return this.matchPossessive(matcher, readerBuffer, n, 0);
            }
        }
        return -1;
    }

    private int matchGreedy(Matcher matcher, ReaderBuffer readerBuffer, int n, int n2) throws IOException {
        if (n2 == 0) {
            return this.matchPossessive(matcher, readerBuffer, n, 0);
        }
        if (this.matchStart != n) {
            this.matchStart = n;
            this.matches = new BitSet();
            this.findMatches(matcher, readerBuffer, n, 0, 0, 0);
        }
        for (int i = this.matches.size(); i >= 0; --i) {
            if (!this.matches.get(i)) continue;
            if (n2 == 0) {
                return i;
            }
            --n2;
        }
        return -1;
    }

    private int matchReluctant(Matcher matcher, ReaderBuffer readerBuffer, int n, int n2) throws IOException {
        if (this.matchStart != n) {
            this.matchStart = n;
            this.matches = new BitSet();
            this.findMatches(matcher, readerBuffer, n, 0, 0, 0);
        }
        for (int i = 0; i <= this.matches.size(); ++i) {
            if (!this.matches.get(i)) continue;
            if (n2 == 0) {
                return i;
            }
            --n2;
        }
        return -1;
    }

    private int matchPossessive(Matcher matcher, ReaderBuffer readerBuffer, int n, int n2) throws IOException {
        int n3 = 0;
        int n4 = 1;
        while (n4 > 0 && n2 < this.max) {
            n4 = this.elem.match(matcher, readerBuffer, n + n3, 0);
            if (n4 < 0) continue;
            ++n2;
            n3 += n4;
        }
        if (this.min <= n2 && n2 <= this.max) {
            return n3;
        }
        return -1;
    }

    private void findMatches(Matcher matcher, ReaderBuffer readerBuffer, int n, int n2, int n3, int n4) throws IOException {
        int n5;
        if (n3 > this.max) {
            return;
        }
        if (this.min <= n3 && n4 == 0) {
            this.matches.set(n2);
        }
        if ((n5 = this.elem.match(matcher, readerBuffer, n, n4)) < 0) {
            return;
        }
        if (n5 == 0) {
            if (this.min == n3 + 1) {
                this.matches.set(n2);
            }
            return;
        }
        this.findMatches(matcher, readerBuffer, n, n2, n3, n4 + 1);
        this.findMatches(matcher, readerBuffer, n + n5, n2 + n5, n3 + 1, 0);
    }

    public void printTo(PrintWriter printWriter, String string) {
        printWriter.print(string + "Repeat (" + this.min + "," + this.max + ")");
        if (this.type == 2) {
            printWriter.print("?");
        } else if (this.type == 3) {
            printWriter.print("+");
        }
        printWriter.println();
        this.elem.printTo(printWriter, string + "  ");
    }
}

