/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser.re;

import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import net.percederberg.grammatica.parser.ReaderBuffer;
import net.percederberg.grammatica.parser.re.AlternativeElement;
import net.percederberg.grammatica.parser.re.CharBuffer;
import net.percederberg.grammatica.parser.re.CharacterSetElement;
import net.percederberg.grammatica.parser.re.CombineElement;
import net.percederberg.grammatica.parser.re.Element;
import net.percederberg.grammatica.parser.re.Matcher;
import net.percederberg.grammatica.parser.re.RegExpException;
import net.percederberg.grammatica.parser.re.RepeatElement;
import net.percederberg.grammatica.parser.re.StringElement;

public class RegExp {
    private Element element;
    private String pattern;
    private boolean ignoreCase;
    private int pos;

    public RegExp(String string) throws RegExpException {
        this(string, false);
    }

    public RegExp(String string, boolean bl) throws RegExpException {
        this.pattern = string;
        this.ignoreCase = bl;
        this.pos = 0;
        this.element = this.parseExpr();
        if (this.pos < string.length()) {
            throw new RegExpException(1, this.pos, string);
        }
    }

    public Matcher matcher(CharBuffer charBuffer) {
        return this.matcher(charBuffer.toString());
    }

    public Matcher matcher(String string) {
        return this.matcher(new ReaderBuffer(new StringReader(string)));
    }

    public Matcher matcher(ReaderBuffer readerBuffer) {
        return new Matcher((Element)this.element.clone(), readerBuffer, this.ignoreCase);
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("Regular Expression\n");
        stringWriter.write("  Pattern: " + this.pattern + "\n");
        stringWriter.write("  Flags:");
        if (this.ignoreCase) {
            stringWriter.write(" caseignore");
        }
        stringWriter.write("\n");
        stringWriter.write("  Compiled:\n");
        this.element.printTo(new PrintWriter(stringWriter), "    ");
        return stringWriter.toString();
    }

    private Element parseExpr() throws RegExpException {
        Element element = this.parseTerm();
        if (this.peekChar(0) != 124) {
            return element;
        }
        this.readChar('|');
        Element element2 = this.parseExpr();
        return new AlternativeElement(element, element2);
    }

    private Element parseTerm() throws RegExpException {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        arrayList.add(this.parseFact());
        while (true) {
            switch (this.peekChar(0)) {
                case -1: 
                case 41: 
                case 43: 
                case 63: 
                case 93: 
                case 123: 
                case 124: 
                case 125: {
                    return this.combineElements(arrayList);
                }
            }
            arrayList.add(this.parseFact());
        }
    }

    private Element parseFact() throws RegExpException {
        Element element = this.parseAtom();
        switch (this.peekChar(0)) {
            case 42: 
            case 43: 
            case 63: 
            case 123: {
                return this.parseAtomModifier(element);
            }
        }
        return element;
    }

    private Element parseAtom() throws RegExpException {
        switch (this.peekChar(0)) {
            case 46: {
                this.readChar('.');
                return CharacterSetElement.DOT;
            }
            case 40: {
                this.readChar('(');
                Element element = this.parseExpr();
                this.readChar(')');
                return element;
            }
            case 91: {
                this.readChar('[');
                Element element = this.parseCharSet();
                this.readChar(']');
                return element;
            }
            case -1: 
            case 41: 
            case 42: 
            case 43: 
            case 63: 
            case 93: 
            case 123: 
            case 124: 
            case 125: {
                throw new RegExpException(1, this.pos, this.pattern);
            }
        }
        return this.parseChar();
    }

    private Element parseAtomModifier(Element element) throws RegExpException {
        int n = 0;
        int n2 = -1;
        int n3 = 1;
        switch (this.readChar()) {
            case '?': {
                n = 0;
                n2 = 1;
                break;
            }
            case '*': {
                n = 0;
                n2 = -1;
                break;
            }
            case '+': {
                n = 1;
                n2 = -1;
                break;
            }
            case '{': {
                int n4 = this.pos - 1;
                n2 = n = this.readNumber();
                if (this.peekChar(0) == 44) {
                    this.readChar(',');
                    n2 = -1;
                    if (this.peekChar(0) != 125) {
                        n2 = this.readNumber();
                    }
                }
                this.readChar('}');
                if (n2 != 0 && (n2 <= 0 || n <= n2)) break;
                throw new RegExpException(5, n4, this.pattern);
            }
            default: {
                throw new RegExpException(1, this.pos - 1, this.pattern);
            }
        }
        if (this.peekChar(0) == 63) {
            this.readChar('?');
            n3 = 2;
        } else if (this.peekChar(0) == 43) {
            this.readChar('+');
            n3 = 3;
        }
        return new RepeatElement(element, n, n2, n3);
    }

    private Element parseCharSet() throws RegExpException {
        CharacterSetElement characterSetElement;
        boolean bl = true;
        if (this.peekChar(0) == 94) {
            this.readChar('^');
            characterSetElement = new CharacterSetElement(true);
        } else {
            characterSetElement = new CharacterSetElement(false);
        }
        block4: while (this.peekChar(0) > 0 && bl) {
            char c = (char)this.peekChar(0);
            switch (c) {
                case ']': {
                    bl = false;
                    continue block4;
                }
                case '\\': {
                    Element element = this.parseEscapeChar();
                    if (element instanceof StringElement) {
                        characterSetElement.addCharacters((StringElement)element);
                        continue block4;
                    }
                    characterSetElement.addCharacterSet((CharacterSetElement)element);
                    continue block4;
                }
            }
            this.readChar(c);
            if (this.peekChar(0) == 45 && this.peekChar(1) > 0 && this.peekChar(1) != 93) {
                this.readChar('-');
                char c2 = this.readChar();
                characterSetElement.addRange(this.fixChar(c), this.fixChar(c2));
                continue;
            }
            characterSetElement.addCharacter(this.fixChar(c));
        }
        return characterSetElement;
    }

    private Element parseChar() throws RegExpException {
        switch (this.peekChar(0)) {
            case 92: {
                return this.parseEscapeChar();
            }
            case 36: 
            case 94: {
                throw new RegExpException(3, this.pos, this.pattern);
            }
        }
        return new StringElement(this.fixChar(this.readChar()));
    }

    private Element parseEscapeChar() throws RegExpException {
        this.readChar('\\');
        char c = this.readChar();
        switch (c) {
            case '0': {
                c = this.readChar();
                if (c < '0' || c > '3') {
                    throw new RegExpException(4, this.pos - 3, this.pattern);
                }
                String string = String.valueOf(c);
                c = (char)this.peekChar(0);
                if ('0' <= c && c <= '7') {
                    string = string + String.valueOf(this.readChar());
                    c = (char)this.peekChar(0);
                    if ('0' <= c && c <= '7') {
                        string = string + String.valueOf(this.readChar());
                    }
                }
                try {
                    c = (char)Integer.parseInt(string, 8);
                    return new StringElement(this.fixChar(c));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new RegExpException(4, this.pos - string.length() - 2, this.pattern);
                }
            }
            case 'x': {
                String string = String.valueOf(this.readChar()) + String.valueOf(this.readChar());
                try {
                    c = (char)Integer.parseInt(string, 16);
                    return new StringElement(this.fixChar(c));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new RegExpException(4, this.pos - string.length() - 2, this.pattern);
                }
            }
            case 'u': {
                String string = String.valueOf(this.readChar()) + String.valueOf(this.readChar()) + String.valueOf(this.readChar()) + String.valueOf(this.readChar());
                try {
                    c = (char)Integer.parseInt(string, 16);
                    return new StringElement(this.fixChar(c));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new RegExpException(4, this.pos - string.length() - 2, this.pattern);
                }
            }
            case 't': {
                return new StringElement('\t');
            }
            case 'n': {
                return new StringElement('\n');
            }
            case 'r': {
                return new StringElement('\r');
            }
            case 'f': {
                return new StringElement('\f');
            }
            case 'a': {
                return new StringElement('\u0007');
            }
            case 'e': {
                return new StringElement('\u001b');
            }
            case 'd': {
                return CharacterSetElement.DIGIT;
            }
            case 'D': {
                return CharacterSetElement.NON_DIGIT;
            }
            case 's': {
                return CharacterSetElement.WHITESPACE;
            }
            case 'S': {
                return CharacterSetElement.NON_WHITESPACE;
            }
            case 'w': {
                return CharacterSetElement.WORD;
            }
            case 'W': {
                return CharacterSetElement.NON_WORD;
            }
        }
        if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z') {
            throw new RegExpException(4, this.pos - 2, this.pattern);
        }
        return new StringElement(this.fixChar(c));
    }

    private char fixChar(char c) {
        return this.ignoreCase ? Character.toLowerCase(c) : c;
    }

    private int readNumber() throws RegExpException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.peekChar(0);
        while (48 <= n && n <= 57) {
            stringBuffer.append(this.readChar());
            n = this.peekChar(0);
        }
        if (stringBuffer.length() <= 0) {
            throw new RegExpException(1, this.pos, this.pattern);
        }
        return Integer.parseInt(stringBuffer.toString());
    }

    private char readChar() throws RegExpException {
        int n = this.peekChar(0);
        if (n < 0) {
            throw new RegExpException(2, this.pos, this.pattern);
        }
        ++this.pos;
        return (char)n;
    }

    private char readChar(char c) throws RegExpException {
        if (c != this.readChar()) {
            throw new RegExpException(1, this.pos - 1, this.pattern);
        }
        return c;
    }

    private int peekChar(int n) {
        if (this.pos + n < this.pattern.length()) {
            return this.pattern.charAt(this.pos + n);
        }
        return -1;
    }

    private Element combineElements(ArrayList arrayList) {
        Element element;
        int n;
        Element element2 = (Element)arrayList.get(0);
        for (n = 1; n < arrayList.size(); ++n) {
            element = (Element)arrayList.get(n);
            if (element2 instanceof StringElement && element instanceof StringElement) {
                String string = ((StringElement)element2).getString() + ((StringElement)element).getString();
                element = new StringElement(string);
                arrayList.remove(n);
                arrayList.set(n - 1, element);
                --n;
            }
            element2 = element;
        }
        element = (Element)arrayList.get(arrayList.size() - 1);
        for (n = arrayList.size() - 2; n >= 0; --n) {
            element2 = (Element)arrayList.get(n);
            element = new CombineElement(element2, element);
        }
        return element;
    }
}

