/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser.re;

import java.io.IOException;
import java.io.StringReader;
import net.percederberg.grammatica.parser.ReaderBuffer;
import net.percederberg.grammatica.parser.re.Element;

public class Matcher {
    private Element element;
    private ReaderBuffer buffer;
    private boolean ignoreCase;
    private int start;
    private int length;
    private boolean endOfString;

    Matcher(Element element, ReaderBuffer readerBuffer, boolean bl) {
        this.element = element;
        this.buffer = readerBuffer;
        this.ignoreCase = bl;
        this.start = 0;
        this.reset();
    }

    public boolean isCaseInsensitive() {
        return this.ignoreCase;
    }

    public void reset() {
        this.length = -1;
        this.endOfString = false;
    }

    public void reset(String string) {
        this.reset(new ReaderBuffer(new StringReader(string)));
    }

    public void reset(ReaderBuffer readerBuffer) {
        this.buffer = readerBuffer;
        this.reset();
    }

    public int start() {
        return this.start;
    }

    public int end() {
        if (this.length > 0) {
            return this.start + this.length;
        }
        return this.start;
    }

    public int length() {
        return this.length;
    }

    public boolean hasReadEndOfString() {
        return this.endOfString;
    }

    void setReadEndOfString() {
        this.endOfString = true;
    }

    public boolean matchFromBeginning() throws IOException {
        return this.matchFrom(0);
    }

    public boolean matchFrom(int n) throws IOException {
        this.reset();
        this.start = n;
        this.length = this.element.match(this, this.buffer, this.start, 0);
        return this.length >= 0;
    }

    public String toString() {
        if (this.length <= 0) {
            return "";
        }
        int n = this.buffer.position();
        return this.buffer.subSequence(n, n + this.length).toString();
    }
}

