/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser.re;

import java.io.IOException;
import java.io.PrintWriter;
import net.percederberg.grammatica.parser.ReaderBuffer;
import net.percederberg.grammatica.parser.re.Element;
import net.percederberg.grammatica.parser.re.Matcher;
import net.percederberg.grammatica.parser.re.StringElement;

class CharacterSetElement
extends Element {
    public static final CharacterSetElement DOT = new CharacterSetElement(false){

        protected boolean inSet(char c) {
            switch (c) {
                case '\n': 
                case '\r': 
                case '\u0085': 
                case '\u2028': 
                case '\u2029': {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            return ".";
        }
    };
    public static final CharacterSetElement DIGIT = new CharacterSetElement(false){

        protected boolean inSet(char c) {
            return '0' <= c && c <= '9';
        }

        public String toString() {
            return "\\d";
        }
    };
    public static final CharacterSetElement NON_DIGIT = new CharacterSetElement(true){

        protected boolean inSet(char c) {
            return c < '0' || '9' < c;
        }

        public String toString() {
            return "\\D";
        }
    };
    public static final CharacterSetElement WHITESPACE = new CharacterSetElement(false){

        protected boolean inSet(char c) {
            switch (c) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return "\\s";
        }
    };
    public static final CharacterSetElement NON_WHITESPACE = new CharacterSetElement(true){

        protected boolean inSet(char c) {
            switch (c) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            return "\\S";
        }
    };
    public static final CharacterSetElement WORD = new CharacterSetElement(false){

        protected boolean inSet(char c) {
            return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '_';
        }

        public String toString() {
            return "\\w";
        }
    };
    public static final CharacterSetElement NON_WORD = new CharacterSetElement(true){

        protected boolean inSet(char c) {
            boolean bl = 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '_';
            return !bl;
        }

        public String toString() {
            return "\\W";
        }
    };
    private boolean inverted;
    private Object[] contents = new Object[0];

    public CharacterSetElement(boolean bl) {
        this.inverted = bl;
    }

    public void addCharacter(char c) {
        this.addContent(new Character(c));
    }

    public void addCharacters(String string) {
        for (int i = 0; i < string.length(); ++i) {
            this.addCharacter(string.charAt(i));
        }
    }

    public void addCharacters(StringElement stringElement) {
        this.addCharacters(stringElement.getString());
    }

    public void addRange(char c, char c2) {
        this.addContent(new Range(c, c2));
    }

    public void addCharacterSet(CharacterSetElement characterSetElement) {
        this.addContent(characterSetElement);
    }

    private void addContent(Object object) {
        Object[] objectArray = this.contents;
        this.contents = new Object[objectArray.length + 1];
        System.arraycopy(objectArray, 0, this.contents, 0, objectArray.length);
        this.contents[objectArray.length] = object;
    }

    public Object clone() {
        return this;
    }

    public int match(Matcher matcher, ReaderBuffer readerBuffer, int n, int n2) throws IOException {
        if (n2 != 0) {
            return -1;
        }
        int n3 = readerBuffer.peek(n);
        if (n3 < 0) {
            matcher.setReadEndOfString();
            return -1;
        }
        if (matcher.isCaseInsensitive()) {
            n3 = Character.toLowerCase((char)n3);
        }
        return this.inSet((char)n3) ? 1 : -1;
    }

    protected boolean inSet(char c) {
        for (int i = 0; i < this.contents.length; ++i) {
            CharacterSetElement characterSetElement;
            Range range;
            Character c2;
            Object object = this.contents[i];
            if (!(object instanceof Character ? (c2 = (Character)object).charValue() == c : (object instanceof Range ? (range = (Range)object).inside(c) : object instanceof CharacterSetElement && (characterSetElement = (CharacterSetElement)object).inSet(c)))) continue;
            return !this.inverted;
        }
        return this.inverted;
    }

    public void printTo(PrintWriter printWriter, String string) {
        printWriter.println(string + this.toString());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.inverted) {
            stringBuffer.append("[^");
        } else {
            stringBuffer.append("[");
        }
        for (int i = 0; i < this.contents.length; ++i) {
            stringBuffer.append(this.contents[i]);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private class Range {
        private char min;
        private char max;

        public Range(char c, char c2) {
            this.min = c;
            this.max = c2;
        }

        public boolean inside(char c) {
            return c >= this.min && c <= this.max;
        }

        public String toString() {
            return this.min + "-" + this.max;
        }
    }
}

