/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.regex.Pattern;
import net.percederberg.grammatica.parser.ParseException;
import net.percederberg.grammatica.parser.ParserCreationException;
import net.percederberg.grammatica.parser.ReaderBuffer;
import net.percederberg.grammatica.parser.Token;
import net.percederberg.grammatica.parser.TokenMatch;
import net.percederberg.grammatica.parser.TokenNFA;
import net.percederberg.grammatica.parser.TokenPattern;
import net.percederberg.grammatica.parser.TokenStringDFA;
import net.percederberg.grammatica.parser.re.Matcher;
import net.percederberg.grammatica.parser.re.RegExp;

public class Tokenizer {
    protected boolean ignoreCase = false;
    private boolean useTokenList = false;
    private StringDFAMatcher stringDfaMatcher = new StringDFAMatcher();
    private NFAMatcher nfaMatcher = new NFAMatcher();
    private RegExpMatcher regExpMatcher = new RegExpMatcher();
    private ReaderBuffer buffer = null;
    private TokenMatch lastMatch = new TokenMatch();
    private Token previousToken = null;

    public Tokenizer(Reader reader) {
        this(reader, false);
    }

    public Tokenizer(Reader reader, boolean bl) {
        this.buffer = new ReaderBuffer(reader);
        this.ignoreCase = bl;
    }

    public boolean getUseTokenList() {
        return this.useTokenList;
    }

    public void setUseTokenList(boolean bl) {
        this.useTokenList = bl;
    }

    public String getPatternDescription(int n) {
        TokenPattern tokenPattern = this.stringDfaMatcher.getPattern(n);
        if (tokenPattern == null) {
            tokenPattern = this.nfaMatcher.getPattern(n);
        }
        if (tokenPattern == null) {
            tokenPattern = this.regExpMatcher.getPattern(n);
        }
        return tokenPattern == null ? null : tokenPattern.toShortString();
    }

    public int getCurrentLine() {
        return this.buffer.lineNumber();
    }

    public int getCurrentColumn() {
        return this.buffer.columnNumber();
    }

    public void addPattern(TokenPattern tokenPattern) throws ParserCreationException {
        switch (tokenPattern.getType()) {
            case 1: {
                try {
                    this.stringDfaMatcher.addPattern(tokenPattern);
                    break;
                }
                catch (Exception exception) {
                    throw new ParserCreationException(2, tokenPattern.getName(), "error adding string token: " + exception.getMessage());
                }
            }
            case 2: {
                try {
                    this.nfaMatcher.addPattern(tokenPattern);
                    break;
                }
                catch (Exception exception) {
                    try {
                        this.regExpMatcher.addPattern(tokenPattern);
                        break;
                    }
                    catch (Exception exception2) {
                        throw new ParserCreationException(2, tokenPattern.getName(), "regular expression contains error(s): " + exception2.getMessage());
                    }
                }
            }
            default: {
                throw new ParserCreationException(2, tokenPattern.getName(), "pattern type " + tokenPattern.getType() + " is undefined");
            }
        }
    }

    public void reset(Reader reader) {
        this.buffer.dispose();
        this.buffer = new ReaderBuffer(reader);
        this.previousToken = null;
        this.lastMatch.clear();
    }

    public Token next() throws ParseException {
        Token token = null;
        do {
            if ((token = this.nextToken()) == null) {
                this.previousToken = null;
                return null;
            }
            if (this.useTokenList) {
                token.setPreviousToken(this.previousToken);
                this.previousToken = token;
            }
            if (token.getPattern().isIgnore()) {
                token = null;
                continue;
            }
            if (!token.getPattern().isError()) continue;
            throw new ParseException(5, token.getPattern().getErrorMessage(), token.getStartLine(), token.getStartColumn());
        } while (token == null);
        return token;
    }

    private Token nextToken() throws ParseException {
        try {
            this.lastMatch.clear();
            this.stringDfaMatcher.match(this.buffer, this.lastMatch);
            this.nfaMatcher.match(this.buffer, this.lastMatch);
            this.regExpMatcher.match(this.buffer, this.lastMatch);
            if (this.lastMatch.length() > 0) {
                int n = this.buffer.lineNumber();
                int n2 = this.buffer.columnNumber();
                String string = this.buffer.read(this.lastMatch.length());
                return this.newToken(this.lastMatch.pattern(), string, n, n2);
            }
            if (this.buffer.peek(0) < 0) {
                return null;
            }
            int n = this.buffer.lineNumber();
            int n3 = this.buffer.columnNumber();
            throw new ParseException(3, this.buffer.read(1), n, n3);
        }
        catch (IOException iOException) {
            throw new ParseException(1, iOException.getMessage(), -1, -1);
        }
    }

    protected Token newToken(TokenPattern tokenPattern, String string, int n, int n2) {
        return new Token(tokenPattern, string, n, n2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.stringDfaMatcher);
        stringBuffer.append(this.nfaMatcher);
        stringBuffer.append(this.regExpMatcher);
        return stringBuffer.toString();
    }

    class JavaRE
    extends RE {
        Pattern pattern;
        java.util.regex.Matcher matcher = null;

        public JavaRE(String string) throws Exception {
            this.pattern = Tokenizer.this.ignoreCase ? Pattern.compile(string, 2) : Pattern.compile(string);
        }

        public int match(ReaderBuffer readerBuffer) throws IOException {
            boolean bl;
            int n;
            int n2 = 1024;
            if (this.matcher == null) {
                this.matcher = this.pattern.matcher(readerBuffer);
            } else {
                this.matcher.reset(readerBuffer);
            }
            this.matcher.useTransparentBounds(true);
            do {
                n = readerBuffer.peek(n2);
                this.matcher.region(readerBuffer.position(), readerBuffer.length());
                bl = this.matcher.lookingAt();
                if (!this.matcher.hitEnd()) continue;
                n2 *= 2;
            } while (n >= 0 && this.matcher.hitEnd());
            return bl ? this.matcher.end() - this.matcher.start() : 0;
        }
    }

    class GrammaticaRE
    extends RE {
        private RegExp regExp;
        private Matcher matcher = null;

        public GrammaticaRE(String string) throws Exception {
            this.regExp = new RegExp(string, Tokenizer.this.ignoreCase);
        }

        public int match(ReaderBuffer readerBuffer) throws IOException {
            if (this.matcher == null) {
                this.matcher = this.regExp.matcher(readerBuffer);
            } else {
                this.matcher.reset(readerBuffer);
            }
            return this.matcher.matchFromBeginning() ? this.matcher.length() : 0;
        }
    }

    abstract class RE {
        RE() {
        }

        public abstract int match(ReaderBuffer var1) throws IOException;
    }

    class RegExpMatcher
    extends TokenMatcher {
        private RE[] regExps = new RE[0];

        RegExpMatcher() {
        }

        public void addPattern(TokenPattern tokenPattern) throws Exception {
            RE[] rEArray = this.regExps;
            JavaRE javaRE = new JavaRE(tokenPattern.getPattern());
            this.regExps = new RE[rEArray.length + 1];
            System.arraycopy(rEArray, 0, this.regExps, 0, rEArray.length);
            this.regExps[rEArray.length] = javaRE;
            tokenPattern.setDebugInfo("native Java regexp");
            super.addPattern(tokenPattern);
        }

        public void match(ReaderBuffer readerBuffer, TokenMatch tokenMatch) throws IOException {
            for (int i = 0; i < this.regExps.length; ++i) {
                int n = this.regExps[i].match(readerBuffer);
                if (n <= 0) continue;
                tokenMatch.update(n, this.patterns[i]);
            }
        }
    }

    class NFAMatcher
    extends TokenMatcher {
        private TokenNFA automaton = new TokenNFA();

        NFAMatcher() {
        }

        public void addPattern(TokenPattern tokenPattern) throws Exception {
            if (tokenPattern.getType() == 1) {
                this.automaton.addTextMatch(tokenPattern.getPattern(), Tokenizer.this.ignoreCase, tokenPattern);
            } else {
                this.automaton.addRegExpMatch(tokenPattern.getPattern(), Tokenizer.this.ignoreCase, tokenPattern);
            }
            super.addPattern(tokenPattern);
        }

        public void match(ReaderBuffer readerBuffer, TokenMatch tokenMatch) throws IOException {
            this.automaton.match(readerBuffer, tokenMatch);
        }
    }

    class StringDFAMatcher
    extends TokenMatcher {
        private TokenStringDFA automaton = new TokenStringDFA();

        StringDFAMatcher() {
        }

        public void addPattern(TokenPattern tokenPattern) throws Exception {
            this.automaton.addMatch(tokenPattern.getPattern(), Tokenizer.this.ignoreCase, tokenPattern);
            super.addPattern(tokenPattern);
        }

        public void match(ReaderBuffer readerBuffer, TokenMatch tokenMatch) throws IOException {
            TokenPattern tokenPattern = this.automaton.match(readerBuffer, Tokenizer.this.ignoreCase);
            if (tokenPattern != null) {
                tokenMatch.update(tokenPattern.getPattern().length(), tokenPattern);
            }
        }
    }

    abstract class TokenMatcher {
        protected TokenPattern[] patterns = new TokenPattern[0];

        TokenMatcher() {
        }

        public abstract void match(ReaderBuffer var1, TokenMatch var2) throws IOException;

        public TokenPattern getPattern(int n) {
            for (int i = 0; i < this.patterns.length; ++i) {
                if (this.patterns[i].getId() != n) continue;
                return this.patterns[i];
            }
            return null;
        }

        public void addPattern(TokenPattern tokenPattern) throws Exception {
            TokenPattern[] tokenPatternArray = this.patterns;
            this.patterns = new TokenPattern[tokenPatternArray.length + 1];
            System.arraycopy(tokenPatternArray, 0, this.patterns, 0, tokenPatternArray.length);
            this.patterns[tokenPatternArray.length] = tokenPattern;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.patterns.length; ++i) {
                stringBuffer.append(this.patterns[i]);
                stringBuffer.append("\n\n");
            }
            return stringBuffer.toString();
        }
    }
}

