/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

import java.io.IOException;
import net.percederberg.grammatica.parser.ReaderBuffer;
import net.percederberg.grammatica.parser.TokenPattern;

class TokenStringDFA {
    private State[] ascii = new State[128];
    private State nonAscii = new State();

    TokenStringDFA() {
    }

    public void addMatch(String string, boolean bl, TokenPattern tokenPattern) {
        State state;
        char c = string.charAt(0);
        int n = 0;
        if (bl) {
            c = Character.toLowerCase(c);
        }
        if (c < '\u0080') {
            state = this.ascii[c];
            if (state == null) {
                state = this.ascii[c] = new State();
            }
            ++n;
        } else {
            state = this.nonAscii;
        }
        for (int i = n; i < string.length(); ++i) {
            State state2 = state.tree.find(string.charAt(i), bl);
            if (state2 == null) {
                state2 = new State();
                state.tree.add(string.charAt(i), bl, state2);
            }
            state = state2;
        }
        state.value = tokenPattern;
    }

    public TokenPattern match(ReaderBuffer readerBuffer, boolean bl) throws IOException {
        State state;
        TokenPattern tokenPattern = null;
        int n = 0;
        int n2 = readerBuffer.peek(0);
        if (n2 < 0) {
            return null;
        }
        if (bl) {
            n2 = Character.toLowerCase(n2);
        }
        if (n2 < 128) {
            state = this.ascii[n2];
            if (state == null) {
                return null;
            }
            if (state.value != null) {
                tokenPattern = state.value;
            }
            ++n;
        } else {
            state = this.nonAscii;
        }
        while ((n2 = readerBuffer.peek(n)) >= 0 && (state = state.tree.find((char)n2, bl)) != null) {
            if (state.value != null) {
                tokenPattern = state.value;
            }
            ++n;
        }
        return tokenPattern;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.ascii.length; ++i) {
            if (this.ascii[i] == null) continue;
            stringBuffer.append((char)i);
            if (this.ascii[i].value != null) {
                stringBuffer.append(": ");
                stringBuffer.append(this.ascii[i].value);
                stringBuffer.append("\n");
            }
            this.ascii[i].tree.printTo(stringBuffer, " ");
        }
        this.nonAscii.tree.printTo(stringBuffer, "");
        return stringBuffer.toString();
    }

    class TransitionTree {
        private char value = '\u0000';
        private State state = null;
        private TransitionTree left = null;
        private TransitionTree right = null;

        TransitionTree() {
        }

        public State find(char c, boolean bl) {
            if (bl) {
                c = Character.toLowerCase(c);
            }
            if (this.value == '\u0000' || this.value == c) {
                return this.state;
            }
            if (this.value > c) {
                return this.left.find(c, false);
            }
            return this.right.find(c, false);
        }

        public void add(char c, boolean bl, State state) {
            if (bl) {
                c = Character.toLowerCase(c);
            }
            if (this.value == '\u0000') {
                this.value = c;
                this.state = state;
                this.left = new TransitionTree();
                this.right = new TransitionTree();
            } else if (this.value > c) {
                this.left.add(c, false, state);
            } else {
                this.right.add(c, false, state);
            }
        }

        public void printTo(StringBuffer stringBuffer, String string) {
            if (this.left != null) {
                this.left.printTo(stringBuffer, string);
            }
            if (this.value != '\u0000') {
                if (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) == '\n') {
                    stringBuffer.append(string);
                }
                stringBuffer.append(this.value);
                if (this.state.value != null) {
                    stringBuffer.append(": ");
                    stringBuffer.append(this.state.value);
                    stringBuffer.append("\n");
                }
                this.state.tree.printTo(stringBuffer, string + " ");
            }
            if (this.right != null) {
                this.right.printTo(stringBuffer, string);
            }
        }
    }

    class State {
        protected TokenPattern value = null;
        protected TransitionTree tree = new TransitionTree();

        State() {
        }
    }
}

