/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

import java.util.HashMap;
import net.percederberg.grammatica.parser.TokenNFA;
import net.percederberg.grammatica.parser.re.RegExpException;

class TokenRegExpParser {
    private String pattern;
    private boolean ignoreCase;
    private int pos;
    protected TokenNFA.State start = new TokenNFA.State();
    protected TokenNFA.State end = null;
    private int stateCount = 0;
    private int transitionCount = 0;
    private int epsilonCount = 0;

    public TokenRegExpParser(String string) throws RegExpException {
        this(string, false);
    }

    public TokenRegExpParser(String string, boolean bl) throws RegExpException {
        this.pattern = string;
        this.ignoreCase = bl;
        this.pos = 0;
        this.end = this.parseExpr(this.start);
        if (this.pos < string.length()) {
            throw new RegExpException(1, this.pos, string);
        }
    }

    public String getDebugInfo() {
        if (this.stateCount == 0) {
            this.updateStats(this.start, new HashMap());
        }
        return this.stateCount + " states, " + this.transitionCount + " transitions, " + this.epsilonCount + " epsilons";
    }

    private void updateStats(TokenNFA.State state, HashMap hashMap) {
        if (!hashMap.containsKey(state)) {
            hashMap.put(state, null);
            ++this.stateCount;
            for (int i = 0; i < state.outgoing.length; ++i) {
                ++this.transitionCount;
                if (state.outgoing[i] instanceof TokenNFA.EpsilonTransition) {
                    ++this.epsilonCount;
                }
                this.updateStats(state.outgoing[i].state, hashMap);
            }
        }
    }

    private TokenNFA.State parseExpr(TokenNFA.State state) throws RegExpException {
        TokenNFA.State state2 = new TokenNFA.State();
        do {
            if (this.peekChar(0) == 124) {
                this.readChar('|');
            }
            TokenNFA.State state3 = new TokenNFA.State();
            TokenNFA.State state4 = this.parseTerm(state3);
            if (state3.incoming.length == 0) {
                state3.mergeInto(state);
            } else {
                state.addOut(new TokenNFA.EpsilonTransition(state3));
            }
            if (state4.outgoing.length == 0 || !state2.hasTransitions() && this.peekChar(0) != 124) {
                state4.mergeInto(state2);
                continue;
            }
            state4.addOut(new TokenNFA.EpsilonTransition(state2));
        } while (this.peekChar(0) == 124);
        return state2;
    }

    private TokenNFA.State parseTerm(TokenNFA.State state) throws RegExpException {
        TokenNFA.State state2 = this.parseFact(state);
        while (true) {
            switch (this.peekChar(0)) {
                case -1: 
                case 41: 
                case 43: 
                case 63: 
                case 93: 
                case 123: 
                case 124: 
                case 125: {
                    return state2;
                }
            }
            state2 = this.parseFact(state2);
        }
    }

    private TokenNFA.State parseFact(TokenNFA.State state) throws RegExpException {
        TokenNFA.State state2 = new TokenNFA.State();
        TokenNFA.State state3 = this.parseAtom(state2);
        switch (this.peekChar(0)) {
            case 42: 
            case 43: 
            case 63: 
            case 123: {
                state3 = this.parseAtomModifier(state2, state3);
            }
        }
        if (state2.incoming.length > 0 && state.outgoing.length > 0) {
            state.addOut(new TokenNFA.EpsilonTransition(state2));
            return state3;
        }
        state2.mergeInto(state);
        return state3 == state2 ? state : state3;
    }

    private TokenNFA.State parseAtom(TokenNFA.State state) throws RegExpException {
        switch (this.peekChar(0)) {
            case 46: {
                this.readChar('.');
                return state.addOut(new TokenNFA.DotTransition(new TokenNFA.State()));
            }
            case 40: {
                this.readChar('(');
                TokenNFA.State state2 = this.parseExpr(state);
                this.readChar(')');
                return state2;
            }
            case 91: {
                this.readChar('[');
                TokenNFA.State state3 = this.parseCharSet(state);
                this.readChar(']');
                return state3;
            }
            case -1: 
            case 41: 
            case 42: 
            case 43: 
            case 63: 
            case 93: 
            case 123: 
            case 124: 
            case 125: {
                throw new RegExpException(1, this.pos, this.pattern);
            }
        }
        return this.parseChar(state);
    }

    private TokenNFA.State parseAtomModifier(TokenNFA.State state, TokenNFA.State state2) throws RegExpException {
        int n = 0;
        int n2 = -1;
        int n3 = this.pos;
        switch (this.readChar()) {
            case '?': {
                n = 0;
                n2 = 1;
                break;
            }
            case '*': {
                n = 0;
                n2 = -1;
                break;
            }
            case '+': {
                n = 1;
                n2 = -1;
                break;
            }
            case '{': {
                n2 = n = this.readNumber();
                if (this.peekChar(0) == 44) {
                    this.readChar(',');
                    n2 = -1;
                    if (this.peekChar(0) != 125) {
                        n2 = this.readNumber();
                    }
                }
                this.readChar('}');
                if (n2 != 0 && (n2 <= 0 || n <= n2)) break;
                throw new RegExpException(5, n3, this.pattern);
            }
            default: {
                throw new RegExpException(1, this.pos - 1, this.pattern);
            }
        }
        if (this.peekChar(0) == 63) {
            throw new RegExpException(3, this.pos, this.pattern);
        }
        if (this.peekChar(0) == 43) {
            throw new RegExpException(3, this.pos, this.pattern);
        }
        if (n == 0 && n2 == 1) {
            return state.addOut(new TokenNFA.EpsilonTransition(state2));
        }
        if (n == 0 && n2 == -1) {
            if (state2.outgoing.length == 0) {
                state2.mergeInto(state);
            } else {
                state2.addOut(new TokenNFA.EpsilonTransition(state));
            }
            return state;
        }
        if (n == 1 && n2 == -1) {
            if (state.outgoing.length == 1 && state2.outgoing.length == 0 && state2.incoming.length == 1 && state.outgoing[0] == state2.incoming[0]) {
                state2.addOut(state.outgoing[0].copy(state2));
            } else {
                state2.addOut(new TokenNFA.EpsilonTransition(state));
            }
            return state2;
        }
        throw new RegExpException(5, n3, this.pattern);
    }

    private TokenNFA.State parseCharSet(TokenNFA.State state) throws RegExpException {
        TokenNFA.CharRangeTransition charRangeTransition;
        TokenNFA.State state2 = new TokenNFA.State();
        if (this.peekChar(0) == 94) {
            this.readChar('^');
            charRangeTransition = new TokenNFA.CharRangeTransition(true, this.ignoreCase, state2);
        } else {
            charRangeTransition = new TokenNFA.CharRangeTransition(false, this.ignoreCase, state2);
        }
        state.addOut(charRangeTransition);
        block4: while (this.peekChar(0) > 0) {
            char c = (char)this.peekChar(0);
            switch (c) {
                case ']': {
                    return state2;
                }
                case '\\': {
                    charRangeTransition.addCharacter(this.readEscapeChar());
                    continue block4;
                }
            }
            this.readChar(c);
            if (this.peekChar(0) == 45 && this.peekChar(1) > 0 && this.peekChar(1) != 93) {
                this.readChar('-');
                char c2 = this.readChar();
                charRangeTransition.addRange(c, c2);
                continue;
            }
            charRangeTransition.addCharacter(c);
        }
        return state2;
    }

    private TokenNFA.State parseChar(TokenNFA.State state) throws RegExpException {
        switch (this.peekChar(0)) {
            case 92: {
                return this.parseEscapeChar(state);
            }
            case 36: 
            case 94: {
                throw new RegExpException(3, this.pos, this.pattern);
            }
        }
        return state.addOut(this.readChar(), this.ignoreCase, new TokenNFA.State());
    }

    private TokenNFA.State parseEscapeChar(TokenNFA.State state) throws RegExpException {
        TokenNFA.State state2 = new TokenNFA.State();
        if (this.peekChar(0) == 92 && this.peekChar(1) > 0) {
            switch ((char)this.peekChar(1)) {
                case 'd': {
                    this.readChar();
                    this.readChar();
                    return state.addOut(new TokenNFA.DigitTransition(state2));
                }
                case 'D': {
                    this.readChar();
                    this.readChar();
                    return state.addOut(new TokenNFA.NonDigitTransition(state2));
                }
                case 's': {
                    this.readChar();
                    this.readChar();
                    return state.addOut(new TokenNFA.WhitespaceTransition(state2));
                }
                case 'S': {
                    this.readChar();
                    this.readChar();
                    return state.addOut(new TokenNFA.NonWhitespaceTransition(state2));
                }
                case 'w': {
                    this.readChar();
                    this.readChar();
                    return state.addOut(new TokenNFA.WordTransition(state2));
                }
                case 'W': {
                    this.readChar();
                    this.readChar();
                    return state.addOut(new TokenNFA.NonWordTransition(state2));
                }
            }
        }
        return state.addOut(this.readEscapeChar(), this.ignoreCase, state2);
    }

    private char readEscapeChar() throws RegExpException {
        this.readChar('\\');
        char c = this.readChar();
        switch (c) {
            case '0': {
                c = this.readChar();
                if (c < '0' || c > '3') {
                    throw new RegExpException(4, this.pos - 3, this.pattern);
                }
                String string = String.valueOf(c);
                c = (char)this.peekChar(0);
                if ('0' <= c && c <= '7') {
                    string = string + String.valueOf(this.readChar());
                    c = (char)this.peekChar(0);
                    if ('0' <= c && c <= '7') {
                        string = string + String.valueOf(this.readChar());
                    }
                }
                try {
                    return (char)Integer.parseInt(string, 8);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new RegExpException(4, this.pos - string.length() - 2, this.pattern);
                }
            }
            case 'x': {
                String string = String.valueOf(this.readChar()) + String.valueOf(this.readChar());
                try {
                    return (char)Integer.parseInt(string, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new RegExpException(4, this.pos - string.length() - 2, this.pattern);
                }
            }
            case 'u': {
                String string = String.valueOf(this.readChar()) + String.valueOf(this.readChar()) + String.valueOf(this.readChar()) + String.valueOf(this.readChar());
                try {
                    return (char)Integer.parseInt(string, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new RegExpException(4, this.pos - string.length() - 2, this.pattern);
                }
            }
            case 't': {
                return '\t';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 'f': {
                return '\f';
            }
            case 'a': {
                return '\u0007';
            }
            case 'e': {
                return '\u001b';
            }
        }
        if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z') {
            throw new RegExpException(4, this.pos - 2, this.pattern);
        }
        return c;
    }

    private int readNumber() throws RegExpException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.peekChar(0);
        while (48 <= n && n <= 57) {
            stringBuffer.append(this.readChar());
            n = this.peekChar(0);
        }
        if (stringBuffer.length() <= 0) {
            throw new RegExpException(1, this.pos, this.pattern);
        }
        return Integer.parseInt(stringBuffer.toString());
    }

    private char readChar() throws RegExpException {
        int n = this.peekChar(0);
        if (n < 0) {
            throw new RegExpException(2, this.pos, this.pattern);
        }
        ++this.pos;
        return (char)n;
    }

    private char readChar(char c) throws RegExpException {
        if (c != this.readChar()) {
            throw new RegExpException(1, this.pos - 1, this.pattern);
        }
        return c;
    }

    private int peekChar(int n) {
        if (this.pos + n < this.pattern.length()) {
            return this.pattern.charAt(this.pos + n);
        }
        return -1;
    }
}

