/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

public class TokenPattern {
    public static final int STRING_TYPE = 1;
    public static final int REGEXP_TYPE = 2;
    private int id;
    private String name;
    private int type;
    private String pattern;
    private boolean error = false;
    private String errorMessage = null;
    private boolean ignore = false;
    private String ignoreMessage = null;
    private String debugInfo = null;

    public TokenPattern(int n, String string, int n2, String string2) {
        this.id = n;
        this.name = string;
        this.type = n2;
        this.pattern = string2;
    }

    public boolean isError() {
        return this.error;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getIgnoreMessage() {
        return this.ignoreMessage;
    }

    public String getDebugInfo() {
        return this.debugInfo;
    }

    public void setError() {
        this.setError("unrecognized token found");
    }

    public void setError(String string) {
        this.error = true;
        this.errorMessage = string;
    }

    public void setIgnore() {
        this.setIgnore(null);
    }

    public void setIgnore(String string) {
        this.ignore = true;
        this.ignoreMessage = string;
    }

    public void setDebugInfo(String string) {
        this.debugInfo = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name);
        stringBuffer.append(" (");
        stringBuffer.append(this.id);
        stringBuffer.append(") = ");
        if (this.type == 1) {
            stringBuffer.append("\"");
            stringBuffer.append(this.pattern);
            stringBuffer.append("\"");
        } else if (this.type == 2) {
            stringBuffer.append("<<");
            stringBuffer.append(this.pattern);
            stringBuffer.append(">>");
        }
        if (this.error) {
            stringBuffer.append(" ERROR: \"");
            stringBuffer.append(this.errorMessage);
            stringBuffer.append("\"");
        }
        if (this.ignore) {
            stringBuffer.append(" IGNORE");
            if (this.ignoreMessage != null) {
                stringBuffer.append(": \"");
                stringBuffer.append(this.ignoreMessage);
                stringBuffer.append("\"");
            }
        }
        if (this.debugInfo != null) {
            stringBuffer.append("\n  ");
            stringBuffer.append(this.debugInfo);
        }
        return stringBuffer.toString();
    }

    public String toShortString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.pattern.indexOf(10);
        if (this.type == 1) {
            stringBuffer.append("\"");
            if (n >= 0) {
                if (n > 0 && this.pattern.charAt(n - 1) == '\r') {
                    --n;
                }
                stringBuffer.append(this.pattern.substring(0, n));
                stringBuffer.append("(...)");
            } else {
                stringBuffer.append(this.pattern);
            }
            stringBuffer.append("\"");
        } else {
            stringBuffer.append("<");
            stringBuffer.append(this.name);
            stringBuffer.append(">");
        }
        return stringBuffer.toString();
    }
}

