/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

import java.io.IOException;
import net.percederberg.grammatica.parser.ReaderBuffer;
import net.percederberg.grammatica.parser.TokenMatch;
import net.percederberg.grammatica.parser.TokenPattern;
import net.percederberg.grammatica.parser.TokenRegExpParser;
import net.percederberg.grammatica.parser.re.RegExpException;

class TokenNFA {
    private State[] initialChar = new State[128];
    private State initial = new State();
    private StateQueue queue = new StateQueue();

    TokenNFA() {
    }

    public void addTextMatch(String string, boolean bl, TokenPattern tokenPattern) {
        State state;
        char c = string.charAt(0);
        if (c < '\u0080' && !bl) {
            state = this.initialChar[c];
            if (state == null) {
                state = this.initialChar[c] = new State();
            }
        } else {
            state = this.initial.addOut(c, bl, null);
        }
        for (int i = 1; i < string.length(); ++i) {
            state = state.addOut(string.charAt(i), bl, null);
        }
        state.value = tokenPattern;
    }

    public void addRegExpMatch(String string, boolean bl, TokenPattern tokenPattern) throws RegExpException {
        int n;
        int n2;
        TokenRegExpParser tokenRegExpParser = new TokenRegExpParser(string, bl);
        String string2 = "DFA regexp; " + tokenRegExpParser.getDebugInfo();
        boolean bl2 = tokenRegExpParser.start.isAsciiOutgoing();
        for (n2 = 0; bl2 && n2 < 128; ++n2) {
            n = 0;
            for (int i = 0; i < tokenRegExpParser.start.outgoing.length; ++i) {
                if (!tokenRegExpParser.start.outgoing[i].match((char)n2)) continue;
                if (n != 0) {
                    bl2 = false;
                    break;
                }
                n = 1;
            }
            if (n == 0 || this.initialChar[n2] == null) continue;
            bl2 = false;
        }
        if (tokenRegExpParser.start.incoming.length > 0) {
            this.initial.addOut(new EpsilonTransition(tokenRegExpParser.start));
            string2 = string2 + ", uses initial epsilon";
        } else if (bl2 && !bl) {
            for (n2 = 0; bl2 && n2 < 128; ++n2) {
                for (n = 0; n < tokenRegExpParser.start.outgoing.length; ++n) {
                    if (!tokenRegExpParser.start.outgoing[n].match((char)n2)) continue;
                    this.initialChar[n2] = tokenRegExpParser.start.outgoing[n].state;
                }
            }
            string2 = string2 + ", uses ASCII lookup";
        } else {
            tokenRegExpParser.start.mergeInto(this.initial);
            string2 = string2 + ", uses initial state";
        }
        tokenRegExpParser.end.value = tokenPattern;
        tokenPattern.setDebugInfo(string2);
    }

    public int match(ReaderBuffer readerBuffer, TokenMatch tokenMatch) throws IOException {
        State state;
        int n = 0;
        int n2 = 1;
        this.queue.clear();
        int n3 = readerBuffer.peek(0);
        if (0 <= n3 && n3 < 128 && (state = this.initialChar[n3]) != null) {
            this.queue.addLast(state);
        }
        if (n3 >= 0) {
            this.initial.matchTransitions((char)n3, this.queue, true);
        }
        this.queue.markEnd();
        n3 = readerBuffer.peek(1);
        while (!this.queue.isEmpty()) {
            if (this.queue.isMarked()) {
                n3 = readerBuffer.peek(++n2);
                this.queue.markEnd();
            }
            state = this.queue.removeFirst();
            if (state.value != null) {
                tokenMatch.update(n2, state.value);
            }
            if (n3 < 0) continue;
            state.matchTransitions((char)n3, this.queue, false);
        }
        return n;
    }

    protected static class StateQueue {
        private State[] queue = new State[2048];
        private int first = 0;
        private int last = 0;
        private int mark = 0;

        protected StateQueue() {
        }

        public boolean isEmpty() {
            return this.last <= this.first;
        }

        public boolean isMarked() {
            return this.first == this.mark;
        }

        public void clear() {
            this.first = 0;
            this.last = 0;
            this.mark = 0;
        }

        public void markEnd() {
            this.mark = this.last;
        }

        public State removeFirst() {
            if (this.first < this.last) {
                ++this.first;
                return this.queue[this.first - 1];
            }
            return null;
        }

        public void addLast(State state) {
            if (this.last >= this.queue.length) {
                if (this.first <= 0) {
                    State[] stateArray = this.queue;
                    this.queue = new State[stateArray.length * 2];
                    System.arraycopy(stateArray, 0, this.queue, 0, stateArray.length);
                } else {
                    System.arraycopy(this.queue, this.first, this.queue, 0, this.last - this.first);
                    this.last -= this.first;
                    this.mark -= this.first;
                    this.first = 0;
                }
            }
            this.queue[this.last++] = state;
        }
    }

    protected static class NonWordTransition
    extends Transition {
        public NonWordTransition(State state) {
            super(state);
        }

        public boolean isAscii() {
            return false;
        }

        public boolean match(char c) {
            boolean bl = 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '_';
            return !bl;
        }

        public Transition copy(State state) {
            return new NonWordTransition(state);
        }
    }

    protected static class WordTransition
    extends Transition {
        public WordTransition(State state) {
            super(state);
        }

        public boolean isAscii() {
            return true;
        }

        public boolean match(char c) {
            return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '_';
        }

        public Transition copy(State state) {
            return new WordTransition(state);
        }
    }

    protected static class NonWhitespaceTransition
    extends Transition {
        public NonWhitespaceTransition(State state) {
            super(state);
        }

        public boolean isAscii() {
            return false;
        }

        public boolean match(char c) {
            switch (c) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': {
                    return false;
                }
            }
            return true;
        }

        public Transition copy(State state) {
            return new NonWhitespaceTransition(state);
        }
    }

    protected static class WhitespaceTransition
    extends Transition {
        public WhitespaceTransition(State state) {
            super(state);
        }

        public boolean isAscii() {
            return true;
        }

        public boolean match(char c) {
            switch (c) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': {
                    return true;
                }
            }
            return false;
        }

        public Transition copy(State state) {
            return new WhitespaceTransition(state);
        }
    }

    protected static class NonDigitTransition
    extends Transition {
        public NonDigitTransition(State state) {
            super(state);
        }

        public boolean isAscii() {
            return false;
        }

        public boolean match(char c) {
            return c < '0' || '9' < c;
        }

        public Transition copy(State state) {
            return new NonDigitTransition(state);
        }
    }

    protected static class DigitTransition
    extends Transition {
        public DigitTransition(State state) {
            super(state);
        }

        public boolean isAscii() {
            return true;
        }

        public boolean match(char c) {
            return '0' <= c && c <= '9';
        }

        public Transition copy(State state) {
            return new DigitTransition(state);
        }
    }

    protected static class DotTransition
    extends Transition {
        public DotTransition(State state) {
            super(state);
        }

        public boolean isAscii() {
            return false;
        }

        public boolean match(char c) {
            switch (c) {
                case '\n': 
                case '\r': 
                case '\u0085': 
                case '\u2028': 
                case '\u2029': {
                    return false;
                }
            }
            return true;
        }

        public Transition copy(State state) {
            return new DotTransition(state);
        }
    }

    protected static class CharRangeTransition
    extends Transition {
        protected boolean inverse;
        protected boolean ignoreCase;
        private Object[] contents = new Object[0];

        public CharRangeTransition(boolean bl, boolean bl2, State state) {
            super(state);
            this.inverse = bl;
            this.ignoreCase = bl2;
        }

        public boolean isAscii() {
            if (this.inverse) {
                return false;
            }
            for (int i = 0; i < this.contents.length; ++i) {
                Character c;
                Object object = this.contents[i];
                if (!(object instanceof Character ? (c = (Character)object).charValue() < '\u0000' || '\u0080' <= c.charValue() : object instanceof Range && !((Range)object).isAscii())) continue;
                return false;
            }
            return true;
        }

        public void addCharacter(char c) {
            if (this.ignoreCase) {
                c = Character.toLowerCase(c);
            }
            this.addContent(new Character(c));
        }

        public void addRange(char c, char c2) {
            if (this.ignoreCase) {
                c = Character.toLowerCase(c);
                c2 = Character.toLowerCase(c2);
            }
            this.addContent(new Range(c, c2));
        }

        private void addContent(Object object) {
            Object[] objectArray = this.contents;
            this.contents = new Object[objectArray.length + 1];
            System.arraycopy(objectArray, 0, this.contents, 0, objectArray.length);
            this.contents[objectArray.length] = object;
        }

        public boolean match(char c) {
            if (this.ignoreCase) {
                c = Character.toLowerCase(c);
            }
            for (int i = 0; i < this.contents.length; ++i) {
                Range range;
                Character c2;
                Object object = this.contents[i];
                if (!(object instanceof Character ? (c2 = (Character)object).charValue() == c : object instanceof Range && (range = (Range)object).inside(c))) continue;
                return !this.inverse;
            }
            return this.inverse;
        }

        public Transition copy(State state) {
            CharRangeTransition charRangeTransition = new CharRangeTransition(this.inverse, this.ignoreCase, state);
            charRangeTransition.contents = this.contents;
            return charRangeTransition;
        }

        private class Range {
            private char min;
            private char max;

            public Range(char c, char c2) {
                this.min = c;
                this.max = c2;
            }

            public boolean isAscii() {
                return '\u0000' <= this.min && this.min < '\u0080' && '\u0000' <= this.max && this.max < '\u0080';
            }

            public boolean inside(char c) {
                return this.min <= c && c <= this.max;
            }
        }
    }

    protected static class CharTransition
    extends Transition {
        protected char match;

        public CharTransition(char c, State state) {
            super(state);
            this.match = c;
        }

        public boolean isAscii() {
            return '\u0000' <= this.match && this.match < '\u0080';
        }

        public boolean match(char c) {
            return this.match == c;
        }

        public Transition copy(State state) {
            return new CharTransition(this.match, state);
        }
    }

    protected static class EpsilonTransition
    extends Transition {
        public EpsilonTransition(State state) {
            super(state);
        }

        public boolean isAscii() {
            return false;
        }

        public boolean match(char c) {
            return false;
        }

        public Transition copy(State state) {
            return new EpsilonTransition(state);
        }
    }

    protected static abstract class Transition {
        protected State state;

        public Transition(State state) {
            this.state = state;
            this.state.addIn(this);
        }

        public abstract boolean isAscii();

        public abstract boolean match(char var1);

        public abstract Transition copy(State var1);
    }

    protected static class State {
        protected TokenPattern value = null;
        protected Transition[] incoming = new Transition[0];
        protected Transition[] outgoing = new Transition[0];
        protected boolean epsilonOut = false;

        protected State() {
        }

        public boolean hasTransitions() {
            return this.incoming.length > 0 || this.outgoing.length > 0;
        }

        public boolean isAsciiOutgoing() {
            for (int i = 0; i < this.outgoing.length; ++i) {
                if (this.outgoing[i].isAscii()) continue;
                return false;
            }
            return true;
        }

        public void addIn(Transition transition) {
            Transition[] transitionArray = this.incoming;
            this.incoming = new Transition[transitionArray.length + 1];
            System.arraycopy(transitionArray, 0, this.incoming, 0, transitionArray.length);
            this.incoming[transitionArray.length] = transition;
        }

        public State addOut(char c, boolean bl, State state) {
            if (bl) {
                if (state == null) {
                    state = new State();
                }
                this.addOut(new CharTransition(Character.toLowerCase(c), state));
                this.addOut(new CharTransition(Character.toUpperCase(c), state));
                return state;
            }
            if (state == null) {
                state = this.findUniqueCharTransition(c);
                if (state != null) {
                    return state;
                }
                state = new State();
            }
            return this.addOut(new CharTransition(c, state));
        }

        public State addOut(Transition transition) {
            Transition[] transitionArray = this.outgoing;
            this.outgoing = new Transition[transitionArray.length + 1];
            System.arraycopy(transitionArray, 0, this.outgoing, 0, transitionArray.length);
            this.outgoing[transitionArray.length] = transition;
            if (transition instanceof EpsilonTransition) {
                this.epsilonOut = true;
            }
            return transition.state;
        }

        public void mergeInto(State state) {
            int n;
            for (n = 0; n < this.incoming.length; ++n) {
                state.addIn(this.incoming[n]);
                this.incoming[n].state = state;
            }
            this.incoming = null;
            for (n = 0; n < this.outgoing.length; ++n) {
                state.addOut(this.outgoing[n]);
            }
            this.outgoing = null;
        }

        private State findUniqueCharTransition(char c) {
            Transition transition;
            int n;
            Transition transition2 = null;
            for (n = 0; n < this.outgoing.length; ++n) {
                transition = this.outgoing[n];
                if (!transition.match(c) || !(transition instanceof CharTransition)) continue;
                if (transition2 != null) {
                    return null;
                }
                transition2 = transition;
            }
            for (n = 0; transition2 != null && n < this.outgoing.length; ++n) {
                transition = this.outgoing[n];
                if (transition == transition2 || transition.state != transition2.state) continue;
                return null;
            }
            return transition2 == null ? null : transition2.state;
        }

        public void matchTransitions(char c, StateQueue stateQueue, boolean bl) {
            for (int i = 0; i < this.outgoing.length; ++i) {
                Transition transition = this.outgoing[i];
                State state = transition.state;
                if (bl && transition instanceof EpsilonTransition) {
                    state.matchTransitions(c, stateQueue, true);
                    continue;
                }
                if (!transition.match(c)) continue;
                stateQueue.addLast(state);
                if (!state.epsilonOut) continue;
                state.matchEmpty(stateQueue);
            }
        }

        public void matchEmpty(StateQueue stateQueue) {
            for (int i = 0; i < this.outgoing.length; ++i) {
                Transition transition = this.outgoing[i];
                if (!(transition instanceof EpsilonTransition)) continue;
                State state = transition.state;
                stateQueue.addLast(state);
                if (!state.epsilonOut) continue;
                state.matchEmpty(stateQueue);
            }
        }
    }
}

