/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

import net.percederberg.grammatica.parser.Node;
import net.percederberg.grammatica.parser.TokenPattern;

public class Token
extends Node {
    private TokenPattern pattern;
    private String image;
    private int startLine;
    private int startColumn;
    private int endLine;
    private int endColumn;
    private Token previous = null;
    private Token next = null;

    public Token(TokenPattern tokenPattern, String string, int n, int n2) {
        this.pattern = tokenPattern;
        this.image = string;
        this.startLine = n;
        this.startColumn = n2;
        this.endLine = n;
        this.endColumn = n2 + string.length() - 1;
        int n3 = 0;
        while (string.indexOf(10, n3) >= 0) {
            n3 = string.indexOf(10, n3) + 1;
            ++this.endLine;
            this.endColumn = string.length() - n3;
        }
    }

    public int getId() {
        return this.pattern.getId();
    }

    public String getName() {
        return this.pattern.getName();
    }

    public String getImage() {
        return this.image;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    TokenPattern getPattern() {
        return this.pattern;
    }

    public Token getPreviousToken() {
        return this.previous;
    }

    void setPreviousToken(Token token) {
        if (this.previous != null) {
            this.previous.next = null;
        }
        this.previous = token;
        if (token != null) {
            token.next = this;
        }
    }

    public Token getNextToken() {
        return this.next;
    }

    void setNextToken(Token token) {
        if (this.next != null) {
            this.next.previous = null;
        }
        this.next = token;
        if (token != null) {
            token.previous = this;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.pattern.getName());
        stringBuffer.append("(");
        stringBuffer.append(this.pattern.getId());
        stringBuffer.append("): \"");
        for (int i = 0; i < this.image.length(); ++i) {
            char c = this.image.charAt(i);
            if (Character.isISOControl(c) || i > 25 && this.image.length() > 30) {
                stringBuffer.append("(...)");
                break;
            }
            stringBuffer.append(c);
        }
        stringBuffer.append("\", line: ");
        stringBuffer.append(this.startLine);
        stringBuffer.append(", col: ");
        stringBuffer.append(this.startColumn);
        return stringBuffer.toString();
    }

    public String toShortString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\"');
        for (int i = 0; i < this.image.length(); ++i) {
            char c = this.image.charAt(i);
            if (Character.isISOControl(c) || i > 25 && this.image.length() > 30) {
                stringBuffer.append("(...)");
                break;
            }
            stringBuffer.append(c);
        }
        stringBuffer.append('\"');
        if (this.pattern.getType() == 2) {
            stringBuffer.append(" <");
            stringBuffer.append(this.pattern.getName());
            stringBuffer.append(">");
        }
        return stringBuffer.toString();
    }
}

